/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans;

import com.installshield.beans.ISIntrospector;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class ObjectArrayDictionary
extends Dictionary {
    private Class objectType;
    private PropertyDescriptor keyProperty;
    private Object[] objects;

    public ObjectArrayDictionary(Class clazz, String string) throws IntrospectionException, IllegalArgumentException {
        this.objectType = clazz;
        BeanInfo beanInfo = ISIntrospector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        this.keyProperty = null;
        int n = 0;
        while (this.keyProperty == null && n < propertyDescriptorArray.length) {
            Method method;
            if (propertyDescriptorArray[n].getName().equals(string) && (method = propertyDescriptorArray[n].getReadMethod()) != null) {
                if (method.getParameterTypes().length > 0) {
                    throw new IllegalArgumentException("keyProperty " + string + " is indexed");
                }
                Method method2 = propertyDescriptorArray[n].getWriteMethod();
                if (method2 != null && method2.getParameterTypes().length != 1) {
                    throw new IllegalArgumentException("keyProperty " + string + " has invalid write method");
                }
                this.keyProperty = propertyDescriptorArray[n];
            }
            ++n;
        }
        if (this.keyProperty == null) {
            throw new IllegalArgumentException(String.valueOf(string) + " is not a readable property of " + clazz);
        }
        try {
            this.objects = (Object[])Array.newInstance(clazz, 0);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("cannot create instance of " + clazz + "[]");
        }
    }

    public Enumeration elements() {
        if (this.objects == null) {
            return new Vector().elements();
        }
        Vector<Object> vector = new Vector<Object>();
        Object[] objectArray = this.objects;
        synchronized (objectArray) {
            int n = 0;
            while (n < this.objects.length) {
                vector.addElement(this.objects[n]);
                ++n;
            }
        }
        return vector.elements();
    }

    public Object get(Object object) {
        if (this.objects == null) {
            return null;
        }
        Object[] objectArray = this.objects;
        synchronized (objectArray) {
            int n = 0;
            while (n < this.objects.length) {
                block8: {
                    try {
                        Object object2 = this.keyProperty.getReadMethod().invoke(this.objects[n], new Object[0]);
                        if (object2.equals(object)) {
                            Object object3 = this.objects[n];
                            Object var4_7 = null;
                            return object3;
                        }
                    }
                    catch (Exception exception) {
                        if (System.getProperty("is.debug") == null) break block8;
                        exception.printStackTrace();
                    }
                }
                ++n;
            }
        }
        return null;
    }

    public Object[] getObjects() {
        return this.objects;
    }

    public boolean isEmpty() {
        if (this.objects == null) {
            return true;
        }
        return this.objects.length == 0;
    }

    public Enumeration keys() {
        if (this.objects == null) {
            return new Vector().elements();
        }
        Vector<Object> vector = new Vector<Object>();
        Object[] objectArray = this.objects;
        synchronized (objectArray) {
            int n = 0;
            while (n < this.objects.length) {
                block7: {
                    try {
                        vector.addElement(this.keyProperty.getReadMethod().invoke(this.objects[n], (Object[])new String[0]));
                    }
                    catch (Exception exception) {
                        if (System.getProperty("is.debug") == null) break block7;
                        exception.printStackTrace();
                    }
                }
                ++n;
            }
        }
        return vector.elements();
    }

    public Object put(Object object, Object object2) {
        Object object3;
        if (this.objects == null) {
            return null;
        }
        if (!this.objectType.isAssignableFrom(object2.getClass())) {
            throw new IllegalArgumentException("value must be a " + this.objectType);
        }
        if (this.keyProperty.getWriteMethod() == null) {
            try {
                object3 = this.keyProperty.getReadMethod().invoke(object2, new Object[0]);
                if (!object3.equals(object)) {
                    throw new IllegalArgumentException("key must equal value's " + this.keyProperty.getName() + " property");
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("cannot confirm valid key: " + exception);
            }
        }
        object3 = this.remove(object);
        Object[] objectArray = this.objects;
        synchronized (objectArray) {
            Object[] objectArray2;
            block12: {
                objectArray2 = (Object[])Array.newInstance(this.objectType, this.objects.length + 1);
                System.arraycopy(this.objects, 0, objectArray2, 0, this.objects.length);
                objectArray2[this.objects.length] = object2;
                if (this.keyProperty.getWriteMethod() != null) {
                    try {
                        this.keyProperty.getWriteMethod().invoke(object2, object);
                    }
                    catch (Exception exception) {
                        if (System.getProperty("is.debug") == null) break block12;
                        exception.printStackTrace();
                    }
                }
            }
            this.objects = objectArray2;
        }
        return object3;
    }

    public Object remove(Object object) {
        if (this.objects == null) {
            return null;
        }
        Object object2 = null;
        Object[] objectArray = this.objects;
        synchronized (objectArray) {
            int n = 0;
            while (object2 == null && n < this.objects.length) {
                block8: {
                    try {
                        Object object3 = this.keyProperty.getReadMethod().invoke(this.objects[n], new Object[0]);
                        if (object3.equals(object)) {
                            Object[] objectArray2 = (Object[])Array.newInstance(this.objectType, this.objects.length - 1);
                            object2 = this.objects[n];
                            System.arraycopy(this.objects, 0, objectArray2, 0, n);
                            System.arraycopy(this.objects, n + 1, objectArray2, n, this.objects.length - n - 1);
                            this.objects = objectArray2;
                        }
                    }
                    catch (Exception exception) {
                        if (System.getProperty("is.debug") == null) break block8;
                        exception.printStackTrace();
                    }
                }
                ++n;
            }
        }
        return object2;
    }

    public void setObjects(Object[] objectArray) {
        this.objects = objectArray;
    }

    public int size() {
        if (this.objects == null) {
            return 0;
        }
        return this.objects.length;
    }
}

