/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.wizardbeans.BillboardInfo;
import com.installshield.qjml.PropertyAccessible;
import java.util.Vector;

public class BillboardDisplayInfo
implements PropertyAccessible {
    private String backgroundColor = "SystemColor.blue";
    private boolean enabled = false;
    private BillboardInfo[] billboards = new BillboardInfo[0];
    private Vector cache = new Vector();

    public void addBillboard(BillboardInfo billboardInfo) {
        this.cache.addElement(billboardInfo);
        Object[] objectArray = new BillboardInfo[this.cache.size()];
        this.cache.copyInto(objectArray);
        this.billboards = this.sortBillboardInfos((BillboardInfo[])objectArray);
    }

    public void addBillboard(String string, int n) {
        BillboardInfo billboardInfo = new BillboardInfo();
        billboardInfo.setImageSource(string);
        billboardInfo.setPercentage(n);
        this.addBillboard(billboardInfo);
    }

    private void copyCacheToArray() {
        this.billboards = new BillboardInfo[this.cache.size()];
        this.cache.copyInto(this.billboards);
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public BillboardInfo getBillboardAt(int n) {
        return (BillboardInfo)this.cache.elementAt(n);
    }

    public BillboardInfo[] getBillboards() {
        return this.billboards;
    }

    public int getBillboardsCount() {
        return this.cache.size();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void refreshCache() {
        BillboardInfo[] billboardInfoArray = this.sortBillboardInfos(this.getBillboards());
        this.cache.removeAllElements();
        int n = 0;
        while (n < billboardInfoArray.length) {
            this.cache.addElement(billboardInfoArray[n]);
            ++n;
        }
    }

    public void removeBillboard(BillboardInfo billboardInfo) {
        if (this.cache.contains(billboardInfo)) {
            this.cache.removeElement(billboardInfo);
        }
        this.copyCacheToArray();
    }

    public void setBackgroundColor(String string) {
        this.backgroundColor = string;
    }

    public void setBillboards(BillboardInfo[] billboardInfoArray) {
        this.billboards = billboardInfoArray;
        this.refreshCache();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    private BillboardInfo[] sortBillboardInfos(BillboardInfo[] billboardInfoArray) {
        int n = billboardInfoArray.length;
        int n2 = 0;
        while (n2 < n - 1) {
            int n3 = billboardInfoArray[n2].getPercentage();
            int n4 = n2 + 1;
            while (n4 < n) {
                int n5 = billboardInfoArray[n4].getPercentage();
                if (n3 > n5) {
                    BillboardInfo billboardInfo = billboardInfoArray[n2];
                    billboardInfoArray[n2] = billboardInfoArray[n4];
                    billboardInfoArray[n4] = billboardInfo;
                }
                ++n4;
            }
            ++n2;
        }
        return billboardInfoArray;
    }
}

