/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.beans.ISIntrospector;
import com.installshield.util.ClassLocator;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.io.File;
import java.util.StringTokenizer;

public class ClassUtils {
    private static ClassLocator classLocator = new ClassLocator();

    static {
        ClassUtils.putClassPath(System.getProperty("java.class.path"));
    }

    private static String capitalizeIDs(String string) {
        if (string.equalsIgnoreCase("id")) {
            return "ID";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("id")) {
                stringBuffer.append("ID");
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static void clearClassPath() {
        classLocator.clearClassPath();
    }

    public static String createObjectDisplayName(Object object) {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        String string = null;
        try {
            BeanInfo beanInfo = ISIntrospector.getBeanInfo(clazz);
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            if (beanDescriptor != null) {
                string = beanDescriptor.getDisplayName();
            }
        }
        catch (Throwable throwable) {}
        if (string == null) {
            string = clazz.getName();
        }
        if (string.indexOf(32) == -1) {
            int n = string.lastIndexOf(36);
            if (n == -1) {
                n = string.lastIndexOf(46);
            }
            string = string.substring(n + 1);
            return ClassUtils.formatObjectDisplayName(string);
        }
        return string;
    }

    public static String createPropertyDisplayName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (n == 0) {
                c = Character.toUpperCase(c);
            } else if (stringBuffer.length() > 0 && Character.isUpperCase(c) && (!Character.isUpperCase(string.charAt(n - 1)) || n < string.length() - 1 && !Character.isUpperCase(string.charAt(n + 1)))) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(c);
            ++n;
        }
        return ClassUtils.capitalizeIDs(stringBuffer.toString());
    }

    public static String findClass(String string) {
        return classLocator.findClass(string);
    }

    public static String formatObjectDisplayName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (stringBuffer.length() > 0 && Character.isUpperCase(c) && (!Character.isUpperCase(string.charAt(n - 1)) || n < string.length() - 1 && !Character.isUpperCase(string.charAt(n + 1)))) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getClassFileName(Class clazz) {
        return ClassUtils.getClassFileName(clazz.getName());
    }

    public static String getClassFileName(String string) {
        return String.valueOf(string.replace('.', File.separatorChar)) + ".class";
    }

    public static String getClassName(String string) {
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(n + 1) : string;
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(0, n) : "";
    }

    public static void putClassPath(String string) {
        classLocator.putClassPath(string);
    }

    public static void removeClassPath(String string) {
        classLocator.removeClassPath(string);
    }
}

