/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.commandline;

import com.installshield.wizard.CommandLineBean;
import com.installshield.wizard.CommandLineOption;
import com.installshield.wizard.Wizard;

public class WizardValueOption
extends CommandLineBean {
    private static boolean canRead(String string, int n) {
        return n < string.length();
    }

    private static int consumeChar(String string, int n, char c) throws Exception {
        if (WizardValueOption.canRead(string, n) && string.charAt(n) == c) {
            return n + 1;
        }
        throw new Exception("Expected " + c + " at offset " + n);
    }

    public boolean execute(Wizard wizard, String[] stringArray) {
        if (stringArray.length < 1) {
            wizard.exit(1001, "Invalid command line option: G must have at least one argument");
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                WizardValueOption.processAssignmentExpression(wizard, stringArray[n]);
            }
            catch (Exception exception) {
                System.err.println("Error processing argument to G:  " + exception.getMessage());
            }
            ++n;
        }
        return true;
    }

    public CommandLineOption getOption() {
        return new CommandLineOption("G");
    }

    public boolean isRepeatable() {
        return true;
    }

    private static int parseProperty(String string, int n, String[] stringArray) throws Exception {
        int n2 = n;
        while (WizardValueOption.canRead(string, n) && Character.isJavaIdentifierPart(string.charAt(n))) {
            ++n;
        }
        if (n <= n2) {
            throw new Exception("Expected property at offset " + n);
        }
        stringArray[0] = string.substring(n2, n);
        return n;
    }

    private static String parseValue(String string, int n) {
        if (WizardValueOption.canRead(string, n)) {
            return string.substring(n);
        }
        return "";
    }

    public static void processAssignmentExpression(Wizard wizard, String string) throws Exception {
        String[] stringArray = new String[1];
        int n = 0;
        n = WizardValueOption.parseProperty(string, n, stringArray);
        n = WizardValueOption.consumeChar(string, n, '=');
        String string2 = WizardValueOption.parseValue(string, n);
        wizard.getServices().setValue(stringArray[0], string2);
    }
}

