/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.console;

import com.installshield.util.Progress;
import com.installshield.wizard.AbstractCancelableProgressRenderer;
import com.installshield.wizard.ProgressRenderer;

public class ConsoleProgressRenderer
extends AbstractCancelableProgressRenderer
implements ProgressRenderer {
    private boolean cancelable = false;
    private int ticksPrinted = 0;
    private boolean printedGaugeToConsole = false;
    private boolean consoleProgressDone = false;
    private String oldCaption = "";
    private boolean isStart = true;
    private boolean isProgressComplete = false;

    private int calcTickCount(int n, int n2, int n3) {
        return n / n2 - this.ticksPrinted;
    }

    public void endProgress() {
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public void setCancelable(boolean bl) {
        this.cancelable = bl;
    }

    public void startProgress() {
    }

    public void updateProgress(Progress progress) {
        String string = progress.getStatusDescription();
        if (!this.oldCaption.equals(string) && this.isStart && !this.printedGaugeToConsole) {
            System.out.println();
            System.out.println(string);
            this.oldCaption = string;
            this.isStart = false;
        }
        if (!this.printedGaugeToConsole && progress.getPercentComplete() != 0) {
            System.out.println("|-----------|-----------|-----------|------------|");
            System.out.println("0%         25%         50%         75%        100%");
            this.printedGaugeToConsole = true;
        }
        int n = this.calcTickCount(progress.getPercentComplete(), 2, this.ticksPrinted);
        int n2 = 0;
        while (n2 < n) {
            System.out.print("|");
            ++this.ticksPrinted;
            ++n2;
        }
        if (progress.getPercentComplete() >= 100) {
            this.consoleProgressDone = true;
            if (!this.isProgressComplete) {
                System.out.println();
            }
            if (!this.oldCaption.equals(string)) {
                this.isProgressComplete = true;
                System.out.println();
                System.out.println(string);
                this.oldCaption = string;
            }
        }
    }
}

