/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.console;

import com.installshield.util.LocaleUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.TTYDisplay;
import com.installshield.util.UserInputRequest;
import com.installshield.util.UserInputResponse;
import com.installshield.wizard.RunnableWizardBean;
import com.installshield.wizard.RunnableWizardBeanEvent;
import com.installshield.wizard.RunnableWizardBeanListener;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilder;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardEvent;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.console.ConsoleMode;
import com.installshield.wizard.console.ConsoleProgressRenderer;
import com.installshield.wizard.console.ConsoleWizardBean;
import com.installshield.wizardx.ui.ChoiceComponent;
import com.installshield.wizardx.ui.ChoiceComponentEvent;
import com.installshield.wizardx.ui.ChoiceComponentListener;
import com.installshield.wizardx.ui.TextDisplayComponent;
import java.io.IOException;
import java.util.Locale;

public class ConsoleWizardUI
implements WizardUI,
RunnableWizardBeanListener,
WizardBuilder {
    private String name = "console";
    private Wizard wizard = null;
    private TTYDisplay ttyDisplay = new TTYDisplay();
    private ConsoleProgressRenderer currentProgressRenderer = null;
    private RunnableWizardBean currentRunnableWizardBean = null;
    static /* synthetic */ Class class$com$installshield$wizard$console$ConsoleProgressRenderer;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putPackage("com.installshield.wizard.console");
            wizardBuilderSupport.getWizard().addStartupBean(new ConsoleMode());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean currentBeanChanged(WizardEvent wizardEvent) {
        ConsoleWizardBean consoleWizardBean;
        WizardBean wizardBean = wizardEvent.getWizard().getCurrentBean();
        WizardBeanEvent wizardBeanEvent = new WizardBeanEvent(wizardEvent, this);
        if (wizardBean instanceof ConsoleWizardBean && (consoleWizardBean = (ConsoleWizardBean)((Object)wizardBean)).queryEnter(wizardBeanEvent)) {
            consoleWizardBean.consoleInitialize(wizardBeanEvent);
            if (consoleWizardBean.entered(wizardBeanEvent)) {
                consoleWizardBean.consoleInteraction(wizardBeanEvent);
                while (!consoleWizardBean.queryExit(wizardBeanEvent)) {
                }
                consoleWizardBean.exited(wizardBeanEvent);
            }
            return true;
        }
        return false;
    }

    public void destroy() {
    }

    public Locale getDefaultLocale(Locale[] localeArray, Locale locale) {
        LocaleSelector localeSelector = new LocaleSelector(localeArray, locale);
        return localeSelector.getSelectedLocale();
    }

    public String getName() {
        return this.name;
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public void initialize(Wizard wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException("wizard cannot be null");
        }
        this.wizard = wizard;
    }

    public boolean isStopped() {
        return false;
    }

    public void runnableBeanStarted(RunnableWizardBean runnableWizardBean) {
        this.currentRunnableWizardBean = runnableWizardBean;
        this.currentProgressRenderer = null;
        try {
            this.currentProgressRenderer = (ConsoleProgressRenderer)runnableWizardBean.getProgressRendererImpl(class$com$installshield$wizard$console$ConsoleProgressRenderer != null ? class$com$installshield$wizard$console$ConsoleProgressRenderer : (class$com$installshield$wizard$console$ConsoleProgressRenderer = ConsoleWizardUI.class$("com.installshield.wizard.console.ConsoleProgressRenderer")));
        }
        catch (Exception exception) {}
        if (this.currentProgressRenderer == null) {
            this.currentProgressRenderer = new ConsoleProgressRenderer();
        }
        runnableWizardBean.getState().setWizardRunnableListener(this);
        this.currentProgressRenderer.startProgress();
    }

    public void runnableBeanStopped(RunnableWizardBean runnableWizardBean) {
        if (this.currentProgressRenderer == null) {
            throw new IllegalStateException("currentProgressRenderer is null");
        }
        this.currentProgressRenderer.endProgress();
        this.currentProgressRenderer = null;
        this.currentRunnableWizardBean = null;
    }

    public void runnableWizardBeanStateChanged(RunnableWizardBeanEvent runnableWizardBeanEvent) {
        if (this.currentProgressRenderer == null) {
            throw new IllegalStateException("currentProgressRenderer is null");
        }
        this.currentProgressRenderer.updateProgress(runnableWizardBeanEvent.getBean().getState());
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setStopped(boolean bl) {
    }

    public UserInputResponse userInputRequested(UserInputRequest userInputRequest) {
        Object object;
        int n;
        int n2 = -1;
        String[] stringArray = null;
        if (userInputRequest.getResponseOptions() != null) {
            stringArray = new String[userInputRequest.getResponseOptions().length];
            n = 0;
            while (n < stringArray.length) {
                object = userInputRequest.getResponseOptions()[n].toString();
                if (userInputRequest.getResponseOptions()[n].equals(userInputRequest.getDefaultResponse())) {
                    n2 = n;
                    if (stringArray.length > 1) {
                        object = "*" + (String)object;
                    }
                }
                stringArray[n] = object;
                ++n;
            }
        }
        if (stringArray == null) {
            stringArray = new String[]{LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ok")};
        }
        object = (n = TTYDisplay.queryValue(userInputRequest.getPrompt(), userInputRequest.getTitle(), stringArray, n2, "")) == -1 ? userInputRequest.getDefaultResponse() : (userInputRequest.getResponseOptions() != null ? userInputRequest.getResponseOptions()[n] : stringArray[n]);
        return new UserInputResponse(object);
    }

    private class LocaleSelector
    implements ChoiceComponentListener {
        private ChoiceComponent ch;
        private Locale[] available;
        private Locale selectedLocale;

        public LocaleSelector(Locale[] localeArray, Locale locale) {
            this.available = localeArray;
            this.selectedLocale = locale;
            TextDisplayComponent textDisplayComponent = new TextDisplayComponent("");
            textDisplayComponent.setText(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AWTWizardUI.selectLanguage"));
            textDisplayComponent.consoleInteraction();
            this.ch = new ChoiceComponent();
            String[] stringArray = new String[localeArray.length];
            int n = -1;
            int n2 = 0;
            while (n2 < localeArray.length) {
                stringArray[n2] = LocaleUtils.getLocaleDisplayName(localeArray[n2]);
                if (locale.equals(localeArray[n2])) {
                    n = n2;
                }
                ++n2;
            }
            this.ch.setOptions(stringArray);
            this.ch.setComponentType(1);
            this.ch.setMultipleSelection(false);
            this.ch.setSelectedIndex(n);
            this.ch.addChoiceComponentListener(this);
            this.ch.consoleInteraction();
        }

        public void choiceComponentStateChanged(ChoiceComponentEvent choiceComponentEvent) {
            if (choiceComponentEvent.getSource().equals(this.ch)) {
                int n = choiceComponentEvent.getSelectedIndex();
                this.selectedLocale = this.available[n];
            }
        }

        public Locale getSelectedLocale() {
            return this.selectedLocale;
        }
    }
}

