/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.qjml.QJML;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.StringResolverMethod;
import com.installshield.util.UserInputRequest;
import com.installshield.wizard.service.AbstractWizardServices;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceDef;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceFactory;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.WizardServicesUI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LocalWizardServices
extends AbstractWizardServices {
    private String id;
    private WizardServicesUI ui;
    private Hashtable wizardServices = new Hashtable();
    private Hashtable services = new Hashtable();
    static /* synthetic */ Class class$com$installshield$wizard$service$ServicesDefinition;

    public LocalWizardServices(String string, String string2, ServicesDefinition servicesDefinition, WizardServicesUI wizardServicesUI) {
        super(string, string2, servicesDefinition);
        this.ui = wizardServicesUI;
    }

    protected void addStringResolverMethod(StringResolverMethod stringResolverMethod, int n) {
        this.addStringResolverMethod(stringResolverMethod);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void displayUserMessage(String string, String string2, int n) throws ServiceException {
        if (this.ui == null) {
            throw new ServiceException(317);
        }
        String string3 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ok");
        this.ui.userInputRequested(new UserInputRequest(string, string2, n, new String[]{string3}, string3));
    }

    public Service getService(String string) throws ServiceException {
        Object object = this.services.get(string);
        if (object == null) {
            object = this.loadService(string);
        }
        if (object instanceof Throwable) {
            throw new ServiceException(301, ((Throwable)object).getMessage());
        }
        return (Service)object;
    }

    private ServicesDefinition getServicesDefinition(String string, String string2) throws IOException {
        URL uRL = new URL("archive", "", -1, String.valueOf(string) + "+/" + string2 + "/services.xml");
        return (ServicesDefinition)QJML.read(uRL, class$com$installshield$wizard$service$ServicesDefinition != null ? class$com$installshield$wizard$service$ServicesDefinition : (class$com$installshield$wizard$service$ServicesDefinition = LocalWizardServices.class$("com.installshield.wizard.service.ServicesDefinition")));
    }

    private String getServicesId(String string) throws IOException {
        URL uRL = new URL("archive", "", -1, String.valueOf(string) + "+/wizard.inf");
        InputStream inputStream = uRL.openStream();
        Dictionary dictionary = this.readWizardInfData(inputStream);
        inputStream.close();
        return (String)dictionary.get("RES_ID");
    }

    public Object getUserInput(String string, String string2, Object[] objectArray, Object object) throws ServiceException {
        if (this.ui == null) {
            throw new ServiceException(317);
        }
        UserInputRequest userInputRequest = new UserInputRequest();
        userInputRequest.setTitle(string);
        userInputRequest.setPrompt(string2);
        userInputRequest.setResponseOptions(objectArray);
        if (object != null) {
            userInputRequest.setDefaultResponse(object);
        }
        return this.ui.userInputRequested(userInputRequest).getResponse();
    }

    public WizardServices getWizardServices(String string) throws ServiceException {
        WizardServices wizardServices = (WizardServices)this.wizardServices.get(string);
        if (wizardServices == null) {
            try {
                String string2 = FileUtils.canonizePath(FileUtils.createFileName(FileUtils.getParent(this.getHome()), string));
                String string3 = this.getServicesId(string2);
                if (string3 == null) {
                    throw new ServiceException(320);
                }
                ServicesDefinition servicesDefinition = this.getServicesDefinition(string2, string3);
                wizardServices = new LocalWizardServices(string3, string2, servicesDefinition, this.ui);
                this.wizardServices.put(string, wizardServices);
            }
            catch (IOException iOException) {
                throw new ServiceException(iOException);
            }
        }
        return wizardServices;
    }

    public boolean isServiceAvailable(String string) throws ServiceException {
        Object object = this.services.get(string);
        if (object == null) {
            object = this.loadService(string);
        }
        return object instanceof Service;
    }

    private Object loadService(String string) {
        if (this.getServicesDefinition() == null) {
            return null;
        }
        try {
            Service service = ServiceFactory.createService(string, this.getServicesDefinition(), this);
            this.services.put(string, service);
            return service;
        }
        catch (ServiceException serviceException) {
            return new Throwable("Could not load service:  " + string);
        }
    }

    private Dictionary readWizardInfData(InputStream inputStream) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        while (string != null) {
            int n = string.indexOf(58);
            if (n >= 0) {
                hashtable.put(string.substring(0, n).trim(), string.substring(n + 1).trim());
            }
            string = bufferedReader.readLine();
        }
        return hashtable;
    }

    public Enumeration services() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.getServicesDefinition().services();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((ServiceDef)enumeration.nextElement()).getName());
        }
        return vector.elements();
    }

    public void setWizardServices(String string, WizardServices wizardServices) throws ServiceException {
        if (wizardServices != null) {
            this.wizardServices.put(string, wizardServices);
        } else {
            this.wizardServices.remove(string);
        }
    }

    public void shutdown() {
        Enumeration enumeration = this.services.keys();
        while (enumeration.hasMoreElements()) {
            Service service = (Service)this.services.get(enumeration.nextElement());
            try {
                ServiceFactory.shutdownService(service);
            }
            catch (ServiceException serviceException) {
                System.err.println("ERROR shutting down " + service.getName() + ": " + serviceException);
            }
        }
        super.shutdown();
    }
}

