/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.archive.ArchiveBuilderSupport;
import com.installshield.wizard.service.ServiceBuilderResolver;
import com.installshield.wizard.service.ServiceBuilderSupport;
import com.installshield.wizard.service.ServiceDef;
import com.installshield.wizard.service.ServiceImplementorBuilder;
import com.installshield.wizard.service.ServiceImplementorDef;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.StringResolverMethodDef;
import com.installshield.wizard.service.WizardServices;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ServicesBuilder {
    private String servicesDefName;
    private String[] requiredServices = new String[0];
    private ServiceDef[] availableServices = new ServiceDef[0];
    private ServiceImplementorDef[] availableImplementors = new ServiceImplementorDef[0];
    private StringResolverMethodDef[] resolverMethods = new StringResolverMethodDef[0];
    private ServiceBuilderResolver resolver;
    private WizardServices services;
    private ServiceBuilderSupport serviceSupport = null;
    static /* synthetic */ Class class$com$installshield$wizard$service$ServicesDefinition;

    public ServicesBuilder(String string, ServiceBuilderResolver serviceBuilderResolver, WizardServices wizardServices) {
        if (string == null) {
            throw new IllegalArgumentException("servicesDefName cannot be null");
        }
        this.servicesDefName = string;
        if (serviceBuilderResolver == null) {
            throw new IllegalArgumentException("resolver cannot be null");
        }
        this.resolver = serviceBuilderResolver;
        if (wizardServices == null) {
            throw new IllegalArgumentException("services cannot be null");
        }
        this.services = wizardServices;
    }

    public void build(ArchiveBuilderSupport archiveBuilderSupport) {
        block19: {
            Object object;
            Object object2;
            Object object3;
            Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
            int n = 0;
            while (n < this.requiredServices.length) {
                hashtable.put(this.requiredServices[n], "");
                ++n;
            }
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            this.serviceSupport = new ServiceBuilderSupport(archiveBuilderSupport);
            int n2 = 0;
            while (n2 < this.resolverMethods.length) {
                this.serviceSupport.putStringResolverMethod(this.resolverMethods[n2]);
                ++n2;
            }
            while (!archiveBuilderSupport.isBuildCanceled() && hashtable.size() > 0) {
                int n3 = 0;
                while (n3 < this.availableServices.length) {
                    ServiceDef serviceDef = this.availableServices[n3];
                    if (hashtable.containsKey(serviceDef.getName())) {
                        object3 = this.resolver.getServiceBuilder(serviceDef);
                        if (object3 != null) {
                            object3.build(serviceDef, this.serviceSupport, this.services);
                        } else {
                            this.serviceSupport.logEvent(this, "err", "Service builder not found for " + serviceDef.getName() + " -- cannot build");
                        }
                        hashtable2.put(serviceDef.getName(), "");
                    }
                    ++n3;
                }
                int n4 = 0;
                while (n4 < this.availableImplementors.length) {
                    object3 = this.availableImplementors[n4];
                    if (hashtable.containsKey(((ServiceImplementorDef)object3).getName())) {
                        object2 = this.resolver.getServiceImplementorBuilder((ServiceImplementorDef)object3);
                        if (object2 != null) {
                            object2.build((ServiceImplementorDef)object3, this.serviceSupport, this.services);
                        }
                        int n5 = 0;
                        while (n5 < ((ServiceImplementorDef)object3).getImplCount()) {
                            object = ((ServiceImplementorDef)object3).getImpl(n5);
                            ServiceImplementorBuilder serviceImplementorBuilder = this.resolver.getServiceImplementorBuilder((String)object);
                            if (serviceImplementorBuilder != null) {
                                serviceImplementorBuilder.build((ServiceImplementorDef)object3, this.serviceSupport, this.services);
                            }
                            ++n5;
                        }
                    }
                    ++n4;
                }
                while (hashtable.size() > 0) {
                    object3 = (String)hashtable.keys().nextElement();
                    hashtable.remove(object3);
                    if (hashtable2.containsKey(object3)) continue;
                    archiveBuilderSupport.logEvent(this, "wrn", "Service " + (String)object3 + " is required but is not available");
                }
                object3 = this.serviceSupport.requiredServices();
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    if (hashtable2.containsKey(object2)) continue;
                    hashtable.put(object2, "");
                }
                this.serviceSupport.clearRequiredServices();
            }
            Enumeration enumeration = this.serviceSupport.stringResolverMethods();
            if (archiveBuilderSupport.isBuildCanceled() || hashtable2.size() <= 0 && !enumeration.hasMoreElements()) break block19;
            try {
                ServicesDefinition servicesDefinition = new ServicesDefinition();
                object3 = hashtable2.keys();
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    ServiceDef serviceDef = this.getServiceDef((String)object2);
                    if (serviceDef != null) {
                        servicesDefinition.addService(serviceDef);
                    }
                    if ((object = this.getImplementorDef((String)object2)) == null) continue;
                    servicesDefinition.addImplementor((ServiceImplementorDef)object);
                }
                while (enumeration.hasMoreElements()) {
                    servicesDefinition.addStringResolverMethod((StringResolverMethodDef)enumeration.nextElement());
                }
                this.serviceSupport.putDefinition(servicesDefinition, class$com$installshield$wizard$service$ServicesDefinition != null ? class$com$installshield$wizard$service$ServicesDefinition : (class$com$installshield$wizard$service$ServicesDefinition = ServicesBuilder.class$("com.installshield.wizard.service.ServicesDefinition")), this.servicesDefName);
                this.serviceSupport.putPackage("com.installshield.wizard.service");
                this.serviceSupport.putPackage("com.installshield.wizard.service.qjml");
            }
            catch (IOException iOException) {
                this.serviceSupport.logEvent(this, "err", iOException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ServiceImplementorDef[] getAvailableImplementors() {
        return this.availableImplementors;
    }

    public ServiceDef[] getAvailableServices() {
        return this.availableServices;
    }

    private ServiceImplementorDef getImplementorDef(String string) {
        int n = 0;
        while (n < this.availableImplementors.length) {
            if (this.availableImplementors[n].getName().equals(string)) {
                return this.availableImplementors[n];
            }
            ++n;
        }
        throw new Error();
    }

    public String[] getRequiredServices() {
        return this.requiredServices;
    }

    public ServiceBuilderResolver getResolver() {
        return this.resolver;
    }

    private ServiceDef getServiceDef(String string) {
        int n = 0;
        while (n < this.availableServices.length) {
            if (this.availableServices[n].getName().equals(string)) {
                return this.availableServices[n];
            }
            ++n;
        }
        throw new Error();
    }

    public WizardServices getServices() {
        return this.services;
    }

    public StringResolverMethodDef[] getStringResolverMethods() {
        return this.resolverMethods;
    }

    public Enumeration requiredServices() {
        return this.serviceSupport != null ? this.serviceSupport.requiredServices() : new Vector().elements();
    }

    public void setAvailableImplementors(ServiceImplementorDef[] serviceImplementorDefArray) {
        if (serviceImplementorDefArray == null) {
            throw new IllegalArgumentException("implementors cannot be null");
        }
        this.availableImplementors = serviceImplementorDefArray;
    }

    public void setAvailableServices(ServiceDef[] serviceDefArray) {
        if (serviceDefArray == null) {
            throw new IllegalArgumentException("services cannot be null");
        }
        this.availableServices = serviceDefArray;
    }

    public void setRequiredServices(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("required cannot be null");
        }
        this.requiredServices = stringArray;
    }

    public void setStringResolverMethods(StringResolverMethodDef[] stringResolverMethodDefArray) {
        this.resolverMethods = stringResolverMethodDefArray;
    }
}

