/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service.file;

import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.wizard.service.AbstractServiceImplementor;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileServiceImplementor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Vector;

public class PureJavaFileServiceImpl
extends AbstractServiceImplementor
implements FileServiceImplementor {
    private boolean copyWithAttributes = true;

    public void appendBinaryFile(String string, byte[] byArray) throws ServiceException {
        this.writeBinaryFile(string, byArray, true);
    }

    public void appendToAsciiFile(String string, String[] stringArray) throws ServiceException {
        this.writeAsciiFile(string, stringArray, true);
    }

    public boolean canRead(String string) {
        return new File(string).canRead();
    }

    public boolean comparePaths(String string, String string2) throws ServiceException {
        return FileUtils.comparePaths(string, string2);
    }

    private void copyAttributes(String string, String string2) throws ServiceException {
        block3: {
            if (!this.copyWithAttributes) break block3;
            try {
                this.setFileAttributes(string2, this.getFileAttributes(string));
            }
            catch (ServiceException serviceException) {
                this.copyWithAttributes = false;
                if (serviceException.getErrorCode() != 305) {
                    throw serviceException;
                }
                this.logEvent(this, "wrn", "Unable to duplicate file attributes when copying file(s): " + serviceException.toString());
            }
        }
    }

    public void copyDirectory(String string, String string2, boolean bl, boolean bl2) throws ServiceException {
        File file = new File(string2);
        if (!file.exists()) {
            this.createDirectory(string2);
            this.copyAttributes(string, string2);
        }
        String[] stringArray = this.getDirectoryList(string, 2);
        int n = 0;
        while (n < stringArray.length) {
            String string3 = FileUtils.appendSeparator(string);
            string3 = String.valueOf(string3) + stringArray[n];
            String string4 = FileUtils.appendSeparator(string2);
            string4 = String.valueOf(string4) + stringArray[n];
            if (new File(string3).isDirectory()) {
                if (bl) {
                    this.copyDirectory(string3, string4, bl, bl2);
                }
            } else {
                this.copyFile(string3, string4, bl2);
            }
            ++n;
        }
    }

    public int copyFile(String string, String string2, boolean bl) throws ServiceException {
        if (string.equals(string2)) {
            throw new ServiceException(399, "source and destination cannot be the same");
        }
        try {
            if (!bl && new File(string2).exists()) {
                throw new IOException(String.valueOf(string2) + " exists");
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[1024];
            int n = fileInputStream.read(byArray);
            while (n != -1) {
                fileOutputStream.write(byArray, 0, n);
                n = fileInputStream.read(byArray);
            }
            fileInputStream.close();
            fileOutputStream.close();
            this.copyAttributes(string, string2);
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        return 0;
    }

    public void createAsciiFile(String string, String[] stringArray) throws ServiceException {
        this.writeAsciiFile(string, stringArray, false);
    }

    public void createBinaryFile(String string, byte[] byArray) throws ServiceException {
        this.writeBinaryFile(string, byArray, false);
    }

    public void createDirectory(String string) throws ServiceException {
        String string2 = this.removeTrailingSlash(string);
        File file = new File(string2);
        if (!file.exists() && !file.mkdirs()) {
            throw new ServiceException(315, "could not create directory " + string);
        }
    }

    private String createTimeStamp() {
        return String.valueOf(new Date().getTime());
    }

    public int deleteDirectory(String string) throws ServiceException {
        return this.deleteDirectory(string, true, false);
    }

    public int deleteDirectory(String string, boolean bl, boolean bl2) throws ServiceException {
        File file = new File(FileUtils.normalizeFileName(string));
        if (file.isDirectory() && file.getParent() == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        if (file.isDirectory()) {
            File file2;
            int n;
            String[] stringArray = file.list();
            if (bl && stringArray.length > 0) {
                throw new ServiceException(315, "directory " + string + " is not empty");
            }
            if (!bl2) {
                n = 0;
                while (n < stringArray.length) {
                    file2 = new File(file, stringArray[n]);
                    if (file2.isDirectory()) {
                        throw new ServiceException(315, "directory " + string + " contains subdirectories");
                    }
                    ++n;
                }
            }
            n = 0;
            while (n < stringArray.length) {
                file2 = new File(file, stringArray[n]);
                if (file2.isFile()) {
                    this.deleteFile(file2.getAbsolutePath());
                } else if (file2.isDirectory()) {
                    this.deleteDirectory(file2.getAbsolutePath(), bl, bl2);
                }
                ++n;
            }
            if (!file.delete()) {
                throw new ServiceException(315, "could not delete directory " + string);
            }
        }
        return 0;
    }

    public int deleteFile(String string) throws ServiceException {
        if (new File(string).delete()) {
            return 0;
        }
        throw new ServiceException(315, "could not delete file " + string);
    }

    public boolean fileExists(String string) throws ServiceException {
        return new File(string).exists();
    }

    public String formatSizeAsBytes(long l) throws ServiceException {
        double d = l;
        double d2 = 1048576.0;
        double d3 = 0.0;
        String string = null;
        if ((double)l > d2) {
            d3 = d / d2;
            string = "MB";
        } else {
            d3 = d / 1024.0;
            if (d3 < 1.0 && d3 > 0.0) {
                d3 = 1.0;
            }
            string = "KB";
        }
        String string2 = Double.toString(d3);
        int n = string2.indexOf(".");
        if (n >= 0) {
            int n2 = string2.length();
            int n3 = 0;
            if (string.equals("MB")) {
                n3 = 2;
            }
            if (n2 > n + n3) {
                n2 = n + n3;
            }
            string2 = string2.substring(0, n2);
        }
        return String.valueOf(string2) + string;
    }

    public int getAsciiFileLineCount(String string) throws ServiceException {
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while (bufferedReader.readLine() != null) {
                ++n;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        return n;
    }

    protected String getCurrentDirectory() {
        return System.getProperty("user.dir");
    }

    public String[] getDirectoryList(String string, int n) {
        File file = new File(string);
        Vector<String> vector = new Vector<String>();
        if (file.exists() && file.canRead() && file.isDirectory()) {
            String[] stringArray = file.list();
            int n2 = 0;
            while (n2 < stringArray.length) {
                File file2 = new File(file, stringArray[n2]);
                if ((file2 = new File(file2.getAbsolutePath())).exists() && file2.canRead()) {
                    switch (n) {
                        case 1: {
                            if (!file2.isDirectory()) break;
                            vector.addElement(stringArray[n2]);
                            break;
                        }
                        case 0: {
                            if (!file2.isFile()) break;
                            vector.addElement(stringArray[n2]);
                            break;
                        }
                        case 2: {
                            if (!file2.exists()) break;
                            vector.addElement(stringArray[n2]);
                        }
                    }
                }
                ++n2;
            }
            int n3 = vector.size();
            String[] stringArray2 = new String[n3];
            int n4 = 0;
            while (n4 < n3) {
                stringArray2[n4] = (String)vector.elementAt(n4);
                ++n4;
            }
            return stringArray2;
        }
        return null;
    }

    public FileAttributes getFileAttributes(String string) throws ServiceException {
        throw new ServiceException(305, "getFileAttributes requires native support. ");
    }

    public String getFileOwner(String string) throws ServiceException {
        throw new ServiceException(305, "getFileOwner requires native support. ");
    }

    public String getFileOwnerGroup(String string) throws ServiceException {
        throw new ServiceException(305, "getFileOwnerGroup requires native support. ");
    }

    public int getFileSize(String string) throws ServiceException {
        int n = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            n = fileInputStream.available();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        return n;
    }

    protected String getHomeDirectory() {
        String string = System.getProperty("user.home");
        if (string == null) {
            string = new File(".").getAbsolutePath();
        }
        return string;
    }

    protected String getLibraryDirectory() throws ServiceException {
        throw new ServiceException(305, "getLibraryDirectory requires native support. ");
    }

    protected String getLogFileDirectory() {
        return System.getProperty("user.home");
    }

    public String getNamedDirectory(String string) throws ServiceException {
        if (string.equals("home")) {
            return this.getHomeDirectory();
        }
        if (string.equals("install")) {
            return this.getStandardInstallDirectory();
        }
        if (string.equals("lib")) {
            return this.getLibraryDirectory();
        }
        if (string.equals("log")) {
            return this.getLogFileDirectory();
        }
        if (string.equals("temp")) {
            return this.getTempDirectory();
        }
        if (string.equals("timestamp")) {
            return this.createTimeStamp();
        }
        throw new ServiceException(399, "unknown named directory (" + string + ")");
    }

    public String getParent(String string) {
        return FileUtils.getParent(string);
    }

    public String getPartitionFormat(String string) throws ServiceException {
        throw new ServiceException(305, "getPartitionFormat requires native support. ");
    }

    public long getPartitionFreeSpace(String string) throws ServiceException {
        throw new ServiceException(305, "getPartitionFreeSpace requires native support. ");
    }

    public long getPartitionFreeSpace(String string, long l) throws ServiceException {
        return this.getPartitionFreeSpace(string);
    }

    public String[] getPartitionNames() throws ServiceException {
        throw new ServiceException(305, "getPartitionNames requires native support. ");
    }

    public int getPartitionType(String string) throws ServiceException {
        throw new ServiceException(305, "getPartitionType requires native support. ");
    }

    public String getSeparator() {
        return File.separator;
    }

    protected String getStandardInstallDirectory() throws ServiceException {
        throw new ServiceException(305, "getStandardInstallDirectory requires native support. ");
    }

    public int getSystemCompatibility() {
        return 1;
    }

    protected String getTempDirectory() throws ServiceException {
        throw new ServiceException(305, "getTempDirectory requires native support. ");
    }

    public boolean isDirectory(String string) {
        return new File(string).isDirectory();
    }

    public boolean isDirectoryWritable(String string) throws ServiceException {
        boolean bl;
        Object object2;
        if (!this.fileExists(string)) {
            throw new ServiceException(315, String.valueOf(string) + " does not exist");
        }
        String string2 = FileUtils.createFileName(string, FileUtils.createTempFileName());
        while (this.fileExists(string2)) {
            string2 = FileUtils.createFileName(string, FileUtils.createTempFileName());
        }
        try {
            try {
                object2 = new FileOutputStream(string2);
                ((FileOutputStream)object2).close();
                bl = true;
            }
            catch (IOException iOException) {
                bl = false;
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (this.fileExists(string2)) {
                try {
                    this.deleteFile(string2);
                }
                catch (ServiceException serviceException) {
                    this.logEvent(this, "err", serviceException);
                }
            }
            throw throwable;
        }
        if (this.fileExists(string2)) {
            try {
                this.deleteFile(string2);
            }
            catch (ServiceException object2) {
                this.logEvent(this, "err", object2);
            }
        }
        return bl;
    }

    public int moveFile(String string, String string2, boolean bl) throws ServiceException {
        int n = 0;
        File file = new File(string2);
        if (bl && file.exists() && !file.delete()) {
            throw new ServiceException(315, "could not move file from " + string + " to " + string2 + " because " + string2 + " could not be deleted");
        }
        if (!new File(string).renameTo(file)) {
            try {
                int n2 = this.copyFile(string, string2, bl);
                int n3 = this.deleteFile(string);
                if (n2 == 1 || n3 == 1) {
                    n = 1;
                }
            }
            catch (ServiceException serviceException) {
                throw new ServiceException(315, "could not move file from " + string + " to " + string2 + ": " + serviceException.getMessage());
            }
        }
        return n;
    }

    public String[] readAsciiFile(String string) throws ServiceException {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            objectArray = new BufferedReader(new FileReader(string));
            while ((string2 = objectArray.readLine()) != null) {
                vector.addElement(string2);
            }
            objectArray.close();
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int readAsciiFile(String string, String[] stringArray, int n, int n2) throws ServiceException {
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        int n4 = 0;
        if (stringArray == null) {
            throw new ServiceException(315, "Buffer cannot be null");
        }
        if (stringArray.length < n2) {
            throw new ServiceException(315, "Buffer is smaller than size indicated.");
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while (n > n4 && (string2 = bufferedReader.readLine()) != null) {
                ++n4;
            }
            while (n3 < n2 && (string2 = bufferedReader.readLine()) != null) {
                vector.addElement(string2);
                ++n3;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        vector.copyInto(stringArray);
        return n3;
    }

    public int readBinaryFile(String string, byte[] byArray, int n, int n2) throws ServiceException {
        int n3 = 0;
        if (byArray == null) {
            throw new ServiceException(315, "Buffer cannot be null");
        }
        if (byArray.length < n2) {
            throw new ServiceException(315, "Buffer is smaller than size indicated.");
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            int n4 = randomAccessFile.skipBytes(n);
            if (n4 >= n) {
                byte[] byArray2 = new byte[n2];
                n3 = randomAccessFile.read(byArray2);
                int n5 = 0;
                while (n5 < n3) {
                    byArray[n5] = byArray2[n5];
                    ++n5;
                }
            }
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        return n3;
    }

    private String removeTrailingSlash(String string) {
        String string2 = FileUtils.normalizeFileName(string);
        if (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public void setFileAttributes(String string, FileAttributes fileAttributes) throws ServiceException {
        throw new ServiceException(305, "setFileAttributes requires native support. ");
    }

    public void setFileCreated(String string, long l) throws ServiceException {
        throw new ServiceException(305, "setFileCreated requires native support. ");
    }

    public void setFileExecutable(String string) throws ServiceException {
    }

    public void setFileModified(String string, long l) throws ServiceException {
        throw new ServiceException(305, "setFileModified requires native support. ");
    }

    public void setFileOwner(String string, String string2) throws ServiceException {
        throw new ServiceException(305, "setFileOwner requires native support. ");
    }

    public void setFileOwnerGroup(String string, String string2) throws ServiceException {
        throw new ServiceException(305, "setFileOwnerGroup requires native support. ");
    }

    public void setFileTimes(String string, long l, long l2, long l3) throws ServiceException {
        throw new ServiceException(305, "setFileTimes requires native support. ");
    }

    public boolean supportsLongFileNames(String string) throws ServiceException {
        throw new ServiceException(305, "supportsLongFileNames requires native support. ");
    }

    public void updateAsciiFile(String string, String[] stringArray, int n) throws ServiceException {
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                vector.addElement(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        int n2 = n;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (n2 < vector.size()) {
                vector.setElementAt(stringArray[n3], n2);
            } else {
                vector.addElement(stringArray[n3]);
            }
            ++n2;
            ++n3;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        this.createAsciiFile(string, (String[])objectArray);
    }

    public void updateBinaryFile(String string, byte[] byArray, int n) throws ServiceException {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            randomAccessFile.seek(n);
            randomAccessFile.write(byArray);
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
    }

    private void writeAsciiFile(String string, String[] stringArray, boolean bl) throws ServiceException {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string, bl));
            int n = 0;
            while (n < stringArray.length) {
                printWriter.println(stringArray[n]);
                ++n;
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
    }

    private void writeBinaryFile(String string, byte[] byArray, boolean bl) throws ServiceException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = Math.min(1024, n - n2);
                fileOutputStream.write(byArray, n2, n3);
                n2 += n3;
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
    }
}

