/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ui;

import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class DirectoryBrowser
extends Dialog
implements Observer,
ActionListener,
ItemListener {
    private FileService fs = null;
    private String baseDir = null;
    private Frame parent;
    private TextField _fileNameField;
    private IconListBox11 lb;
    private Choice partitions;
    private boolean finished = false;
    private String dirval = null;
    private Button _OKButton;
    private Button _cancelButton;
    private Insets _ins = null;
    private ResourceBundle _runtimeRes;
    private DirTextDisplay _folderDisplay;
    private DirTextDisplay _partitionsDisplay;
    private String _OKButtonLabel = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryBrowser.OK");
    private String _cancelButtonLabel = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryBrowser.Cancel");
    private String _folderDisplayText = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryBrowser.Folder");
    private String _partitionsDisplayText = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryBrowser.Drives");
    private String sep = null;

    public DirectoryBrowser(Frame frame, String string, FileService fileService) {
        this(frame, string, null, fileService);
    }

    public DirectoryBrowser(Frame frame, String string, String string2, FileService fileService) {
        super(frame, string, true);
        try {
            this.sep = fileService.getSeparator();
        }
        catch (ServiceException serviceException) {
            this.sep = "/";
        }
        this.fs = fileService;
        ((Component)this).setBackground(SystemColor.control);
        this.enableEvents(64L);
        this.parent = frame;
        try {
            if (string2 == null) {
                this.baseDir = fileService.getNamedDirectory("home");
            } else {
                this.setCurrentDirectory(string2);
            }
        }
        catch (ServiceException serviceException) {
            this.baseDir = ".";
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(0, 10));
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        this._folderDisplay = new DirTextDisplay(this._folderDisplayText, this.getFont());
        panel2.add((Component)this._folderDisplay, "North");
        this._fileNameField = new TextField(this.baseDir);
        panel2.add((Component)this._fileNameField, "Center");
        this._fileNameField.addActionListener(this);
        panel.add((Component)panel2, "North");
        try {
            if (fileService.getPartitionNames().length > 0) {
                panel2 = new Panel();
                panel2.setLayout(new BorderLayout());
                this._partitionsDisplay = new DirTextDisplay(this._partitionsDisplayText, this.getFont());
                panel2.add((Component)this._partitionsDisplay, "North");
                this.partitions = new Choice();
                this.partitions.addItemListener(this);
                this.addPartitions(this.partitions, this.baseDir);
                panel2.add((Component)this.partitions, "Center");
                panel.add((Component)panel2, "South");
            }
        }
        catch (ServiceException serviceException) {}
        this.lb = new IconListBox11();
        panel.add((Component)this.lb, "Center");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)panel, gridBagConstraints);
        Panel panel3 = new Panel();
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout(0, 10));
        this._OKButton = new Button(this._OKButtonLabel);
        panel4.add((Component)this._OKButton, "North");
        this._OKButton.addActionListener(this);
        this._cancelButton = new Button(this._cancelButtonLabel);
        panel4.add((Component)this._cancelButton, "Center");
        this._cancelButton.addActionListener(this);
        panel3.add(panel4);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)panel3, gridBagConstraints);
        String string3 = System.getProperty("os.name");
        String string4 = System.getProperty("os.version");
        if (string3.equals("Windows 95") && string4.equals("4.10")) {
            ((Component)this).setSize(434, 238);
        } else {
            this.pack();
            ((Component)this).setSize(this.getPreferredSize());
        }
        this.validate();
        this.setResizable(false);
        Dimension dimension = this.getSize();
        Point point = frame.getLocation();
        Dimension dimension2 = frame.getSize();
        ((Component)this).setLocation(point.x + (dimension2.width - dimension.width) / 2, point.y + (dimension2.height - dimension.height) / 2);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._fileNameField) {
            boolean bl = false;
            if (this._fileNameField.getText().length() != 0) {
                try {
                    this.setCurrentDirectory(this.makePath(this._fileNameField.getText()));
                    bl = this.fs.canRead(this.baseDir);
                }
                catch (ServiceException serviceException) {}
                if (bl) {
                    this.refreshDirList(this.baseDir);
                }
            }
        } else if (actionEvent.getSource() == this._OKButton) {
            if (!this._fileNameField.getText().equals("")) {
                this.finished = true;
                this.dirval = this.makePath(this._fileNameField.getText());
                this.notifyAll();
                this.dispose();
            }
        } else if (actionEvent.getSource() == this._cancelButton) {
            this.finished = true;
            this.dirval = null;
            this.notifyAll();
            this.dispose();
        }
    }

    private void addPartitions(Choice choice, String string) {
        try {
            String[] stringArray = this.fs.getPartitionNames();
            String string2 = null;
            int n = 0;
            while (n < stringArray.length) {
                try {
                    if (this.fs.canRead(stringArray[n])) {
                        choice.addItem(stringArray[n]);
                        if (stringArray[n].regionMatches(true, 0, string, 0, 2)) {
                            string2 = stringArray[n];
                        }
                    }
                }
                catch (ServiceException serviceException) {}
                ++n;
            }
            if (string2 != null) {
                choice.select(string2);
            }
        }
        catch (ServiceException serviceException) {}
    }

    public synchronized String dirName() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.dirval;
    }

    private final void fillupEntries(String string, IconListBox11 iconListBox11) throws ServiceException {
        Object[] objectArray = null;
        boolean bl = false;
        try {
            bl = this.fs.canRead(string);
        }
        catch (ServiceException serviceException) {}
        if (bl) {
            String string2;
            String string3 = this.modifyRootForWindows(string);
            if (string3 != null) {
                objectArray = this.fs.getDirectoryList(string3, 1);
                string2 = string3;
            } else {
                objectArray = this.fs.getDirectoryList(string, 1);
                string2 = string;
            }
            if (objectArray != null) {
                if (this.fs.getParent(string) != null) {
                    iconListBox11.addItem(new FileStructure("..", this.fs.getParent(string)));
                }
                this.sort(objectArray, 0, objectArray.length);
                int n = 0;
                while (n < objectArray.length) {
                    String string4 = this.makePath(string, (String)objectArray[n]);
                    try {
                        if (this.fs.canRead(string4)) {
                            iconListBox11.addItem(new FileStructure((String)objectArray[n], string2));
                        }
                    }
                    catch (ServiceException serviceException) {}
                    ++n;
                }
            }
        }
    }

    public synchronized Insets getInsets() {
        if (this._ins == null) {
            Insets insets = super.getInsets();
            this._ins = new Insets(insets.top + 20, insets.left + 20, insets.right + 20, insets.bottom + 20);
        }
        return this._ins;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.partitions) {
            String string;
            this.baseDir = string = String.valueOf(this.partitions.getSelectedItem()) + this.sep;
            this.refreshDirList(this.baseDir);
            this.parent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private String makePath(String string) {
        return this.makePath(string, "");
    }

    private String makePath(String string, String string2) {
        String string3;
        String string4 = string != null ? string : "";
        String string5 = string3 = string2 != null ? string2 : "";
        if (string4.endsWith(this.sep)) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        if (string3.startsWith(this.sep)) {
            string3 = string3.substring(1, string3.length());
        }
        String string6 = FileUtils.createFileName(string4, string3);
        return string6;
    }

    private String modifyRootForWindows(String string) {
        block8: {
            if (!System.getProperty("os.name").startsWith("Windows")) break block8;
            String string2 = string;
            if (string2.endsWith(":")) {
                string2 = String.valueOf(string2) + "\\.";
            } else if (string2.endsWith(this.sep)) {
                string2 = String.valueOf(string2) + ".";
            }
            String string3 = string2;
            boolean bl = false;
            try {
                bl = this.fs.canRead(string3);
            }
            catch (ServiceException serviceException) {}
            try {
                if (bl && this.fs.isDirectory(string3)) {
                    return string3;
                }
            }
            catch (ServiceException serviceException) {}
        }
        return null;
    }

    protected synchronized void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dirval = null;
            this.finished = true;
            this.notifyAll();
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    private void refreshDirList(String string) {
        this.lb.clear();
        this._fileNameField.setText(string);
        this.parent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.fillupEntries(string, this.lb);
        }
        catch (ServiceException serviceException) {
            serviceException.printStackTrace();
        }
        this.parent.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void run() {
        this.lb.setObserver(this);
        this.pack();
        Point point = this.parent.getLocation();
        if (point != null) {
            ((Component)this).setLocation(point.x + 50, point.y + 50);
        }
        this.show();
    }

    private void setCurrentDirectory(String string) throws ServiceException {
        while (string != null) {
            if (this.fs.isDirectory(string) && this.fs.fileExists(string) && this.fs.canRead(string)) {
                this.baseDir = string;
                break;
            }
            string = this.fs.getParent(string);
        }
        this.refreshDirList(this.baseDir);
    }

    public void setInitialDirectory(String string) throws ServiceException {
        this.setCurrentDirectory(string);
    }

    private void sort(Object[] objectArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n2 > objectArray.length) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.sort((Object[])objectArray.clone(), objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((String)object).toLowerCase();
                String string2 = ((String)object2).toLowerCase();
                int n = string.length();
                int n2 = string2.length();
                int n3 = Math.min(n, n2);
                char[] cArray = new char[n];
                char[] cArray2 = new char[n2];
                string.getChars(0, n, cArray, 0);
                string2.getChars(0, n2, cArray2, 0);
                int n4 = 0;
                int n5 = 0;
                while (n3-- != 0) {
                    char c;
                    char c2;
                    if ((c2 = cArray[n4++]) == (c = cArray2[n5++])) continue;
                    return c2 - c;
                }
                return n - n2;
            }
        }, n, n2);
    }

    private void sort(Object[] objectArray, Object[] objectArray2, Comparator comparator, int n, int n2) {
        int n3 = objectArray2.length;
        if (n > n2) {
            throw new IllegalArgumentException("low(" + n + ") > high(" + n2 + ")");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n2 > n3) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n4 = n2 - n;
        if (n4 < 7) {
            int n5 = n;
            while (n5 < n2) {
                int n6 = n5;
                while (n6 > n && comparator.compare(objectArray2[n6 - 1], objectArray2[n6]) > 0) {
                    Object object = objectArray2[n6];
                    objectArray2[n6] = objectArray2[n6 - 1];
                    objectArray2[n6 - 1] = object;
                    --n6;
                }
                ++n5;
            }
            return;
        }
        int n7 = (n + n2) / 2;
        this.sort(objectArray2, objectArray, comparator, n, n7);
        this.sort(objectArray2, objectArray, comparator, n7, n2);
        if (comparator.compare(objectArray[n7 - 1], objectArray[n7]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n, n4);
            return;
        }
        int n8 = n;
        int n9 = n;
        int n10 = n7;
        while (n8 < n2) {
            objectArray2[n8] = n10 >= n2 || n9 < n7 && comparator.compare(objectArray[n9], objectArray[n10]) <= 0 ? objectArray[n9++] : objectArray[n10++];
            ++n8;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void update(Observable observable, Object object) {
        String string = this.lb.getSelectedItem();
        if (object == null) {
            if (string == null) return;
            if (!string.equals("..")) {
                this._fileNameField.setText(this.makePath(this.baseDir, string));
                return;
            } else {
                this._fileNameField.setText(this.baseDir);
            }
            return;
        }
        try {
            if (string != null && string.equals("..")) {
                String string2 = this.fs.getParent(this.baseDir);
                if (string2 == null) return;
                this.setCurrentDirectory(string2);
            } else {
                this.setCurrentDirectory(this.makePath(this.baseDir, string));
            }
            this.refreshDirList(this.baseDir);
        }
        catch (Exception exception) {}
        this.lb.select(0);
        this.lb.update();
    }

    static interface Comparator {
        public int compare(Object var1, Object var2);
    }

    class IconListBox11
    extends IconBase11
    implements ItemSelectable {
        public int imageWidth = 20;
        public int imageHeight = 15;
        public int[] pixels = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -8684677, -8684677, -8684677, -8684677, -8684677, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -8684677, -4342339, -256, -4342339, -256, -4342339, -8684677, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -8684677, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -1, -1, -1, -1, -1, -1, -8684677, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -1, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -4342339, -256, -8684677, -16777216, -1, -1, -1, -1, -1, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -8684677, -16777216, -1, -1, -1, -1, -1, -1, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        public Image filesImage;
        ActionListener actionListener;
        ItemListener itemListener;
        String commandTopRowChanged = "Top_Row_Changed";
        String commandDoubleClicked = "Double_Clicked";
        private String OSName;
        Font defaultfont = new Font("Dialog", 0, 12);
        private FontMetrics fontMetrics;
        private Observer observer;
        private boolean multipleSelections = false;
        private int prev = -1;
        private int first = 0;
        private int textHigh = 20;
        private Vector items = new Vector();
        private int selected = -1;
        Color listBoxBGColor = Color.white;
        Color colText = Color.black;
        Color colSelText = SystemColor.textHighlightText;
        Color colSelTextBG = SystemColor.textHighlight;
        int nIndentTop = 4;
        int nIndentLeft = 4;
        int nIndentText = 7;
        private Dimension sz = new Dimension(100, 125);
        private Image image = this.createImage(new MemoryImageSource(this.imageWidth, this.imageHeight, ColorModel.getRGBdefault(), this.pixels, 0, this.imageWidth));

        public IconListBox11() {
            this(false);
        }

        public IconListBox11(boolean bl) {
            super(false);
            this.multipleSelections = bl;
            this.setBackground(this.listBoxBGColor);
        }

        public void addActionListener(ActionListener actionListener) {
            this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        }

        public synchronized void addItem(FileStructure fileStructure) {
            this.items.addElement(fileStructure);
            this.updateScrollbar();
        }

        public void addItemListener(ItemListener itemListener) {
            this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        }

        public void addNotify() {
            super.addNotify();
            Font font = this.getFont();
            this.fontMetrics = font != null ? this.getFontMetrics(font) : this.getFontMetrics(this.defaultfont);
            this.textHigh = Math.max(this.imageHeight, this.fontMetrics.getHeight() - 1);
        }

        public synchronized void clear() {
            this.items = new Vector();
            this.selected = -1;
            this.prev = -1;
            this.first = 0;
            this.updateScrollbar();
            this.update();
        }

        private final int countItems() {
            return this.items.size();
        }

        public void draw(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = dimension.height / this.textHigh;
            int n2 = this.items.size();
            graphics.setColor(this.listBoxBGColor);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            int n3 = 0;
            int n4 = this.first;
            while (n4 < n2 && n4 < this.first + n) {
                if (n3 > dimension.height) break;
                if (n3 + this.textHigh >= 0) {
                    this.drawItem(graphics, n4, n3);
                }
                n3 += this.textHigh;
                ++n4;
            }
            this.paintBorder(graphics, 0, 0, dimension.width, dimension.height, false);
        }

        protected void drawItem(Graphics graphics, int n, int n2) {
            try {
                this.drawText(graphics, n, n2);
            }
            catch (Exception exception) {}
        }

        protected void drawText(Graphics graphics, int n, int n2) {
            Rectangle rectangle = this.getBounds();
            if (this.isSelected(n)) {
                graphics.setColor(this.colSelTextBG);
                graphics.fillRect(this.nIndentLeft, n2 + this.nIndentTop, rectangle.width - 2 * this.nIndentLeft, this.textHigh - 1);
                graphics.setColor(this.colSelText);
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(this.nIndentLeft, n2 + this.nIndentTop, rectangle.width - 2 * this.nIndentLeft, this.textHigh - 1);
                graphics.setColor(this.colText);
            }
            if (this.isDirectory(n)) {
                graphics.drawImage(this.image, this.nIndentLeft, n2 + this.nIndentTop, this);
            }
            graphics.drawString(((FileStructure)this.items.elementAt(n)).getName(), this.nIndentText + 20, n2 + this.textHigh);
        }

        public Image getFilesImage() {
            return this.filesImage;
        }

        public String getItem(int n) {
            return ((FileStructure)this.items.elementAt(n)).getName();
        }

        public int getLastVisibleRow() {
            int n = 0;
            int n2 = this.items.size();
            int n3 = 0;
            while (n3 < this.getSize().height && n < n2) {
                if (n > this.first) {
                    n3 += this.textHigh;
                }
                ++n;
            }
            return n - 1;
        }

        protected int getMaxTopRow() {
            Dimension dimension = this.getSize();
            Font font = this.getFont();
            this.fontMetrics = font != null ? this.getFontMetrics(font) : this.getFontMetrics(this.defaultfont);
            this.textHigh = Math.max(this.imageHeight, this.fontMetrics.getHeight());
            return Math.max(0, this.items.size() - (dimension.height - 4) / this.textHigh + 1);
        }

        public Dimension getMinimumSize() {
            return this.sz;
        }

        public Dimension getPreferredSize() {
            return this.sz;
        }

        private int getSelected(int n, int n2) {
            Dimension dimension = super.getSize();
            int n3 = dimension.height / this.textHigh;
            int n4 = this.items.size();
            int n5 = this.textHigh + this.nIndentTop;
            int n6 = this.first;
            while (n6 < n4 && n6 < this.first + n3) {
                if (n2 < n5) {
                    return n6;
                }
                n5 += this.textHigh;
                ++n6;
            }
            return -1;
        }

        public synchronized String getSelectedItem() {
            return this.selected < 0 ? null : ((FileStructure)this.items.elementAt(this.selected)).getName();
        }

        public Object[] getSelectedObjects() {
            return null;
        }

        public boolean isDirectory(int n) {
            return ((FileStructure)this.items.elementAt(n)).isDirectory();
        }

        public synchronized boolean isSelected(int n) {
            return n == this.selected;
        }

        protected boolean mouseDown(MouseEvent mouseEvent, int n, int n2) {
            this.requestFocus();
            int n3 = this.getSelected(n, n2);
            if (this.isSelected(n3) && mouseEvent.getClickCount() == 2) {
                if (this.observer != null) {
                    this.observer.update(null, this);
                }
                return true;
            }
            if (n3 != -1) {
                this.prev = n3;
                this.select(n3);
            }
            return true;
        }

        protected void onTopRowChanged(int n) {
            if (this.first != n) {
                this.first = n;
                this.update();
            }
        }

        private void paintBorder(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
            graphics.setColor(SystemColor.controlLtHighlight);
            if (bl) {
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2, n, n2 + n4);
            } else {
                graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
            }
            graphics.setColor(SystemColor.controlHighlight);
            if (!bl) {
                graphics.drawLine(n + 1, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
                graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + n4 - 2);
            }
            graphics.setColor(SystemColor.controlShadow);
            if (bl) {
                graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
            } else {
                graphics.drawLine(n, n2, n + n3 - 1, n2);
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
            }
            graphics.setColor(SystemColor.controlDkShadow);
            if (bl) {
                graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
                graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
            } else {
                graphics.drawLine(n + 1, n2 + 1, n + n3 - 2, n2 + 1);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 2);
            }
        }

        protected void processActionEvent(ActionEvent actionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(actionEvent);
            }
        }

        protected void processEvent(AWTEvent aWTEvent) {
            switch (aWTEvent.getID()) {
                case 501: {
                    Point point = ((MouseEvent)aWTEvent).getPoint();
                    this.mouseDown((MouseEvent)aWTEvent, point.x, point.y);
                    break;
                }
            }
            super.processEvent(aWTEvent);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (keyEvent.getID() == 401) {
                switch (n) {
                    case 40: {
                        if (this.prev >= this.items.size() - 1) break;
                        this.select(++this.prev);
                        this.scrollToView(this.prev, 1005);
                        break;
                    }
                    case 38: {
                        if (this.prev <= 0) break;
                        this.select(--this.prev);
                        this.scrollToView(this.prev, 1004);
                        break;
                    }
                    case 37: {
                        this.prev = 0;
                        this.select(this.prev);
                        this.scrollToView(this.prev, 1006);
                        break;
                    }
                    case 39: {
                        this.prev = this.items.size() - 1;
                        this.select(this.prev);
                        this.scrollToView(this.prev, 1007);
                        break;
                    }
                }
            }
            super.processKeyEvent(keyEvent);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
        }

        public void scrollToView(int n) {
            if (!this.getVScrollbar().isShowing()) {
                return;
            }
            Scrollbar scrollbar = this.getVScrollbar();
            if (n < this.first) {
                int n2 = scrollbar.getValue() - this.first + n;
                if (n2 < scrollbar.getMinimum()) {
                    n2 = scrollbar.getMinimum();
                }
                scrollbar.setValue(n2);
                this.onTopRowChanged(n2);
            }
        }

        public void scrollToView(int n, int n2) {
            int n3;
            int n4 = this.getLastVisibleRow();
            Scrollbar scrollbar = this.getVScrollbar();
            if (n < this.first && n2 == 1004) {
                n3 = scrollbar.getValue() - 1;
                if (n3 < scrollbar.getMinimum()) {
                    n3 = scrollbar.getMinimum();
                }
                scrollbar.setValue(n3);
                this.onTopRowChanged(n3);
            }
            if (n > n4 - 2 && n2 == 1005) {
                n3 = scrollbar.getValue() + 1;
                if (n3 >= scrollbar.getMaximum()) {
                    n3 = scrollbar.getMaximum();
                }
                if (scrollbar.getMaximum() == 1) {
                    n3 = 0;
                }
                scrollbar.setValue(n3);
                this.onTopRowChanged(n3);
            }
            if (n2 == 1006) {
                n3 = scrollbar.getMinimum();
                scrollbar.setValue(n3);
                this.onTopRowChanged(n3);
            }
            if (n2 == 1007) {
                n3 = scrollbar.getMaximum();
                scrollbar.setValue(n3);
                this.onTopRowChanged(n3);
            }
        }

        public synchronized void select(int n) {
            if (n < 0 || n >= this.countItems()) {
                return;
            }
            if (this.selected != n) {
                this.selected = n;
                this.scrollToView(n);
                if (this.observer != null) {
                    this.observer.update(null, null);
                }
                this.update();
            }
        }

        public void setFilesImage(Image image) {
            this.filesImage = image;
        }

        public void setObserver(Observer observer) {
            this.observer = observer;
            observer.update(null, this);
        }
    }

    class IconBase11
    extends Panel
    implements AdjustmentListener {
        private String OSName;
        protected Scrollbar vs;
        protected Scrollbar hs;
        protected int m_nVScrollbarWidth = 15;
        protected int m_nHScrollbarHeight = 15;
        protected transient Image offscreen = null;
        protected int m_nTopRow = 0;
        protected int m_nLeftCol = 0;
        protected boolean m_bAlwaysShowScrollbar = false;
        protected boolean m_bDoubleBuffering = true;

        public IconBase11() {
            this(false);
            this.setLayout(null);
        }

        public IconBase11(boolean bl) {
            this.m_bAlwaysShowScrollbar = bl;
            this.vs = new Scrollbar(1);
            this.hs = new Scrollbar(0);
            this.vs.addAdjustmentListener(this);
            this.hs.addAdjustmentListener(this);
            this.setLayout(null);
            this.add(this.vs);
            this.add(this.hs);
            this.enableEvents(4L);
            this.enableEvents(16L);
            this.enableEvents(8L);
            this.enableEvents(256L);
            this.enableEvents(32L);
            this.OSName = System.getProperty("os.name");
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (adjustmentEvent.getID() == 601) {
                if (adjustmentEvent.getSource() instanceof Scrollbar && ((Scrollbar)adjustmentEvent.getSource()).getOrientation() == 1) {
                    int n = this.getVScrollbar().getValue();
                    if (this.onTopRowChange(n)) {
                        this.m_nTopRow = n;
                        this.onTopRowChanged(n);
                    }
                } else {
                    int n = this.getHScrollbar().getValue();
                    if (this.onLeftColChange(n)) {
                        this.m_nLeftCol = n;
                        this.onLeftColChanged(n);
                    }
                }
            }
        }

        public synchronized void doLayout() {
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            Scrollbar scrollbar = this.getVScrollbar();
            Scrollbar scrollbar2 = this.getHScrollbar();
            if (this.m_bAlwaysShowScrollbar || this.getMaxTopRow() != 0) {
                scrollbar2.setBounds(0, n2 - this.m_nHScrollbarHeight, n - this.m_nVScrollbarWidth, this.m_nHScrollbarHeight);
            } else {
                scrollbar2.setBounds(0, n2 - this.m_nHScrollbarHeight, n, this.m_nHScrollbarHeight);
            }
            if (this.m_bAlwaysShowScrollbar || this.getMaxLeftCol() != 0) {
                scrollbar.setBounds(n - this.m_nVScrollbarWidth, 0, this.m_nVScrollbarWidth, n2 - this.m_nHScrollbarHeight);
            } else {
                scrollbar.setBounds(n - this.m_nVScrollbarWidth, 0, this.m_nVScrollbarWidth, n2);
            }
        }

        protected void draw(Graphics graphics) {
        }

        public boolean getAlwaysShowScrollbars() {
            return this.m_bAlwaysShowScrollbar;
        }

        public Scrollbar getHScrollbar() {
            return this.hs;
        }

        public int getHScrollbarHeight() {
            return this.m_nHScrollbarHeight;
        }

        protected int getMaxLeftCol() {
            return 0;
        }

        protected int getMaxTopRow() {
            return 0;
        }

        public Dimension getMinimumSize() {
            return new Dimension(100, 80);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.getSize();
            if (dimension.width > 0 && dimension.height > 0) {
                return dimension;
            }
            return this.getMinimumSize();
        }

        public Scrollbar getVScrollbar() {
            return this.vs;
        }

        public int getVScrollbarWidth() {
            return this.m_nVScrollbarWidth;
        }

        public void hideHScrollbar() {
            this.getHScrollbar().setVisible(false);
        }

        public void hideScrollbar() {
            this.hideVScrollbar();
            this.hideHScrollbar();
        }

        public void hideVScrollbar() {
            this.getVScrollbar().setVisible(false);
        }

        public boolean isDoubleBuffering(boolean bl) {
            return this.m_bDoubleBuffering;
        }

        protected boolean onLeftColChange(int n) {
            return true;
        }

        protected void onLeftColChanged(int n) {
            this.repaint();
        }

        protected boolean onTopRowChange(int n) {
            return true;
        }

        protected void onTopRowChanged(int n) {
            this.repaint();
        }

        public void paint(Graphics graphics) {
            if (this.m_bDoubleBuffering && this.validateImage()) {
                Dimension dimension = this.getSize();
                Rectangle rectangle = graphics.getClipBounds();
                Graphics graphics2 = this.offscreen.getGraphics();
                if (rectangle != null) {
                    graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                graphics2.setFont(graphics.getFont());
                graphics2.setColor(this.getBackground());
                graphics2.fillRect(0, 0, dimension.width, dimension.height);
                graphics2.setColor(graphics.getColor());
                this.draw(graphics2);
                graphics.drawImage(this.offscreen, 0, 0, this);
                graphics2.dispose();
            } else {
                this.draw(graphics);
            }
        }

        public void repaint() {
            Dimension dimension = this.getSize();
            int n = dimension.height;
            int n2 = dimension.width;
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.update(graphics, 0, 0, n2, n);
                graphics.dispose();
            }
        }

        public void setAlwaysShowScrollbars(boolean bl) {
            this.m_bAlwaysShowScrollbar = bl;
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            if (n3 <= 0 || n4 <= 0) {
                return;
            }
            super.setBounds(n, n2, n3, n4);
            this.updateScrollbar();
        }

        public void setDoubleBuffering(boolean bl) {
            this.m_bDoubleBuffering = bl;
        }

        public void setHScrollbarHeight(int n) {
            if (n > 0) {
                this.m_nHScrollbarHeight = n;
                this.doLayout();
            }
        }

        public void setVScrollbarWidth(int n) {
            if (n > 0) {
                this.m_nVScrollbarWidth = n;
                this.doLayout();
            }
        }

        public void showHScrollbar() {
            this.getHScrollbar().setVisible(true);
        }

        public void showVScrollbar() {
            this.getVScrollbar().setVisible(true);
        }

        public void update() {
            Dimension dimension = this.getSize();
            int n = dimension.height;
            int n2 = dimension.width;
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.update(graphics, 0, 0, n2, n);
                graphics.dispose();
            }
        }

        public void update(Graphics graphics) {
            if (this.m_bDoubleBuffering) {
                this.paint(graphics);
            } else {
                super.update(graphics);
            }
        }

        public void update(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.clipRect(n, n2, n3, n4);
            this.paint(graphics);
        }

        protected void updateScrollbar() {
            int n;
            int n2 = this.getMaxTopRow();
            int n3 = this.getMaxLeftCol();
            Scrollbar scrollbar = this.getVScrollbar();
            Scrollbar scrollbar2 = this.getHScrollbar();
            if (n2 == 0) {
                this.m_nTopRow = 0;
                if (this.m_bAlwaysShowScrollbar) {
                    scrollbar.setEnabled(false);
                } else {
                    scrollbar.setVisible(false);
                }
            }
            if ((n = n2 / 10) < 5) {
                n = 5;
            }
            scrollbar.setValues(scrollbar.getValue(), 1, 0, n2);
            scrollbar.setBlockIncrement(n);
            scrollbar.setUnitIncrement(1);
            if (n2 > 0) {
                scrollbar.setVisible(true);
            }
            if (n3 == 0) {
                this.m_nLeftCol = 0;
                if (this.m_bAlwaysShowScrollbar) {
                    scrollbar2.setEnabled(false);
                } else {
                    scrollbar2.setVisible(false);
                }
            }
            if ((n = n3 / 10) < 5) {
                n = 5;
            }
            scrollbar2.setValues(scrollbar2.getValue(), 1, 0, n3);
            scrollbar2.setBlockIncrement(n);
            scrollbar2.setUnitIncrement(1);
            if (n3 > 0) {
                scrollbar2.setVisible(true);
            }
            this.doLayout();
            this.update();
        }

        protected boolean validateImage() {
            try {
                Dimension dimension = this.getSize();
                if (this.offscreen == null || this.offscreen.getWidth(this) != dimension.width || this.offscreen.getHeight(this) != dimension.height) {
                    if (dimension.width > 0 && dimension.height > 0) {
                        this.offscreen = this.createImage(dimension.width, dimension.height);
                    } else {
                        return false;
                    }
                }
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    class DirTextDisplay
    extends Canvas {
        String[] words;
        int[] wordLengths;
        private int offset = 0;
        private boolean linear = false;
        int ht;
        int startht;
        int voffset = 0;
        int desc;
        boolean inited = false;
        String text;

        public DirTextDisplay(String string) {
            this(string, new Font("Dialog", 1, 12), 0, 0);
        }

        public DirTextDisplay(String string, Font font) {
            this(string, font, 0, 0);
        }

        public DirTextDisplay(String string, Font font, int n) {
            this(string, font, 0, 0);
        }

        public DirTextDisplay(String string, Font font, int n, int n2) {
            this.text = string;
            if (font != null) {
                this.setFont(font);
            }
            this.offset = n;
            this.voffset = n2;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.getSize();
            int n = dimension.width;
            if (!this.linear && n == 0) {
                n = 300;
            }
            if (!this.inited) {
                this.init();
            }
            int n2 = this.offset;
            int n3 = this.startht;
            int n4 = 0;
            while (n4 < this.words.length) {
                int n5;
                int n6 = n5 = this.wordLengths[n4] < 0 ? -this.wordLengths[n4] : this.wordLengths[n4];
                if (!this.linear && n < n2 + n5) {
                    n2 = this.offset;
                    n3 += this.ht;
                    if (n5 > n) {
                        n = n5;
                    }
                }
                if (this.wordLengths[n4] <= 0) {
                    n2 = this.offset;
                    n3 += this.ht;
                } else {
                    n2 += this.wordLengths[n4];
                }
                ++n4;
            }
            if (this.linear) {
                n = n2;
            }
            dimension = new Dimension(n, n3 + this.desc);
            return dimension;
        }

        private final void init() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.startht = fontMetrics.getAscent() + this.voffset;
            this.ht = fontMetrics.getHeight();
            this.desc = fontMetrics.getDescent();
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(this.text, " \r\t");
            while (stringTokenizer.hasMoreElements()) {
                vector.addElement(stringTokenizer.nextElement());
            }
            this.words = new String[vector.size()];
            this.wordLengths = new int[vector.size()];
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.endsWith("\n")) {
                    this.words[n] = string.replace('\n', ' ');
                    this.wordLengths[n] = -fontMetrics.stringWidth(string);
                } else {
                    this.words[n] = string = String.valueOf(string) + " ";
                    this.wordLengths[n] = fontMetrics.stringWidth(string);
                }
                ++n;
            }
            this.inited = true;
        }

        public void makeLinear() {
            this.linear = true;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (!this.inited) {
                this.init();
            }
            int n = this.offset;
            int n2 = this.startht;
            int n3 = 0;
            while (n3 < this.words.length) {
                int n4;
                int n5 = n4 = this.wordLengths[n3] < 0 ? -this.wordLengths[n3] : this.wordLengths[n3];
                if (dimension.width < n + n4) {
                    n = this.offset;
                    if ((n2 += this.ht) > dimension.height) {
                        return;
                    }
                }
                graphics.drawString(this.words[n3], n, n2);
                if (this.wordLengths[n3] <= 0) {
                    n = this.offset;
                    n2 += this.ht;
                } else {
                    n += this.wordLengths[n3];
                }
                ++n3;
            }
        }

        public synchronized void setText(String string) {
            this.text = string;
            this.inited = false;
            this.repaint();
        }

        public synchronized void setText(String string, int n) {
            this.text = string;
            this.offset = n;
            this.inited = false;
            this.repaint();
        }
    }

    class FileStructure {
        String name;
        String parent;
        boolean isDirectory = false;

        public FileStructure(String string, String string2) {
            this.name = string;
            this.parent = string2;
            File file = new File(string2, string);
            this.isDirectory = !file.isFile();
        }

        public String getName() {
            return this.name;
        }

        public String getParent() {
            return this.parent;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }
    }
}

