/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ui;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.FlowLabel;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizardx.ui.AWTUIComponent;
import com.installshield.wizardx.ui.AbstractUIComponent;
import com.installshield.wizardx.ui.ConsoleUIComponent;
import com.installshield.wizardx.ui.DirectoryBrowser;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class DirectoryInputComponent
extends AbstractUIComponent
implements AWTUIComponent,
ConsoleUIComponent,
ActionListener {
    private String directoryName = "";
    private TextField directoryField;
    private Button browseButton;
    private DirectoryBrowser dirBrowser;
    private Frame parentFrame;
    private FileService fileService;
    private Vector actionListeners = new Vector();
    private Vector textListeners = new Vector();
    private boolean isInitialized = false;

    public DirectoryInputComponent() {
        this("", null, null);
    }

    public DirectoryInputComponent(String string, Frame frame, FileService fileService) {
        this.directoryName = string;
        this.parentFrame = frame;
        this.fileService = fileService;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.browseButton.equals(object)) {
            this.browseForDirectory();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.directoryField != null && actionListener != null) {
            this.directoryField.addActionListener(actionListener);
        }
        this.actionListeners.addElement(actionListener);
    }

    public void addTextListener(TextListener textListener) {
        if (this.directoryField != null && textListener != null) {
            this.directoryField.addTextListener(textListener);
        }
        this.textListeners.addElement(textListener);
    }

    private void browseForDirectory() {
        if (this.dirBrowser == null) {
            this.initDirBrowser();
        }
        try {
            String string = this.directoryField.getText();
            this.dirBrowser.setInitialDirectory(string);
            this.dirBrowser.run();
            if (this.dirBrowser.dirName() != null) {
                this.setDirectoryName(this.dirBrowser.dirName());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void consoleInteraction() {
        String string = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryInputComponent.specifyDirectory");
        TTYDisplay.showNewline();
        String string2 = this.getDirectoryName();
        if (string2.trim().equals("")) {
            string2 = "/";
        }
        String string3 = TTYDisplay.queryValue(string, string2, "");
        this.setDirectoryName(string3);
        ActionEvent actionEvent = new ActionEvent(this, 1001, string3);
        TextEvent textEvent = new TextEvent(this, 900);
        int n = 0;
        while (n < this.actionListeners.size()) {
            ((ActionListener)this.actionListeners.elementAt(n)).actionPerformed(actionEvent);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.textListeners.size()) {
            ((TextListener)this.textListeners.elementAt(n2)).textValueChanged(textEvent);
            ++n2;
        }
    }

    public void createComponentUI() {
        this.isInitialized = true;
        Panel panel = new Panel();
        panel.setLayout(new ColumnLayout(4));
        String string = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryInputComponent.DirectoryName");
        FlowLabel flowLabel = new FlowLabel(string);
        panel.add((Component)flowLabel, new ColumnConstraints(1, 1));
        this.directoryField = new TextField(0);
        this.directoryField.setText(this.directoryName);
        this.directoryField.requestFocus();
        panel.add((Component)this.directoryField, ColumnConstraints.createHorizontalFill());
        this.browseButton = new Button(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "browse"));
        panel.add((Component)this.browseButton, new ColumnConstraints(1, 1));
        this.browseButton.addActionListener(this);
        this.directoryField.addActionListener(this);
        this.add((Component)panel, "Center");
    }

    String getCaption() {
        return "$L(com.installshield.wizardx.i18n.WizardXResources, DirectoryInputComponent.DirectoryName)";
    }

    public String getDirectoryName() {
        if (this.isInitialized && this.directoryField != null) {
            this.directoryName = this.directoryField.getText();
        }
        return this.directoryName;
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public TextField getInputComponent() {
        return this.directoryField;
    }

    public static Frame getParentFrame(Component component) {
        if (component == null) {
            String string = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "getParentFrameError");
            throw new IllegalArgumentException(string);
        }
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (container instanceof Frame) {
            return (Frame)container;
        }
        return DirectoryInputComponent.getParentFrame(container);
    }

    private void initDirBrowser() {
        Frame frame = DirectoryInputComponent.getParentFrame(this.browseButton);
        String string = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryInputComponent.selectDirectory");
        try {
            this.dirBrowser = new DirectoryBrowser(frame, string, this.fileService);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        DirectoryInputComponent directoryInputComponent = new DirectoryInputComponent();
        if (stringArray.length > 0) {
            directoryInputComponent.consoleInteraction();
        } else {
            Frame frame = new Frame("Testing Directory input component...");
            frame.add((Component)directoryInputComponent, "North");
            ((Component)frame).setSize(250, 300);
            ((Component)frame).setVisible(true);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionListeners == null || this.actionListeners.size() <= 0) {
            return;
        }
        this.actionListeners.removeElement(actionListener);
    }

    public void removeTextListener(TextListener textListener) {
        if (this.textListeners == null || this.textListeners.size() <= 0) {
            return;
        }
        this.textListeners.removeElement(textListener);
    }

    public void setDirectoryName(String string) {
        this.directoryName = string;
        if (this.isInitialized && this.directoryField != null) {
            this.directoryField.setText(string);
        }
    }

    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }
}

