#!/bin/bash

# **************************************************************************
# *                                 IBM
# *                               5648-D85
# *                     (c) Copyright IBM Corp 2000, 2001
# *
# **************************************************************************/

#

DEFAULT_INSTALL_LOCATION="/usr/local/NetVista/"
JAVA_SUB="TCM/IBMJava2-13/jre/bin/java"

#Is this root?
USER_NAME=`whoami`
if test "${USER_NAME}" != "root"
then
	echo "You must be root to install TCM."
	exit 1
fi

echo ""
echo "**********************************************************"
echo "* Please do not close this xTerm session until the"
echo "* 'Install script complete' message is displayed."
echo "**********************************************************"
echo ""

# Is TCM already installed
if test -e /usr/bin/runTCMGUI
then
	CURRENT_INSTALL_LOCATION=`/usr/bin/runTCMGUI -w`
	alreadyInstalled=1
else
	CURRENT_INSTALL_LOCATION=""
	alreadyInstalled=0
fi

# TCM is installed
if test -n "${CURRENT_INSTALL_LOCATION}" 
then
	echo ""
	echo "Setup detected the current version of this product on your" 
	echo "system. The current install location is '${CURRENT_INSTALL_LOCATION}'."  
	echo "Would you like to continue Setup and overwrite the current"
	echo "installation? (y/n)[y]"
	echo ""
	read REPLY
	if test "${REPLY}" = "n" -o "${REPLY}" = "N" 
	then
		exit 0
	fi
	# Must be OK to do an inplace install
	if test -e /etc/rc.d/init.d/startTCM
	then
		/etc/rc.d/init.d/startTCM stop
	fi
	TARGET_INSTALL_LOCATION="${CURRENT_INSTALL_LOCATION}"

	# Check for / at end of path.  Add if not there
	mkdir -p ${TARGET_INSTALL_LOCATION}TCM_Test
	if test ! -d ${TARGET_INSTALL_LOCATION}/TCM_Test
	then
		/bin/rm -rf ${TARGET_INSTALL_LOCATION}TCM_Test
		TARGET_INSTALL_LOCATION="${TARGET_INSTALL_LOCATION}/"
	else
		/bin/rm -rf ${TARGET_INSTALL_LOCATION}/TCM_Test
	fi

	if test ! -d ${TARGET_INSTALL_LOCATION}TCM
	then	
		mkdir -p ${TARGET_INSTALL_LOCATION}TCM
	fi


# TCM is NOT installed
else 
	echo ""
	echo "Please enter the directory where you want to install TCM."
	echo "The default directory is '${DEFAULT_INSTALL_LOCATION}'."
	echo "Press enter to install in the default directory."
	echo ""
	loopSwitch=1
	while test ${loopSwitch} -eq 1
	do
		echo "Current location for TCM is [${DEFAULT_INSTALL_LOCATION}]: "
		read TARGET_INSTALL_LOCATION
		# Did they enter anything?
		if test -z "${TARGET_INSTALL_LOCATION}"	
		then
			# No, set target to default location
			TARGET_INSTALL_LOCATION="${DEFAULT_INSTALL_LOCATION}"
		fi
	
		loopSwitch=0
		if test ! -d ${TARGET_INSTALL_LOCATION}	
		then
			echo ""
			echo "The directory: '${TARGET_INSTALL_LOCATION}'"
			echo "does not exist.  Do you want the directory to be created? (y/n)[y]"
			read REPLY
			if test "${REPLY}" = "n" -o "${REPLY}" = "N" 
			then
				loopSwitch=1
			else
				mkdir -p ${TARGET_INSTALL_LOCATION}
				if test $? -ne 0 
				then
					echo "ERROR: There was a problem creating '${TARGET_INSTALL_LOCATION}'."
					exit 2
				fi

				# Check for / at end of path.  Add if not there
				mkdir -p ${TARGET_INSTALL_LOCATION}TCM_Test
				if test ! -d ${TARGET_INSTALL_LOCATION}/TCM_Test
				then
					/bin/rm -rf ${TARGET_INSTALL_LOCATION}TCM_Test
					#/bin/rm -rf ${TARGET_INSTALL_LOCATION}
					TARGET_INSTALL_LOCATION="${TARGET_INSTALL_LOCATION}/"
					#mkdir -p ${TARGET_INSTALL_LOCATION}
					#if test $? -ne 0 
					#then
					#	echo "ERROR: There was a problem creating '${TARGET_INSTALL_LOCATION}'."
					#	exit 2
					#fi
				else
					/bin/rm -rf ${TARGET_INSTALL_LOCATION}/TCM_Test
				fi

				mkdir -p ${TARGET_INSTALL_LOCATION}TCM
				if test $? -ne 0 
				then
					echo "ERROR: There was a problem creating '${TARGET_INSTALL_LOCATION}TCM'."
					exit 2
				fi
			fi
		else
			echo ""
			echo "'${TARGET_INSTALL_LOCATION}' already Exists."
			echo ""
			echo "The contents of '${TARGET_INSTALL_LOCATION}' may be modified"
			echo "or replaced if you install in '${TARGET_INSTALL_LOCATION}'."
			echo "By selecting 'n' you will be prompted for a different"
			echo "directory."
			echo ""
			echo "Do you want to install in '${TARGET_INSTALL_LOCATION}' anyway? (y/n)[y]"
			read REPLY
			if test "${REPLY}" = "n" -o "${REPLY}" = "N" 
			then
				loopSwitch=1
			else
				# Check for / at end of path.  Add if not there
				mkdir -p ${TARGET_INSTALL_LOCATION}TCM_Test
				if test ! -d ${TARGET_INSTALL_LOCATION}/TCM_Test
				then
					/bin/rm -rf ${TARGET_INSTALL_LOCATION}TCM_Test
					TARGET_INSTALL_LOCATION="${TARGET_INSTALL_LOCATION}/"
				else
					/bin/rm -rf ${TARGET_INSTALL_LOCATION}/TCM_Test
				fi

				if test ! -d ${TARGET_INSTALL_LOCATION}TCM
				then	
					mkdir -p ${TARGET_INSTALL_LOCATION}TCM
				fi
			fi
		fi
   	done
	#
	#
	# Begin the installation.
	#
fi

touch ${TARGET_INSTALL_LOCATION}TCM/IBM_Install_Test.txt

# Install Java
echo "Installing required JVM."
#`rpm -U --nodeps --force --prefix ${TARGET_INSTALL_LOCATION}TCM IBMJava2-JRE-1.3-9.0.i386.rpm`

tar -xzf IBMJava2-JRE-13-9.0.tgz -C ${TARGET_INSTALL_LOCATION}TCM 

loopSwitch=1
while test ${loopSwitch} -eq 1
do

	# Install TCM
	unset CLASSPATH
	echo "Starting TCM install."
	RC=`${TARGET_INSTALL_LOCATION}${JAVA_SUB} -cp installTCM.jar run -P product.installLocation=${TARGET_INSTALL_LOCATION} 2> ${TARGET_INSTALL_LOCATION}error.log`
	echo ${RC}
	# Did TCM install
	#if test -e /usr/bin/runTCMGUI
	#then 

 	if test -e ${TARGET_INSTALL_LOCATION}TCM/IBM_Install_Test.txt
	then
		if test ${alreadyInstalled} -eq 0
		then
			echo "The TCM install was canceled before completion."
			echo "Do you want to restart the TCM install? (y/n)[n]"
			read REPLY
			if test "${REPLY}" = "y" -o "${REPLY}" = "Y" 
			then
				echo "Restarting Install"
			else
				echo "Cleaning up partial install."
				# rpm -e IBMJava2-JRE-1.3-9.0
				/bin/rm -rf ${TARGET_INSTALL_LOCATION}TCM/IBMJava2-13
   				/bin/rm -f ${TARGET_INSTALL_LOCATION}TCM/IBM_Install_Test.txt
				loopSwitch=0
				echo "Cleanup complete."
			fi
		else
			echo "The TCM install was canceled before completion."
			echo "Do you want to restart the TCM install? (y/n)[n]"
			read REPLY
			if test "${REPLY}" = "y" -o "${REPLY}" = "Y" 
			then
				echo "Restarting Install"
			else
   				/bin/rm -f ${TARGET_INSTALL_LOCATION}TCM/IBM_Install_Test.txt
				#`/etc/rc.d/init.d/startTCM start`
				echo "TCM services have been stopped.  Enter:"
				echo ""
				echo "startTCM start to restart."
				loopSwitch=0
			fi
		fi
	else
		loopSwitch=0
	fi

done

echo ""
echo "*******************************"
echo "* Install script complete."
echo "*******************************"

exit 0
