Const Eth0				= "Intel(R) PRO/1000"	' String of the device to search for
Const Eth1				= "Intel(R) 82566"	' String of the device to search for
Const Eth2				= "Broadcom NetXtreme"	' String of the device to search for
Const Eth3				= "Broadcom NetLink"	' String of the device to search for
Const Eth4				= "Realtek RTL8139/810x" ' String of the device to search for
Const Powercfg_QueryWakeProgrammable	= "POWERCFG -DEVICEQUERY wake_programmable"
Const Powercfg_QueryWakeArmed		= "POWERCFG -DEVICEQUERY wake_armed"
Const Powercfg_WakeArm			= "POWERCFG -DEVICEENABLEWAKE"
Const Powercfg_WakeDisarm		= "POWERCFG -DEVICEDISABLEWAKE"
Const strEnable				= "ENABLE"		' MUST be upper case for ease
Const strDisable			= "DISABLE"		' MUST be upper case for ease
Const EnableRequest			= 0
Const DisableRequest			= 1
Const QueryRequest			= 2

Dim DeviceString						' Used to wake-disarm the device
Dim RequestCmd							' Any of EnableRequest/DisableRequest/QueryRequest

Dim TargetDevice
Dim strOnboardEtherNames
Dim EthLoop
strOnboardEtherNames = Array(Eth0, Eth1, Eth2, Eth3, Eth4)

Set WSHShell = WScript.CreateObject( "WScript.Shell" )

'
' Check arguments
'
If WScript.Arguments.Count = 0 Then
	RequestCmd = QueryRequest
Else
	If UCase( WScript.Arguments.Item(0) ) = strEnable Then
		RequestCmd = EnableRequest
	ElseIf UCase( WScript.Arguments.Item(0) ) = strDisable Then
		RequestCmd = DisableRequest
	ElseIf Instr( WScript.Arguments.Item(0), "?" ) Then
		call HowToUse
		WScript.Quit
	Else
		WScript.Echo "Invalid Request: " + UCase( WScript.Arguments.Item(0) )
		WScript.Echo
		call HowToUse
		WScript.Quit
	End If
End If


'
' Run POWERCFG to query the device which is wake_programmable
'
Set PCOut = WSHShell.Exec( Powercfg_QueryWakeProgrammable )
If FindEthernetDevice( PCOut.StdOut ) Then
	' wake-programmable device is found
	Set PCOut = WSHShell.Exec( Powercfg_QueryWakeArmed )
	If IsWakeArmedEthernetDevice( PCOut.StdOut ) Then
		' Wake armed

		If RequestCmd = EnableRequest Then
			' Requested to wake-arm
			WScript.Echo "Already wake-armed..."
		ElseIf RequestCmd = DisableRequest Then
			' Requested to wake-disarm
			If Len( DeviceString) Then

				WakeDisarmCmd = Powercfg_WakeDisarm + " " + chr(&H22) + DeviceString + chr(&H22)
				Set PCOut = WSHShell.Exec( WakeDisarmCmd )
				If PCOut.ExitCode <> 0 Then
					WScript.Echo "Failed to wake-disable: "
					WScript.Echo PCOut.ExitCode
				Else
					WScript.Echo "Now Wake-Disarmed!!"
				End If

			Else
				' DeviceString is not initialized...
				WScript.Echo "ERROR: DeviceString is not initialized..."
			End If
		Else	' Assume QueryRequest
			WScript.Echo "Wake-Armed!!"
		End If

	Else
		' Wake disarmed

		If RequestCmd = EnableRequest Then
			' Requested to wake-arm
			If Len( DeviceString) Then

				WakeArmCmd = Powercfg_WakeArm + " " + chr(&H22) + DeviceString + chr(&H22)
				Set PCOut = WSHShell.Exec( WakeArmCmd )
				If PCOut.ExitCode <> 0 Then
					WScript.Echo "Failed to wake-denable: "
					WScript.Echo PCOut.ExitCode
				Else
					WScript.Echo "Now Wake-Armed!!"
				End If

			Else
				' DeviceString is not initialized...
				WScript.Echo "ERROR: DeviceString is not initialized..."
			End If
		ElseIf RequestCmd = DisableRequest Then
			' Requested to wake-disarm
			WScript.Echo "Already wake-disarmed..."
		Else	' Assume QueryRequest
			WScript.Echo "Wake-Disarmed!!"
		End If

	End If
Else
	' No wake-programmable device is found
	WScript.Echo "NotFound..."
End If



'------------------------------------------------------------------
'
' FindEthernetDevice: To find On-Board Ethernet
'
'------------------------------------------------------------------
Function FindEthernetDevice( StdOutput )
	DO UNTIL StdOutput.AtEndOfStream
		wake_programmable_device = StdOutput.ReadLine
'DEBUG		WScript.Echo wake_programmable_device 	'DEBUG
		'
		' Search for the network controller to be disabled
		'
		For EthLoop = 0 to UBound(strOnboardEtherNames)
			TargetDevice = strOnboardEtherNames(EthLoop)
			If InStr( wake_programmable_device, TargetDevice ) <> 0 Then
				WScript.Echo "Found: " + wake_programmable_device
				DeviceString = wake_programmable_device
				FindEthernetDevice = TRUE
				Exit Function
			End If
		Next
	LOOP

	FindEthernetDevice = FALSE
End Function

'------------------------------------------------------------------
'
' IsWakeArmedEthernetDevice: To check if On-Board Ethernet is wake-armed
'
'------------------------------------------------------------------
Function IsWakeArmedEthernetDevice( StdOutput )
	DO UNTIL StdOutput.AtEndOfStream
		wake_armed_device = StdOutput.ReadLine
'DEBUG		WScript.Echo "WakeArmed: " + wake_armed_device 	'DEBUG

		For EthLoop = 0 to UBound(strOnboardEtherNames)
			TargetDevice = strOnboardEtherNames(EthLoop)
			If InStr( wake_armed_device, TargetDevice ) <> 0 Then
				IsWakeArmedEthernetDevice = TRUE
				Exit Function
			End If
		Next
	LOOP

	IsWakeArmedEthernetDevice = FALSE
End Function

Sub HowToUse
	WScript.Echo "This script is to control wake-arm or wake-disarm the device."
	WScript.Echo "Note that it must be run on the evelated command prompt."
	WScript.Echo
	WScript.Echo "cscript test.vbs ENABLE|DISABLE"
End Sub

