/****************************************************************************
 * Copyright(c) 2000 Broadcom Corporation, all rights reserved
 * Proprietary and Confidential Information.
 *
 * This source file is the property of Broadcom Corporation, and
 * may not be copied or distributed in any isomorphic form without 
 * the prior written consent of Broadcom Corporation. 
 *
 * Name:        blfcore.h
 *
 * Description: External interface definition of the BASP core driver.
 *
 * Author:      Frankie Fan
 *
 * $Log:: /Source/basplnx/blfcore.h                                 $
 * 
 * 3     5/24/01 6:33p Ffan
 * Added proc fs support.
 * 
 * 2     12/26/00 4:11p Ffan
 * Added a blank line to the end of the file to clean up compilation
 * warning message.
 * 
 * 1     12/01/00 5:55p Ffan
 * Initial check-in.
 *
 ****************************************************************************/
#ifndef __blfcore_h__
#define __blfcore_h__

//
// initialization
//
int
blf_core_init(
    int mgmt_major
    );

void
blf_core_fini(
    void
    );

//
// management device ioctl handler
//
int
blf_core_mgmt_ioctl(
    unsigned int cmd,
    void* arg
    );

int
blf_core_proc_read(
    char* page,
    char** start,
    int offset,
    int count,
    int* eof,
    void* ctx
    );

#endif  // __blfcore_h__
