/****************************************************************************
 * Copyright(c) 2000 Broadcom Corporation, all rights reserved
 * Proprietary and Confidential Information.
 *
 * This source file is the property of Broadcom Corporation, and
 * may not be copied or distributed in any isomorphic form without 
 * the prior written consent of Broadcom Corporation. 
 *
 * Name:        blfver.h
 *
 * Description: version header for BASP Linux driver
 *
 * Author:      Frankie Fan
 *
 * Created:     September 1, 2000
 *
 ****************************************************************************/
#ifndef __blfver_h__
#define __blfver_h__

#define BLF_VERSION_MAJOR       6
#define BLF_VERSION_MINOR       2
#define BLF_VERSION_BUILD       2

#define BLF_PRODUCT_NAME        \
    "Broadcom Advanced Server Program Driver for Linux"

#define BLF_PRODUCT_COMPANY     \
    "Broadcom Corporation"

#define _blfver_StringIt1(x)    #x
#define _blfver_StringIt(x)     _blfver_StringIt1(x)
#define _blfver_U32It(mj,mn,bld)    (   \
    (((mj)&0x000000FFL)<<24) |          \
    (((mn)&0x000000FFL)<<16) |          \
    ((bld)&0x0000FFFFL)                 \
    )

#define BLF_VERSION_STRING      _blfver_StringIt(BLF_VERSION_MAJOR) "." \
                                _blfver_StringIt(BLF_VERSION_MINOR) "." \
                                _blfver_StringIt(BLF_VERSION_BUILD)

#define BLF_VERSION             _blfver_U32It( BLF_VERSION_MAJOR, \
                                               BLF_VERSION_MINOR, \
                                               BLF_VERSION_BUILD )

#endif  /* __blfver_h__ */

/****************************************************************************
 *  End of file
 ****************************************************************************/
