.include 'tao.inc'
.include 'kernel/native.inc'

.asmcode 'VP/ARM2'

node tl_gui_init,TOOLTP,VP,TEMPLATE	;tool object
	tool 'GUI/INITVIDC'
	;arm vidc gui init tool
	;inputs
	;r6=control object pointer

	tao	SWITCHHI
	psh	r8

	cpy	[r6+ND_SERVER],r8
	cpy	[r6+(ND_SERVER+4)],r9
	declare	'SERVER',r8,r9	;name default server

	getmyid	r6
	declare	'GUI',r8,r9	;name my mailbox as 'gui'

	vaddr	r6,0	;r0 > screen bitmap template
	cpy	[r6+ND_SERVER],r8
	cpy	[r6+(ND_SERVER+4)],r9
	cpy	r8,[r0+ND_SERVER]
	cpy	r9,[r0+(ND_SERVER+4)]	;set default server
	psh	r0
	cpy	r0,r1
	cpy	VAR_LOCALSCREEN,r0
	tao	SYSVARADDR
	cpy	r1,[r0]	;init local screen pointer
	cpy	r1,r0

	cpy	[r0+BM_WIDTH],r8
	mul	[r0+BM_HEIGHT],r8
	cpy	r8,[r0+BM_BITSIZE]

	; get screen base address
	psh	r0
	;nativebit	ARM2
	;mov	ar0, 123		;640*480*8bit mode, full palette
	;swi	$3f		;check if mode is valid
	;movcs	ar0, 28		;if invalid use fixed palette equiv.
	;swi	($100 + 22)	;mode change...
	;swi	0		;to value in ar0
	;endnative
	lea	[r0+BM_BITMAP], r1
	lea	RISCOS_PARAMS, r0
	nativebit	ARM2
	swi	$31
	endnative
	;turn off cursor
	lea	no_cursor, r0
	nativebit	ARM2
	mov	ar1, 10
	swi	$46
	endnative
	pop	r0

	cpy	r0,[r0+BM_PARENT]
	cpy	r0,[r6+CT_BITMAP]	;save pointers

	lea	[r0+BM_HOTLIST],r1
	initlist	r1	;init hot patch list
	lea	[r0+BM_TRIGLIST],r1
	initlist	r1	;init trigger patch list

	allocmem	SC_SIZE	;create space for screen vars
	cpy	[r7],r1
	cpy	r0,[r1+BM_USER4]	;save vars pointer

	vaddr	r6,2	;r0 > mouse control template
	cpy.l	[r6+ND_SERVER],r8
	cpy	r0,r2
	vaddr	r0,0	;r0 > pointer gob template
	cpy.l	r8,[r0+ND_SERVER]	;set default server
	cpy	[r7],r1
	cpy	r0,[r1+BM_USER2]	;fixup screen mouse pointer
	getmyid	r6
	startcontrol	r2,r8,r9	;open mouse control

	vaddr	r6,1	;r0 > backdrop control template
	pop	r1	;local screen pointer
	cpy	r1,[r0+CT_BITMAP]
	cpy	r0,[r1+BM_CONTROL]

	getmyid	r6
	pshm	r0,r9
	startcontrol	r0,r8,r9	;open backdrop control
	popm	r9,r8
	add	CT_MAILBOX,r8
	declare	'BACKDROP',r8,r9	;declare backdrop ID

	vaddr	r6,3	;r0 > vblank object
	getmyid	r6
	pshm	r0,r9
	startcontrol	r0,r8,r9	;open vblank control
	popm	r9,r0
	lea	[r0+CT_MAILBOX],r8
	declare	'VBLANK',r8,r9

	clr.l	r8
	clr.l	r0
	qcall	DEVICE/KEYCLAIM	;cancel any key poleing

	pop	r8
	tst	r8
	beq	quit1
	tao	SWITCHLO
quit1:	ret

	align
RISCOS_PARAMS:	dc.i	149
		dc.i	-1
no_cursor:
	dc.b	23, 1, 0, 0, 0, 0, 0, 0, 0, 0

	toolend tl_gui_init
nodeend tl_gui_init

.end
