/*==================================================================================*/
/*Project Name:RUPUTER                                             				  	*/
/*		 Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. 		*/
/*																					*/
/*Function Outline : onHand/Ruputer Filer System Definition(For Creating a Library)	*/
/*																					*/
/*==================================================================================*/

/************************************************************************************/
/* Bit definition of buttons														*/
#define Bkey_dw 	0x0080		/* K7 terminal bit(cursor pointer down  1:on,0:off)	*/
#define Bkey_rg		0x0040		/* K6 terminal bit(cursor pointer right 1:on,0:off)	*/
#define Bkey_up 	0x0020		/* K5 terminal bit(cursor pointer up    1:on,0:off)	*/
#define Bkey_lf 	0x0010		/* K4 terminal bit(cursor pointer left  1:on,0:off)	*/
#define Bkey_B		0x0008		/* K3 terminal bit(push(enter) 1:on,0:off)			*/
#define Bkey_C		0x0004		/* K2 terminal bit(push(EL)	   1:on,0:off)			*/
#define Bkey_D		0x0002		/* K1 terminal bit(push(menu)  1:on,0:off)			*/
#define Bkey_A		0x0001		/* K0 terminal bit(push(file)  1:on,0:off)			*/
#define	Bkey_T		0x0100		/* test bit											*/
#define	Bkey_BD 	0x0200		/* Open a battery lid.								*/
#define Bkey_SH 	0x0800		/* Remote shell										*/
#define	Bkey_CK 	0x1000		/* Clock											*/
/* Bit definition of double click													*/
#define DBL_BIT		0x100
#define DBLCL_R		(Bkey_rg*DBL_BIT)
#define DBLCL_L		(Bkey_lf*DBL_BIT)
#define DBLCL_U		(Bkey_up*DBL_BIT)
#define DBLCL_D		(Bkey_dw*DBL_BIT)
#define DBLCL_LR	(DBLCL_L | DBLCL_R)
/* Constant of an argument of LCD function											*/
#define LCD_GRAPH	1
#define	LCD_ERASE	0x05
/****************************************************************************************/
/* Define a file name.																	*/
#define	SYSTEMDIR		"B:\\SYSTEM"					/* System directory				*/
#define	PATHBLD			"B:\\SYSTEM\\APPS\\BLD2.EXF"	/* Battery replacement program	*/
#define	SYSTEMINI		"B:\\SYSTEM\\SYSTEM.INI"		/* onHand/Ruputer system file	*/
#define	FILERINI		"B:\\SYSTEM\\FILER.INI"			/* Filer system file			*/
#define	WEEKLYALARM		"B:\\SYSTEM\\WEEKLY.INI"		/* Weekly alarm information		*/
#define	TITLE			"B:\\SYSTEM\\MMP\\INITIAL.MMP"	/* Title						*/
#define	SOUNDPATH		"B:\\SYSTEM\\SOUND\\"			/* Sound directory				*/
#define	ALARMINI		"B:\\SYSTEM\\ALARM.INI"			/* Alarm information			*/
#define	TIMEUP			"B:\\SYSTEM\\SOUND\\TIMER.SND"	/* Timeup sound					*/
#define	CHECKPATH		"B:\\SYSTEM\\APPS\\CHECK.EXF"	/* Check program				*/
#define SCLSVPATH		"B:\\SYSTEM\\SCLSV\\"			/* Saver directory				*/
#define DSCHPATH		"B:\\SYSTEM\\APPS\\DSD.EXF"		/* SCH detail display program	*/
#define AUTOEXEC		"B:\\SYSTEM\\AUTOEXEC.EXF"		/* Autoexec program				*/
#define	ICONFILES		"B:\\SYSTEM\\*.ICO"				/* Icon							*/
#define	SHORTCUTINI		"B:\\SYSTEM\\INI\\SHORTCUT.INI"	/* Shortcut						*/
/****************************************************************************************/
/* onHand/Ruputer system definition structures											*/

/*	Contlast				A contrast value of LCD										*/
/*							 A range of 0-31											*/
/*	PowerSaver				Power saver setting											*/
/*							 0= no , 1=yes												*/
/*	WaitTime				Set a waiting time till saver is executed.					*/
/*				 	0=10 seconds, 1=20 seconds, 2=30 seconds, 3= 1 minute, 4= 2 minutes	*/
/*					5= 3 minutes, 6= 4 minutes, 7= 5 minutes, 8= 6 minutes,9= 7 minutes	*/
/*					10=8 minutes,11= 9 minutes,12=10 minutes							*/
/*	ScreenSaver				Set saver display.											*/
/*							 0=no, 1=clock												*/
/*	TimeCheck				Set TIME check.												*/
/*							 0=no , 1=yes												*/
/*	PowerStandby			Set power standby.											*/
/*							 0=on all the time , 1=auto off , 2=auto timer				*/
/*	PowerWaitTime			Set a waiting time until auto power off.					*/
/*				 	0=10 seconds, 1=20 seconds, 2=30 seconds, 3= 1 minute, 4= 2 minutes	*/
/*					5= 3 minutes, 6= 4 minutes, 7= 5 minutes, 8= 6 minutes,9= 7 minutes	*/
/*					10=8 minutes,11= 9 minutes,12=10 minutes							*/
/*	PowerON					Set auto power on time.										*/
/*	 						 A range of 00:00-23:59(24-hour system)						*/
/*	PowerOFF				Set auto power off time.									*/
/*	 						 A range of 00:00-23:59(24-hour system)						*/
/*	BackLight				Set backlight(EL)											*/
/*					0=manual, 1=1 second, 2=2 seconds, 3=3 seconds, 4=4 seconds			*/
/*		5=5 seconds, 6=6 seconds, 7=7 seconds, 8=8 seconds 9=9 seconds,10=10 seconds	*/
/*	CheckBeep				Set an operation confirmation sound.						*/
/*							 0=no, 1=yes												*/
/*	CheckSound				Set a weekly alarm sound and user alarm sound.				*/
/*							 0=no , 1=yes												*/
/*	CommBaud				Set communications speed.									*/
/*							  0=300bps	,1=600bps	,2=1200bps	,3=2400bps				*/
/*							  4=4800bps ,5=9600bps	,6=19200bps ,7=38400bps				*/
/*							  8=57600bps,9=115200bps									*/
/*	ClockType				Set an hour system.											*/
/*							  0=12-hour system , 1=24-hour system						*/
/*	DispLoad				Set dispLoad display.										*/
/*							  0=clock , 1=dolphin , 2=slot ,3=manta						*/
/*	Dst						Set standard summer time.									*/
/*							  0=summer time OFF , 1=summer time ON						*/
/*	DispWait				Set dispWait display.										*/
/*							  0=clock , 1=dolphin										*/
/*	IrRshMode				Set an infrared remote shell.								*/
/*							  0=Ir(8-Non-1) , 1=ASK(8-odd-1)							*/
/*	ScreenSaverEXF[8]		A file for executing special saver.							*/
/*							  Search from B:\System\Sclsv directory.					*/
/*	ELonAnykey				When backlight is lit, set Anykey continuously.				*/
/*							  0=no , 1=yes												*/
/*	ELonTimechk				Backlight is turned on when TIME check is displayed.		*/
/*							  0=no , 1=yes												*/
/*	CursorType				Special operation with cross cursor.						*/
/*							  0=none , 1=double click ,2=long push,3=both				*/
/*	KeyClick1				Number of initial push counts		64Hz counter			*/
/*							  Approximately 10-30N            							*/
/*	KeyRepeat				Number of key repeat counts			64Hz counter			*/
/*							   Approximately 3-10  										*/
/*	KeyClick2				Number of recognized double click	64Hz counter			*/
/*							   Approximately 3-10										*/
/*	KeyLong					Number of long push counts		64Hz counter				*/
/*							   Approximately 10-48(CursorType=3 This is given priority.)*/
/*	TimePop1				Time till time check starts.	64Hz counter				*/
/*							   Approximately 3-30										*/
/*	TimePop2				Duration while time check is being displayed. 4Hz counter	*/
/*							   Approximately 3- 8										*/
/*	Mynmame[12]				User Name													*/
/*							   "My Computer"											*/
/*	Myface[8]				Top-Icon													*/
/*							  Search from B:\System\*.ico.								*/
/*	ScutNum					Number of registered shortcuts.								*/
/*							  1-10														*/
/*	ScutMode				Shortcuts<=>Filer switching flag							*/
/*							  0=No filer transition , 1=To filer						*/
/*	FilerHide				Set display of filer hidden attributes &DOS hidden.			*/
/*							  0=Display , 1=Hide										*/
/*	FilerInd				Scroll jump^ v display										*/
/*							  0=Display , 1=Hide										*/
/*	SftKeyOp				Soft keyboard back operation switching						*/
/*							  0=Normal , 1=Back mode									*/
/*	BarTime					Set display of list top bar clock.							*/
/*							  0=leftward (Large), 1=Rightward(Large), 2=Leftward(Small) */
typedef	struct {
	short Hour;					/* hour												*/
	short Minute;				/* minute											*/
} HOURTIME;
typedef struct {
	char  System0[6];			/* Used by system									*/
	short System1;				/* Used by system									*/
	short Contlast;				/* LCD contrast										*/
	short PowerSaver;			/* Set power saver.									*/
	short WaitTime;				/* Set a waiting time till saver is executed.		*/
	short ScreenSaver;			/* Set saver display.								*/
	short ScreenSaverOFFtime;	/* LCD off time										*/
	short ScreenSaverONtime;	/* LCD on time										*/
	char ScreenSaverMMP[8];		/* Wall paper mmp file								*/
	short TimeCheck;			/* Set TIME check. 									*/
	short PowerStandby;			/* Set power standby.								*/
	short PowerWaitTime;		/*Set a waiting time till auto power off.			*/
	HOURTIME PowerON;			/* Set auto power on time.							*/
	HOURTIME PowerOFF;			/* Set auto power off time.							*/
	short BackLight;			/* Set backlight(EL)								*/
	short CheckBeep;			/* Set operation confirmation sound.				*/
	short CheckSound;			/* Set week alarm sound &user alarm sound.			*/
	short FilerType;			/* Directory display mode							*/
	short FilerKind;			/* Directory display mode							*/
	short FilerSort;			/* Directory display mode							*/
	short CommBaud;				/* Set communications speed.						*/
	short ClockType;			/* Set an hour system.								*/
	short Secret;				/* Display/hide secret information.					*/
	short DispLoad;				/* Set dispLoad display.							*/
	short Dst;					/* Set standard time summer time.					*/
	short DispWait;				/* Set dispWait display.							*/
	short IrRshMode;			/* Set an infrared remote shell.					*/
	char  System2[6];			/* Used by system.									*/

	char  ScreenSaverEXF[8];	/* File for executing SCLSV.EXF						*/
	short ELonAnykey;			/* When backlight is turned on, set Anykey continuously.*/
	short ELonTimechk;			/* When TIME check is displayed, backlight is turned on.*/
	short CursorType;			/* Cursor operation  Double click or hold down.		*/
	short KeyClick1;			/* Number of initial push counts					*/
	short KeyRepeat;			/* Number of key repeat counts						*/
	short KeyClick2;			/* Number of recognized double clicks				*/
				/*	Time from when you release first to when you push second time.	*/
	short KeyLong;				/* Number of hold down counts						*/
	short TimePop1;				/* Time till time check starts.						*/
	short TimePop2;				/* Time while time check is being displayed			*/

	char Myname[12];			/* User Name										*/
	char Myface[8];				/* Top-Icon											*/
	short ScutNum;				/* Number of registered history short cuts			*/
	short ScutMode;				/* History short cutsw<=>Filer switching			*/
	short FilerHide;			/* Set display of  Rup hiddne attributes & DOS hidden.*/
	short FilerInd;				/* Filer and new toggle ^ v set display				*/
	short SftKeyOp;				/* Soft keyboard back manipulation switching		*/
	short BarTime;				/* Set list top bar clock display.					*/
	short RightOpen;			/* Set right click executio.						*/
	short FilerYN;				/* Set a default of popup selection value.			*/

	short filler[60];			/* Extra											*/
} RUPSYS;
/************************************************************************************/
/* Clock structure																	*/
typedef struct {
	int NOW_Year;				/* Year												*/
	int NOW_Month;				/* Month											*/
	int NOW_Day;				/* Day												*/
	int NOW_Week;				/* Week												*/
	int NOW_Hour;				/* Hour(24-hour)									*/
	int NOW_Min;				/* Minute											*/
	int NOW_Sec;				/* Second											*/
} WatchDT;
typedef struct{
	int msec;
	int sec;
	int min;
	int hour;
} STW;
/************************************************************************************/
/* Format of year, month, day, hour and minute										*/
/*	31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16									*/
/* +-----------------------------------+-----------+								*/
/* |         (year-1900)               |  month    |								*/
/* +-----------------------------------+-----------+								*/
/*	15 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00									*/
/* +--------------+--------------+-----------------+								*/
/* |      day     |     hour     |       min       |								*/
/* +--------------+--------------+-----------------+								*/
/* Format of week, hour, and minute													*/
/*	18 17 16 15 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00						*/
/* +-----------------------+--------------+-----------------+						*/
/* |      weekly           |       hour   |      min        |						*/
/* +-----------------------+--------------+-----------------+						*/
/* Format of hour and minute														*/
/*	15 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00									*/
/* +--------------+--------------+-----------------+								*/
/* | 0  0  0  0  0|     hour     |        min      |								*/
/* +--------------+--------------+-----------------+								*/
/************************************************************************************/
/*	Event management																*/
typedef struct {
	long eventReq;				/* Request for occurrence of an event								*/
	long event;					/* State of how an event occurs										*/
	int BLDnoKEYcounter;		/* BLD no-operation event(minute count)								*/
	int RETcounter;				/* Auto return/event(minute counter)								*/
	int SAVERcounter;			/* Saver event(second counter)										*/
	int POFFtime;				/* Auto power off(off).event(hour and minute matched)				*/
	int PONtime;				/* Auto power off(on).event(hour and minute matched)				*/
	int ReOFFtime;				/* Re-auto power off(off).event(second count)						*/
	short WEEKday1;				/* Week alarm 1.event(week, hour and minute matched)				*/
	short WEEKtime1;			/* week alarm 1.event(week, hour and minute matched)				*/
	short WEEKday2;				/* week alarm 2.event(week, hour and minute matched)				*/
	short WEEKtime2;			/* week alarm 2.event (week, hour and minute matched)				*/
	short WEEKday3;				/* week alarm 3.event(week, hour and minute matched)				*/
	short WEEKtime3;			/* week alarm 3.event(week, hour and minute matched)				*/
	short WEEKday4;				/* week alarm 4.event(week, hour and minute matched)				*/
	short WEEKtime4;			/* week alarm 4.event (week, hour and minute matched)				*/
	long ALMtime;				/* schedule.alarm.event(year, month, day, hour and minute matched)	*/
	long USR1time;				/* user1.alarm.event(year, month, day, hour and minute matched)		*/
	long USR2time;				/* user2.alarm.event(year, month, day, hour and minute matched)		*/
	long USR3time;				/* user3.alarm.event(year, month, day, hour and minute matched)		*/
	int SECcounter;				/* second counter													*/
} EVENTMANAGE;
#define	EVENT_BLD		0x00000001UL	/* Request for/occurrence of BLD detected event.			*/
#define	EVENT_BLDnoKEY	0x00000002UL	/* Request for/occurrence of BLD non-operation event.		*/
#define	EVENT_RET		0x00000004UL	/* Request for/Occurrence of auto return/event				*/
#define	EVENT_POFF		0x00000008UL	/* Request for/Occurrence of auto power off event.			*/
#define	EVENT_PON		0x00000010UL	/* Request for/Occurrence of auto power on/event.			*/
#define	EVENT_SAVER		0x00000020UL	/* Request for/occurrence of saver/event.					*/
#define	EVENT_WEEK1		0x00000040UL	/* Request for/occurrence of week alarm/event.				*/
#define	EVENT_WEEK2		0x00000080UL	/* Request for/occurrence of week alarm/event.				*/
#define	EVENT_WEEK3		0x00000100UL	/* Request for/occurrence of week alarm/event.				*/
#define	EVENT_WEEK4		0x00000200UL	/* Request for/occurrence of week alarm/event.				*/
#define	EVENT_ALM		0x00000400UL	/* Request for/occurrence of sehceule/alarm/event.			*/
#define	EVENT_ALMsnd	0x00000800UL	/* Request for/occurrence of schedule/alarm/event (sound).	*/
#define	EVENT_USER1		0x00001000UL	/* Request for/occurrence of user 1/alarm/event.			*/
#define	EVENT_USER1snd	0x00002000UL	/* Request for/occurrence of user 1/alarm/event(sound).		*/
#define	EVENT_USER2		0x00004000UL	/* Request for/occurrence of user 2/alarm/event.			*/
#define	EVENT_USER2snd	0x00008000UL	/* Request for/occurrence of user 2/alarm/event (sound).	*/
#define	EVENT_USER3		0x00010000UL	/* Request for/occurrence of user 3/alarm/event.			*/
#define	EVENT_USER3snd	0x00020000UL	/* Request for/occurrence of user 3/alarm/event (sound).	*/
#define	EVENT_SEC		0x00040000UL	/* Request for/occurrence of event per second.				*/
#define	EVENT_BDOpen	0x00080000UL	/* Open a battery lid.										*/
#define	EVENT_STW		0x00100000UL	/* Request for/occurrence of stop watch 1Hz.				*/
#define	EVENT_LCD		0x00200000UL	/* Auto power off state										*/
#define	EVENT_RePOFF	0x00400000UL	/* Re-auto power off(off).event(minute count)				*/
#define	EVENT_SvExec	0x00800000UL	/* Power saver being executed.								*/
#define	EVENT_TMDWN0	0x01000000UL	/* Timeup prediction sound									*/
#define	EVENT_TMDWN1	0x02000000UL	/* Timeup sound												*/
#define	EVENT_TMDWN2	0x04000000UL	/* Timeup(1 second)											*/
#define	EVENT_RgExec	0x08000000UL	/* Coprocess being executed.								*/
#define	EVENT_TIMECHK	0x10000000UL	/* Time check execution occurs.								*/
#define	EVENT_MIN		0x20000000UL	/* Request for/occurrence of vent per minute.				*/
#define	EVENT_HOUR		0x40000000UL	/* Request for/occurrence of event per hour.				*/
#define EVENT_DBLCLICK	0x80000000UL	/* Occurrence of double click event							*/
#define	EVENTREGSTER	*(char *)0xf080
/* Event type																						*/
#define	EVENT_REQ		0x8000					/*Event												*/
#define	EVENT_KEY		(EVENT_REQ | 0x0800)	/* Non-function button event						*/
/************************************************************************************/
/* System parameters																*/
typedef struct {
	long BLD1;								/* BLD1 value							*/
	long BLD2;								/* BLD2 value							*/
	long Battery;							/* Battery value						*/
	int LCDVolMin;							/* LCD volume minimum value				*/
	int LCDVolMax;							/* LCD volume maximum value				*/
	int VOLBLD1In;							/* Enter heavy load BLD1 voltage.		*/
	int VOLBLD1Re;							/* Recover to heavy load BLD1 voltage.	*/
	int VOLBLD2;							/* Heavy load BLD2 voltage				*/
	int VOLFileOpen;						/* File openable voltage				*/
} PARAMSYS;
/************************************************************************************/
/* File association definition														*/
/*	suffix			extension(including .)											*/
/*	icon			Display icon													*/
/*	id				Selection value of an icon										*/
/*					 0=Pictograph code, and mono map are valid.							*/
/*					 1=Pictograph code and large icon of MMP file are valid.				*/
/*					 2=Mono map and small icon of MMP file are valid.				*/
/*					 3=Small and large icons of MMP file are valid.					*/
/*	font			Pictograph code(Small icon)											*/
/*	mmp				Mono map(Large icon)											*/
/*	file			MMP file name													*/
/*					 A file is in B:\SYSTEM.										*/
/*	app				An application file name to be exctued.							*/
/*					 NULL,drive name(fixed by B:),extension(fixed by .EXF)			*/
/*					 Within 32 letters excluding 									*/
/*	However,																		*/
/*		Structure RELATED[0] will be used in a unknown file.						*/
/*		Structure RELATED[1] will be used in a directory.							*/
/*		Structure RELATED[2] will be used with "return" icon of icon display. 		*/
/*		Structure RELATED[3] will be used with an executable program.				*/
#define	PATHSIZE 32				/* The maximum number of letters to path file name of application	*/
#define	RELATEDSIZE 64			/* Total number of associations 					*/
typedef	struct {
	char suffix[4];
	short attr;
	unsigned short id;
	unsigned short font;
	unsigned long mmp;
	char file[8];
	char app[PATHSIZE];
} RELATED;
/************************************************************************************/
/* Definition of structures of directory information								*/
/*	Array 0th is to be used as a name of its directory.								*/
#define	FILEINFOMAXSIZE 128
#define	FILENAMESIZE	13
typedef struct {
	unsigned int time;						/* write time							*/
	unsigned int date;						/* write date							*/
	unsigned long size;						/* file size							*/
	unsigned char attr;						/* file attribute						*/
	unsigned char file[FILENAMESIZE];		/* file name							*/
} FILEINFO;
/************************************************************************************/
/* Structure of menu display														*/
typedef struct{
	int (*func)(void);
	char *str;
	int moveR;
	int disable;
}MENU;
/*Message structures																*/
typedef struct{
	char *mess1;
	char *mess2;
	char *mess3;
	char *mess4;
}ERRmess;
/************************************************************************************/
/* Specify a day of the week.														*/
#define	WEEKLY_MON	0x0001			/* Monday										*/
#define	WEEKLY_TUE	0x0002			/* Tuesday										*/
#define	WEEKLY_WED	0x0004			/* Wednesday									*/
#define	WEEKLY_THU	0x0008			/* Thursday										*/
#define	WEEKLY_FRI	0x0010			/* Friday										*/
#define	WEEKLY_SAT	0x0020			/* Saturday										*/
#define	WEEKLY_SUN	0x0040			/* Sunday										*/
/************************************************************************************/
/* Week alarm event																	*/
/* Structure of week alarm information												*/
#define SNDFILENAMESIZE	8
typedef struct {
	unsigned short week;
	unsigned short hour;
	unsigned short min;
	char snd[SNDFILENAMESIZE];
} WEEKLYTABLE;
/* Alarm event																		*/
typedef struct {
	unsigned short year;
	unsigned short month;
	unsigned short day;
	unsigned short hour;
	unsigned short min;
	char snd[SNDFILENAMESIZE];
	char exf[PATHSIZE];
} EVENTTABLE;
/************************************************************************************/
/* Timer control																	*/
typedef struct{
	int hour;
	int min;
	int sec;
	int co;
} Tdata;
/************************************************************************************/
typedef struct {
	int (*Keyin)(int,int);							/*button Input operation functions				*/
	int (*EventCall)(int );							/* event management								*/
	int (*EventExec)(void);							/* event execution								*/
	int (*softkey)(void *,char *,int,char * );		/* soft keyboard								*/
	int (*dispMESS)(char **,int );					/* display of warning message					*/
	int (*dispYNb)(char *,char *,int );				/* yes/no menu(display of large)				*/
	int (*dispYN)(char *,char *,int );				/* yes/no menu									*/
	int (*dispCancelYN)(void);						/* Cancel setting								*/
	void (*dispMSG)(char *);						/* Display full size 3-letter message.			*/
	void (*dispKOUSIN)(void);						/* Terminate "update setting" display.			*/
	void (*endKOUSIN)(void);						/* Align display time.							*/
	int (*setBackMenu)(void);						/* Return operation								*/
	int (*setExitMenu)(void);						/* Application termination processing			*/
	int (*setDummyList)(void);						/* Update setting.								*/
	void (*dispTitle)(char *);						/* Display of a menu name.						*/
	int (*aprMENUauto)(char *,MENU *,int );			/* Menu processing (with auto return)			*/
	int (*aprMENU)(char *,MENU *,int );				/* Menu processing								*/
	int (*settingMENU)(char *,MENU *,int,int *,int);/* Menu processing(internal function)			*/
	int (*dispERR)(char *,ERRmess *);				/* Display an error message.					*/
	void (*dispERRnoBUZZ)(char *,ERRmess *);		/* Display an error message(without buzzer)		*/
	void (*dispVOLerr)(void);						/* Display abnormal battery.					*/
	void (*dispMEMORYerr)(void);					/* Display abnormal memory.						*/
	void (*dispBIOSerr)(void);						/* Display BIOS error.							*/
	int (*adjTime)(void);							/* Modify time.									*/
	int (*timeSEND)(void);							/* Transfer time between child devices (transmission).*/
	int (*timeRECV)(WatchDT *);						/* Transfer time between child devices (reception).	  */
	void (*endTIMEAdj)(void);						/* Terminate time adjustment.					*/
	void (*setRTC)(void);							/* RTC setting									*/
	void (*getRTC)(void);							/* Update time data of CPUram.					*/
	int (*DfileSEND)(char *,int ,long );			/*Transfer a file for application - transmission.*/
	int (*DfileRECV)(char *,int );					/* Transfer a file for application - reception.	*/
	void (*setWeeklyAlarm)(void);					/* Set a week alarm.							*/
	void (*setAlarm)(void);							/* Set an event alarm.							*/
	void (*setPowerStandby)(void);					/* Set power standby.							*/
	void (*endWAIT)(void);							/* Waiting display								*/
	void (*dispWAIT)(void);							/* Waiting display								*/
	void (*dispTitleMore)(char *);					/* Display a manu name (with up and down arrows)*/
	void (*TIMERStart)(void);						/* Timer control (start)						*/
	void (*TIMERStop)(void);						/* Timer control (stop)							*/
	int (*ChildExecute)(char *,int *);				/* Execute a child process.						*/
	void (*checkExecute)(void);						/* Execute a child process.						*/
	void (*dispRtcWeek)(int,int,int,int,int);		/* Display Rtc day of the week.					*/
	void (*dispRtcDate)(int,int,int,int,int);		/* Display Rtc year, monty and day.				*/
	void (*dispRtcAmPm)(int,int,int,int);	  		/* Display RtcAM/PM.							*/
	int (*dispRtcTime)(int,int,int,int,int,int,int);/* Display Rtc hour and minute.					*/
 	void (*dispRtcSec)(int,int,int,int,int);  		/* Display Rtc time and second.  	   			*/

	int (*aprMENUauto_USfont)(char *,MENU *,int );	/* Menu processing (with auto return)			*/
	int (*aprMENU_USfont)(char *,MENU *,int );		/* Menu processing								*/
	int (*settingMENU_USfont)(char *,MENU *,int,int *,int);	/* Menu processing (internal function)	*/
	void (*dispTitle_USfont)(char *);				/* Display a menu name.							*/
	void (*dispTitleMore_USfont)(char *);			/* Display a menu name(with up and down arrows)	*/
	int (*dispMESS_USfont)(char **,int );			/* Display an alarm message.					*/
	int (*dispYNb_USfont)(char *,char *,int );		/* yes/no menu (large display)					*/
	int (*dispYN_USfont)(char *,char *,int );		/* yes/no menu									*/
	void (*dispMSG_USfont)(char *);					/* Display full-size 3-letter message.			*/
	int (*dispERR_USfont)(char *,ERRmess *);		/* Display an error message.					*/

	void (*setSaver)(void);
	int (*execShortcut)(char *exename);

	int (*getFilerVersion)(void);					// Filer version
	int (*pauseScroll2)(int,int,int,int);			// Jump mark
} APISYS;
/************************************************************************************/

/* Hand an area and function to application.										*/
typedef	struct {
	EVENTMANAGE *EventManager;					/* event management					*/
	PARAMSYS *Paramsys;							/* system parameters				*/
	int *SystemPower;							/* auto power on/off state			*/
	WatchDT *CPUram;							/* time								*/
	RUPSYS *RupDefine;							/* onHand/Ruputer system definition structure area	*/
	int *RupRelatedSize;						/* Number of file association definition structure areas	*/
	RELATED *RupRelated;						/* File association definition structure area */
	int *FileInfoSize;							/* Number of file information		*/
	FILEINFO *FileInfo;							/* File information(not sorted)		*/
	FILEINFO **FileList;						/* List of file information(sorted)	*/
	char *DirectoryPath;						/* Current directory path			*/
	int *DirectoryTree;							/* Depth of a path					*/
	int *BLDReq;								/* Request for BLD confirmation		*/
	int *BLD;									/* BLD detection result				*/
	int *BLDExecute;							/* Request for start of battery replacemnt EXF.	*/
	unsigned int *MelodyPlay;					/* melody play buffer				*/
	int *Secret;								/* Display/hide secret information.	*/
	STW *STWdata;								/* Stop watch						*/
	int *repflg;								/* button repeat status				*/
	int *TimerStat;								/* timer control (status)			*/
	Tdata *TIMERdata;							/* timer control (time)				*/
	int (*Keyin)(int,int);						/* button input operation function	*/
	int (*EventCall)(int );						/*event management					*/
	int (*EventExec)(void);						/* event execution					*/
	int (*softkey)(void *,char *,int,char * );	/* soft keyboard					*/
	int (*dispMESS)(char **,int );				/* Display an alarm message			*/
} SYSTEMCTL;
/************************************************************************************/
/* System area																		*/
extern SYSTEMCTL *pSystemCtl;

/** System functions *********************/
extern APISYS *pApiSys;


/* onHand/RuputerAPI service starts													*/
extern void InitRupAPI(void);
/* onHand/RuputerAPI service ends													*/
extern void EndRupAPI(void);

/* Obtain an argument																*/
extern char *getArg(void);

/* Button input processing function													*/
extern int Keyin(int repeat,int blink);
/* event management																	*/
extern int EventCall(int );
/* event execution																	*/
extern int EventExec(void);

/* soft keyboard																	*/
extern int softkey(void *, char *,int,char * );

/* Display a message.																*/
extern int dispMess(char **,int );
/* Display full-size 3-letter message and bar.										*/
extern void dispMessBar(char *);
/* End display of full-size 3-letter message and bar.								*/
extern void endMessBar(void);

/* yes/no message (standard frame)													*/
extern int dispYN(char *,char *,int );
/* yes/no message (large frame)														*/
extern int dispYNLarge(char *,char *,int );

/* Cancel setting Yes/No															*/
extern int dispCancelYN(void);
/* Display waiting WaitAnimation													*/
extern void dispWaiting(void);
/* End display of waiting WaitAnimation.											*/
extern void endWaiting(void);
/* End display of "being updated".													*/
extern void dispRenew(void);
/* End display of "being updated".													*/
extern void endRenew(void);
/* Display abnormal battery.														*/
extern void dispVOLerr(void);
/* Display abnormal memory.															*/
extern void dispMEMORYerr(void);
/* Display a BIOS error.															*/
extern void dispBIOSerr(void);

/* Menu processing																	*/
extern int aprMenu(char *,MENU *,int );
/* "Return" operation																*/
extern int setBackMenu(void);
/* "Termination of application" operation											*/
extern int setExitMenu(void);

/* List display function															*/
extern int dispList(char *,MENU *,int,int *,int);
/* List display dummy function														*/
extern int setDummyList(void);

/* Display menu title.																*/
extern void dispTitle(char *);
/* Display menu title (with up and down arrows).									*/
extern void dispTitleMore(char *);
/* Display up and down arrows of menu title.										*/
extern void dispTitleUpDw(int,int,int);

/* Error message display with help													*/
extern void dispError(char *,ERRmess *);
/* Error message display "Unable to operate"(without buzzer, immediate return)		*/
extern void dispErrorCantRun(char *,ERRmess *);

/*	Modify time.																	*/
extern int adjTime(void);
/* Transfer time between child devices.												*/
extern int sendTime(void);
extern int recvTime(WatchDT *);

/* RTC setting																		*/
extern void setRTC(void);
/* End RTC setting.																	*/
extern void setRTCquit(void);
/* Update CPUram time data.															*/
extern void getRTC(void);
/* Set week alarm.																	*/
extern void setWeeklyAlarm(void);
/* Set event alarm.																	*/
extern void setAlarm(void);
/* Set power standby.																*/
extern void setPowerStandby(void);

/* Transfer of a file for application - transmission								*/
extern int sendFile(char *,int ,long );
/* Transfer of a file for application - reception									*/
extern int recvFile(char *,int );

/* Timer control																	*/
extern void TIMERStart(void);
extern void TIMERStop(void);

/* Execute a child process.															*/
extern int ChildExecute(char *,int *);
extern void CheckExecute(void);

/* Display CPUram data																*/
extern void dispNowWeek(int,int,int,int,int);
extern void dispNowDate(int,int,int,int,int);
extern void dispNowAmPm(int,int,int,int);
extern int dispNowTime(int,int,int,int,int,int,int);
extern void dispNowSec(int,int,int,int,int);

extern int dos_fcrnew(char *);
extern int dos_fcreate(char *);
extern int dos_fopen(char *,int );
extern int dos_fclose(int );
extern int dos_fread(int ,char *,unsigned int );
extern int dos_fwrite(int ,char *,unsigned int );
extern int dos_fdelete(char * );
extern unsigned long dos_fseek(int ,int ,unsigned long );
extern int bi_vwrflush(void );

extern int bi_vsecread(int ,int ,int ,int ,int ,void *);
extern int bi_vsecwrite(int ,int ,int ,int ,int ,void *);

/*	Comparison with the number of free bytes										*/
extern int dos_freespace(long );
/*	Comparison of the number of free sectors										*/
extern int dos_freesect(int );

/*	Check heavy load voltage.														*/
extern int CheckVol(void );

/*	Clear saver counter.															*/
extern void setSaverCounter(void);

/*	Start a next program.															*/
extern int NextExecute(char *exename);

/*	Obtain a filer version.															*/
extern int getFilerVersion(void);

/*	Display a jump mark.															*/
extern int	pauseScroll(int,int,int);

/*	Convert a hexadecimal string.  													*/
extern long toAddrbin(char *str);

