/*==================================================================================*/
/*Project Name:RUPUTER                                             				  	*/
/*		 Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. 		*/
/*																					*/
/*Function Outline : onHand/Ruputer Tool Library Definition(For Creating a Library)	*/
/*  		                                                                        */
/*==================================================================================*/


/* Date data */
typedef struct{
	char	dd;					//Day
	char 	mm;					//Month
	int		yy;					//Year
}TypeDate;

// Time data
typedef struct{
	int		min;				//Minute
	int 	hour;				//Hour
}TypeTime;


typedef struct {
	int  (*getUsWdot)(int, char *);
	void (*StrCpy)(char *,const char *);
	int  (*StrnCmpI)(char * ,char * ,int );
	void (*strcat1)(char *,const char *);
	void (*strcat2)(char *,const char *,const char *);
	void (*strcpy1)(char *,const char *);
	void (*strcpy2)(char *,const char *,const char *);
	void (*strcpy3)(char *,const char *,const char *,const char *);
	void (*wstrcpy)(char *,const char *,char *, const char *);
	void (*strcpyadd0)(char *,const char *,int);
	int  (*strlength)(const char *);

	void (*Dummy01)(void);							//Reserved
	void (*Dummy02)(void);							//Reserved
	void (*Dummy03)(void);							//Reserved
	void (*Dummy04)(void);							//Reserved
	void (*Dummy05)(void);							//Reserved
	void (*Dummy06)(void);							//Reserved
	void (*Dummy07)(void);							//Reserved
	void (*Dummy08)(void);							//Reserved
	void (*Dummy09)(void);							//Reserved
	void (*Dummy10)(void);							//Reserved
	void (*Dummy11)(void);							//Reserved
	void (*Dummy12)(void);							//Reserved
	void (*Dummy13)(void);							//Reserved
	void (*Dummy14)(void);							//Reserved
	void (*Dummy15)(void);							//Reserved
	void (*Dummy16)(void);							//Reserved
	void (*Dummy17)(void);							//Reserved
	void (*Dummy18)(void);							//Reserved
	void (*Dummy19)(void);							//Reserved
	void (*Dummy20)(void);							//Reserved
	void (*Dummy21)(void);							//Reserved
	void (*Dummy22)(void);							//Reserved
	int (*CheckLeapYear)( int );					//Judge whether it is a leap year.
	int (*CheckAmPm)( int * );						//Judge whether it is AM/PM.
	void (*CheckToday)( TypeDate * );				//Obtain a date of today.(on RAM)
	int (*CheckWeek)( int,int,int );				//Obtain a day of the week.
	void (*Dummy23)(void);							//Reserved
	void (*Dummy24)(void);							//Reserved
	void (*Dummy25)(void);							//Reserved
	void (*Dummy26)(void);							//Reserved
	void (*Dummy27)(void);							//Reserved
	void (*Dummy28)(void);							//Reserved
	int (*GetNWeek)( int, int, int, int );			//Obtain a date of nth day of the week.
	int (*GetSndFileName)( char *, char [][9], int );//Obtain a name of a sound file.
	void (*SoundDEMO)( char * );					//sound demo
	void (*GetNdaysafter)( TypeDate *, long , int );//Obtain a date after a few days.
	int (*YearDayCount)( int );						//Obtain the total number of days of a year.
	int (*CheckDayCountSet)( TypeDate * );			//Obtain information some days after January 1. 	long (*GetSubDays)( TypeDate *, TypeDate * );	//Obtain a difference between one date and another date. 
	void (*Dummy29)(void);							//Reserved
	void (*Dummy30)(void);							//Reserved
	int (*GetSubTime)( TypeTime *, TypeTime * );	//Obtain a difference between time and time.
	int (*GetNhourafter)( TypeTime *, int );		//Obtain time after N minutes. 
	void (*Dummy31)(void);							//Reserved
	void (*Dummy32)(void);							//Reserved
	void (*Dummy33)(void);							//Reserved
	void (*Dummy34)(void);							//Reserved
	int (*CheckTimeTable)( TypeDate *, TypeDate *, TypeDate * );//Judge whether a date is within a range.
	void (*Dummy35)(void);							//Reserved
} APITOOL;
/************************************************************************************/

/** System functions  *********************/
extern APITOOL *pApiTool;

extern int  getUsWdot(int, char*);
extern void StrCpy(char *,const char *);
extern int  StrnCmpI(char * ,char * ,int );
extern void strcat1(char *,const char *);
extern void strcat2(char *,const char *,const char *);
extern void strcpy1(char *,const char *);
extern void strcpy2(char *,const char *,const char *);
extern void strcpy3(char *,const char *,const char *,const char *);
extern void wstrcpy(char *,const char *,char *, const char *);
extern void strcpyadd0(char *,const char *,int);
extern int  strlength(const char *);


//Own created functions
extern void getGvPos(int*, int*);
extern int  getLcdfreezeVal(void);
//Application extension
extern void	SetExtensionInfo(unsigned long pInfo);
extern long	GetExtensionInfo(void);
extern void	ClearExtensionInfo(void);
extern int	ExtensionAppsExecute(char *path);

// common functions 
extern int CheckLeapYear( int );					//Judge whether it is a leap year.
extern int CheckAmPm( int * );						//Judge whether it is AM/PM.
extern void CheckToday( TypeDate * );				//Obtain a today's date.(on RAM)
extern int CheckWeek( int,int,int );				//Obtain a day of the week.

extern int GetNWeek( int, int, int, int );			//Obtain a date of nth day of the week.
extern int GetExtFileName( char *, char [][9], int );//Obtain a name of a execute file. 
extern void SoundDEMO( char * );					//sound demo
extern void GetNdaysafter( TypeDate *, long , int );//Obtan a date after a few days.
extern int YearDayCount( int );						//Obtain the total number of days in a year.
extern int CheckDayCountSet( TypeDate * );			//Obtain information some days after January 1. 
extern long GetSubDays( TypeDate *, TypeDate * );	//Obtain a difference between one date and another date. 
extern int GetSubTime( TypeTime *, TypeTime * );	//Obtain a difference between time and time.
extern int GetNhourafter( TypeTime *, int );		//Obtain time after N minutes.
extern int CheckTimeTable( TypeDate *, TypeDate *, TypeDate * );//Judge whether a date is within a range.
