#################################################
#	File Name:comrem.s							#
#	Remote Control Waveform Output Program		#
#	Created on:98.08.14							#
#	Refer to TAB = 4.							#
#################################################

	.global		_rem_out		# Output remote control waveform.
	.global		_rem_set		# Set remote control carrier.

	.section	.text

_rem_out:
#*** Output remote control waveform. ***
#[Function] 	Output a remote control waveform of button number
#				 you specified with d1 of a model number specified with	d0. 
#[Condition] 	None
#[Destruction]	d0
#[Input]		d0=Model number,d1=button number
	.equ		PSW_IEbit,	0x0800

	add		-28,a3			#push d0,d1,d2,d3,a0,a1,a2
	movx	d0,(0,a3)
	movx	d1,(4,a3)
	movx	d2,(8,a3)
	movx	d3,(12,a3)
	mov		a0,(16,a3)
	mov		a1,(20,a3)
	mov		a2,(24,a3)

	#First of all, create data to transfer in working. 
	#The first half is fixed data, while the latter half is data with buttons. 
#1-1.Calculate a data address from a model number.
	mov		rtype_sanyo_1,a0				#Model number
	mov		rtype_sanyo_2 - rtype_sanyo_1,d1	#Data volume of each model
	mul		d0,d1						#Dm*Dn->Dm,(Dm*Dn)>>16->MDR
	add		d1,a0					#Header address of data (Do not change.)
#1-2.Save the number of repetitions in a stack.
	mov		(66,a0),d0
	mov		d0,(0,a3)
#1-3.Set a1 to address of working.
	mov		working,a1
rem_out12:
#1-4. Save a header in working.
	mov		3,d0		#Save a header.
	mov		d0,(a1)
	add		2,a1
#2.Save fixed data in working.
rem_out22:
#2-2. Place fixed data 1 in d2.
	mov		(58,a0),d2
#2-3. Make (the number of bits of fixed data) d3.
	mov		(60,a0),d3
#2-4. Save fixed data 1 in working.
	jsr		st_work
#2-5. Place fixed data 2 in d2.
	mov		(70,a0),d2
#2-6.Make (the number of bits of fixed data 2) d3.
	mov		(72,a0),d3
#2-7.Store fixed data 2 in working.
	jsr		st_work
#3. Save button data in working.
#3-1.Calculate an address of button data. 
	movx	(4,a3),d0		#Button number
	add		7,d0
	add		d0,d0
#3-2.Place button data in d2.
	mov		(d0,a0),d2		#Button data
#3-3.Make (the number of bits of button data) d3.
	mov		(62,a0),d3
#3-4. Save button data in working.
	jsr		st_work
#4. Save inversion or same button data in working.
#4-0. If none, proceed to 5.
	mov		(64,a0),d0		#Is button data inverted?
	and		d0,d0
	beq		rem_out5		#if ZF=1 then jp d8(label)
#4-1.Calculate address of button data.
	movx	(4,a3),d0		#Button number
	add		7,d0
	add		d0,d0
#4-2.Place button data into d2.
	mov		(d0,a0),d2		#Button data
	mov		(64,a0),d0		#Is button data inverted?
	cmp		2,d0
	beq		rem_out43		#if ZF=1 then jp d8(label)
	xor		0xffff,d2		#Inverted
rem_out43:
#4-3. Make (the number of bits of button data) d3.
	mov		(62,a0),d3
#4-4. Save button data in working.
	jsr		st_work
rem_out5:
#5. Repeately process with dummy data.
#5-1. Save one section of dummy data in working.
	mov		0,d0
	mov		d0,(a1)
	add		2,a1
#5-2. If you do not repeat, proceed to light emission.
	mov		(0,a3),d0
	and		d0,d0
	beq		rem_out6		#if ZF=1 then jp d8(label)
#5-3.If you repeat, decrement by -1, save pause in working, and repeat. 
	add		-1,d0
	mov		d0,(0,a3)
	mov		2,d0			#save pause in working
	mov		d0,(a1)
	add		2,a1
#5-4. Whether to repeat with a header or without a header.
	mov		(68,a0),d0		#Repeat with a header?
	and		d0,d0
	beq		rem_out22		#if ZF=1 then jp d8(label)
	jmp		rem_out12
rem_out6:
#6.Prohibit interruptions
	and		~PSW_IEbit,psw		#PSW&imm16->PSW
#7.
rem_out8:
#8. Emit light.	
#8-1. Set a2 to address of working. a1 becomes the end +2.
	mov		working,a2
rem_out82:
#8-2. Light emit through data 1(1), 0(0), pause(2) or header (3). 
	mov		(a2),d0
	cmp		1,d0
	bcs		rem_out820		#if CF=1 then jp d8(label)
	beq		rem_out821		#if ZF=1 then jp d8(label)
	cmp		3,d0
	bcs		rem_out822		#if CF=1 then jp d8(label)
rem_out823:
	mov		(a0),d0			#header light emitting time
	and		d0,d0
	beq		rem_out83		#if ZF=1 then jp d8(label)
	mov		(2,a0),d1
	jmp		rem_out825
rem_out822:
	mov		0,d0			#pause light emitting time=0
	mov		(12,a0),d1
	jmp		rem_out825
rem_out821:
	mov		(4,a0),d0		#Data 1 light emitting time
	mov		(6,a0),d1
	jmp		rem_out825
rem_out820:
	mov		(8,a0),d0		#Data 0 light emitting time
	mov		(10,a0),d1
rem_out825:
	jsr		rem_HL
rem_out83:
#8-3. End?
	add		2,a2
	cmp		a1,a2
	bne		rem_out82		#if ZF=0 then jp d8(label)
#9.Allow interruptions.
	or		PSW_IEbit,psw		#PSW|imm16->PSW

	 movx	(0,a3),d0
	 movx	(4,a3),d1
	 movx	(8,a3),d2
	 movx	(12,a3),d3
	 mov	(16,a3),a0
	 mov	(20,a3),a1
	 mov	(24,a3),a2
	 add	28,a3				#pop d0,d1,d2,d3,a0,a1,a2
	rts

st_work:
#[Function]		Place lower order d3 bits of contents in d2 into working from a1. 
#[Conditions] 	None
#[Destruction]	d0,d2,d3,a1=a1+d3*2
#[Enter]		d2=fixed data or button data
#				d3=number of effective bits of d2(lower order)
#				a1=address of data storage area
	 add	-4,a3				#push d3
	 movx	d3,(0,a3)

#-1.Terminate if d3=0.
	and		d3,d3
	beq		st_workend		#if ZF=1 then jp d8(label)
st_work0:
#O If d3=>16, make d3=16 and proceed to 4.
	cmp		16,d3
	bcs		st_work1		#if CF=1 then jp d8(label)
	mov		16,d3
	jmp		st_work4
st_work1:
#1. Make (16 - the number of bits of data) d3.
	mov		16,d0
	sub		d3,d0			#Dm-Dn->Dm
	mov		d0,d3
#2. Shift data to the left by d3. 
st_work2:
	rol		d2				#  CF<-bp15..bp0<-CF
	add		-1,d3
	bne		st_work2		#if ZF=0 then jp d8(label)
#3.Make (the number of bits of data) d3.
	mov		(0,a3),d3
#4. Save data in working.
st_work4:
	rol		d2				#  CF<-bp15..bp0<-CF
	bcs		st_work41		#if CF=1 then jp d8(label)
	mov		0,d0
	jmp		st_work40
st_work41:
	mov		1,d0
st_work40:
	mov		d0,(a1)
	add		2,a1
	add		-1,d3
	bne		st_work4		#if ZF=0 then jp d8(label)

st_workend:
	 add	4,a3
	rts

rem_HL:
#*** Output a remote control waveform. ***
#[Function]		Emit light for d0 time and stop for d1 time. 
#				Light emitting time = d0 * Deffi + DHoff
#				Stop time = d1 * Deffi + DLoff
#[Conditions] 	None
#[Destruction]	d0,d1
#[Input]		d0=light emitting time,d1=stop time
.equ	REMCN,	0xffc4
	 add	-4,a3				#push d0
	 movx	d0,(0,a3)
	
	and		d0,d0			#if light emitting time=0, no light is emitted.
	beq		rem_HL1			#if ZF=1 then jp d8(label)
	
	movbu	(REMCN),d0		#Emit light.
	or		0x20,d0
	movb	d0,(REMCN)
	movx	(0,a3),d0		#Loop
rem_HL0:
	nop		# 1
	nop		# 2
	nop		# 3
	nop		# 4
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	add		-1,d0
	bne		rem_HL0			#if ZF=0 then jp

	movbu	(REMCN),d0		#Stop light emission.
	and		~0x20,d0
	movb	d0,(REMCN)
rem_HL1:
	nop		# 1
	nop		# 2
	nop		# 3
	nop		# 4
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	nop		# Necessary if SYSCLK=1840KHz.
	add		-1,d1
	bne		rem_HL1			#if ZF=0 then jp

	 add	4,a3
	rts

_rem_set:
#*** Set remote control carrier. ***
#[Function]		Set a prescalerP(ps1) and timer3tm3. If d0=0, stop ps1 and tm3.
#				Set frequencies = 460KHz / (d1[15:8] + 1) / d1[7:0] + 1)
#[Conditions] 	NO
#[Destruction]	d0,d1
#[Input]		d1 [15:8] is tm3,[7:0] is ps1.
#	For d0 0x00, stop and start operation other than 0x00.
.equ	Atm3md,	0xfe23
.equ	Aps1md,	0xfe2b

	 add	-28,a3				#push d0,d1,d2,d3,a0,a1,a2
	 movx	d0,(0,a3)
	 movx	d1,(4,a3)
	 movx	d2,(8,a3)
	 movx	d3,(12,a3)
	 mov	a0,(16,a3)
	 mov	a1,(20,a3)
	 mov	a2,(24,a3)

				#Stop?
	cmp		0,d0			#if d0=0 then stop.
	beq		rem_set0
				#ps1,tm3 Set.
	mov		Aps1md,a0		#ps1 Set.
	and		0xff,d1			# Count interval=d1[7:0]
	jsr		tmps_set
	mov		Atm3md,a0		#tm3 Set.
##	mov		0x03,d0			#ps1 Clock.
	 movbu	(1,a3),d1			#pop d1 & 8bit Shift
	jsr		tmps_set
	jmp		rem_setend

rem_set0:			#Stop
	mov		Aps1md,a0		#ps1 Stop
	jsr		tmps_dis
	mov		Atm3md,a0		#tm3Stop
	jsr		tmps_dis

rem_setend:
	 movx	(0,a3),d0
	 movx	(4,a3),d1
	 movx	(8,a3),d2
	 movx	(12,a3),d3
	 mov	(16,a3),a0
	 mov	(20,a3),a1
	 mov	(24,a3),a2
	 add	28,a3				#pop d0,d1,d2,d3,a0,a1,a2
	rts

#*** Start tm & ps operations.  ***
#[Function]		Set a count interval of tm and ps, and start count operation
#[Reference] 	Refer to Example of 8-bit Timer Settings of LSI User's Manual. 
#[Destruction]	d0,d1
#[Input]		a0= Address D[23:0] of mode register
#				d1= Base register D[7:0]
tmps_set:
	movbu	(a0),d0			#A) xEN=0,xLD=0
	and		0x3f,d0
	movb	d0,(a0)
	cmp		0,d1			#B) Set a demultiply ratio.
	beq		tmps_set0			#if d1=0 then set 0x01
	movb	d1,(-16,a0)			#else set d1
	jmp		tmps_set1
tmps_set0:
	mov		0x01,d0			#Write a dummy.
	movb	d0,(-16,a0)
tmps_set1:
	movbu	(a0),d0
	or		0x40,d0			#C) xEN=0,xLD=1
	movb	d0,(a0)
	and		0x3f,d0			#D) xEN=0,xLD=0
	movb	d0,(a0)
	or		0x80,d0			#E) xEN=1,xLD=0
	movb	d0,(a0)
	cmp		0,d1			#F) Set a count interval.
	bne		tmps_set2			#if d1<>0 then jp
	movb	d1,(-16,a0)
tmps_set2:
	rts
#*** Stop tm & ps operations. ***
#[Function]		Stop  tm and ps count operations.
#[Destruction]	d0
#[Input]		Address D[23:0] a0 of mode register
tmps_dis:
	movbu	(a0),d0			#Read mode
	and		0x7f,d0			#xEN=0
	movb	d0,(a0)
	rts

	.section	.data
#***** Remote control waveform data *****
#
#	Caution:Operations of those button data marked with O at the end of the line
#	 have been checked, while those without any mark haven't gone through a check.
#
#	98/08/12 Unified inclinations to one of Deffi.
#	         Combined offsets to two of Dhoff and Dloff.
#	         With addition of nop of rem_HL:, values of inclinations and offset have been changed. 
#
.equ	Deffi,	25		#Inclination(us/reg)
.equ	DHoff,	35		#Light emission offset(uS)
.equ	DLoff,	148		#Stop offset(uS)

	.align	2
rtype_sanyo_1:		#Actually measured carrier=37.4KHz(set value 11)		#Model number 00
	.hword	(8970 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4470 - DLoff) / Deffi				#<02>header stop time
	.hword	( 560 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1670 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 560 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 560 - DLoff) / Deffi				#<10>data 0 stop
	.hword	0									#<12>pause
	.hword	0x0008,0x0088,0x0048,0x00c8,0x0028,0x00a8	#<14>Buttons 1-6ch
	.hword	0x0068,0x00e8,0x0018,0x0098,0x0058,0x00d8	#<26> 		7-12ch
	.hword	0x0000,0x0090,0x0050,0x005a,0x009a		#<38> Power supply, volume loud, small,ch-,+
	.hword	0x00a0,0x00c0,0x00d0,0x00b0,0x0010		#<48>TV,others
	.hword	0x0cf3					#<58>fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	0						#<66>repeat 0:None,1:pause once,2:twice
	.hword	0						#<68>At the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data 2
	.hword	0						#<72>number of bits of fixed data 2
rtype_sanyo_2:		#actually measured carrier=37.4KHz(set value 11)		#Model number 01
	.hword	(8970 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4470 - DLoff) / Deffi				#<02>header stop time
	.hword	( 560 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1670 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 560 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 560 - DLoff) / Deffi				#<10>data 0 stop
	.hword	0									#<12>pause
	.hword	0x0008,0x0088,0x0048,0x00c8,0x0028,0x00a8	#<14>Buttons 1-6ch
	.hword	0x0068,0x00e8,0x0018,0x0098,0x0058,0x00d8	#<26> 		7-12ch
	.hword	0x0000,0x0090,0x0050,0x0040,0x0080		#<38> Power supply volume loud, small,ch-,+
	.hword	0x0020,0x00c0,0x00d0,0x00b0,0x0010		#<48>TV,others
	.hword	0x0cf3					#<58>fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverrted,2:same
	.hword	0						#<66>repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>At the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data2
	.hword	0						#<72>number of bits of fixed data2
rtype_sanyo_3:		#Actually measured carrier=37.4KHz(set value 11)		#Model number02
	.hword	(8970 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4470 - DLoff) / Deffi				#<02>header stop time
	.hword	( 560 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1670 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 560 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 560 - DLoff) / Deffi				#<10>data 0 stop
	.hword	0									#<12>pause
	.hword	0x0008,0x0088,0x0048,0x00c8,0x0028,0x00a8	#<14>Buttons 1-6ch
	.hword	0x0068,0x00e8,0x0018,0x0098,0x0058,0x00d8	#<26> 		7-12ch
	.hword	0x0000,0x009a,0x005a,0x0040,0x0080		#<38>Power supply, Volume loud,small,ch-,+
	.hword	0x0020,0x00c0,0x00d0,0x00b0,0x0010		#<48>TV,others
	.hword	0x0cf3					#<58>Fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	1						#<64>Button data inversion 0:none,1:inverted,2:same
	.hword	0						#<66>Repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>At the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data 2
	.hword	0						#<72>number of bits of fixed data 2
rtype_victor_1:		#actually measured carrier=37.4KHz(set value 11)		#Model number03
	.hword	(8420 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4180 - DLoff) / Deffi				#<02>header stop time
	.hword	( 510 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1560 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 510 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 530 - DLoff) / Deffi				#<10>data 0 stop
	.hword	(21800 - DLoff) / Deffi				#<12>pause
	.hword	0x0084,0x0044,0x00c4,0x0024,0x00a4,0x0064	#<14> buttons -1-6ch
	.hword	0x00e4,0x0014,0x0094,0x0054,0x00d4,0x0034	#<26> 		7-12ch
	.hword	0x00e8,0x0078,0x00f8,0x0018,0x0098		#<38> Power supply, volume loud, small,ch-,+
	.hword	0x00c8,0x0000,0x0038,0x0020,0x00c0		#<48>TV, others
	.hword	0x00c0					#<58>fixed data
	.hword	8						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	0						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	2						#<66>Repeat 0:None,1:pause once,2: twice
	.hword	0						#<68>at the time of repetitiojn 0:no header,1: there is a header
	.hword	0x0000					#<70>fixed data 2
	.hword	0						#<72>number of bits of fixed data 2
rtype_victor_2:		#actually measured carrier=37.3KHz(set vakye11)		#Model number04
	.hword	(8970 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4470 - DLoff) / Deffi				#<02>header stop time
	.hword	( 560 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1680 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 560 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 590 - DLoff) / Deffi				#<10>data 0 stop
	.hword	0									#<12>pause
	.hword	0x0080,0x0040,0x00c0,0x0020,0x00a0,0x0060	#<14>  buttons 1-6ch
	.hword	0x00e0,0x0010,0x0090,0x0050,0x00d0,0x0030	#<26> 		7-12ch
	.hword	0x0018,0x0048,0x00c8,0x0088,0x0008		#<38>Power supply volume loud,small,ch-,+
	.hword	0x0038,0x0028,0x0098,0x00ca,0x0058		#<48>TV,others
	.hword	0x23dc					#<58>fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	0						#<66>repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>at the time of repetion 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data 2
	.hword	0						#<72>number of bits of fixed data 2
rtype_victor_3:		#actually measured carrier =36.7KHz(set value11,12)		#model number05
	.hword	0									#<00>header light emitting time
	.hword	( 100 - DLoff) / Deffi				#<02>header stop time
	.hword	( 500 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(3730 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 500 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	(1620 - DLoff) / Deffi				#<10>data 0 stop
	.hword	(30000 - DLoff) / Deffi				#<12>pause
	.hword	0x0002,0x0022,0x0012,0x0032,0x000a,0x002a	#<14> buttons1-6ch
	.hword	0x001a,0x003a,0x0006,0x0026,0x0016,0x0036	#<26> 		7-12ch
	.hword	0x001c,0x0030,0x0008,0x0010,0x0020		#<38> Power supply, volume loud, small,ch-,+
	.hword	0x0014,0x0000,0x0024,0x0000,0x000c		#<48>TV,others
	.hword	0x0000					#<58>fixed data
	.hword	0						#<60>number of bits of fixed data
	.hword	6						#<62>number of bits of button data
	.hword	0						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	2						#<66>repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>at the time of repetition 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data2
	.hword	0						#<72>number of bits of fixed data2
rtype_mitsubushi_1:	#actually measured carrier=31.9KHz(set value13,14)		#Model number06
rtype_mitsubushi_3:	#actually measured carrier=31.9KHz(set value 13,14)		#model number 06
	.hword	0									#<00>header light emitting time
	.hword	0									#<02>header stop time
	.hword	( 330 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(2090 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 330 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 890 - DLoff) / Deffi				#<10>data 0 stop
	.hword	(27500 - DLoff) / Deffi				#<12>pause
	.hword	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000	#<14> buttons 1-6ch
	.hword	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000	#<26> 		7-12ch
	.hword	0x0040,0x0044,0x0054,0x0048,0x0050		#<38>Power supply volume loud, small, ch-,+
	.hword	0x0000,0x0000,0x0000,0x0000,0x0000		#<48>TV,others
	.hword	0x00e2					#<58>fixed data
	.hword	8						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	0						#<64>inversion of button data  0:none,1:inverted,2:same
	.hword	2						#<66>repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>at the time of repetition 0:no header,1: there is a header
	.hword	0x0000					#<70>fixed data2
	.hword	0						#<72>number of bits of fixed data 2
rtype_mitsubushi_2:	#actually measured carrier =37.4KHz(set value 11)		#model number07
	.hword	0									#<00>header light emitting time
	.hword	0									#<02>header stop time
	.hword	( 510 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(3660 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 510 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	(1580 - DLoff) / Deffi				#<10>data 0 stop
	.hword	(31100 - DLoff) / Deffi				#<12>pause
	.hword	0x0002,0x0022,0x0012,0x0032,0x000a,0x002a	#<14>buttons 1-6ch
	.hword	0x001a,0x003a,0x0006,0x0026,0x0016,0x0036	#<26> 		7-12ch
	.hword	0x001c,0x0030,0x0008,0x0010,0x0020		#<38> power supply, volume loud,small, ch-,+
	.hword	0x002c,0x0000,0x0024,0x0000,0x0000		#<48>TV,others
	.hword	0x0000					#<58>fixed data
	.hword	0						#<60>number of bits of fixed data
	.hword	6						#<62>number of bits of button data
	.hword	0						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	2						#<66>repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data2
	.hword	0						#<72>number of bits of fixed data2
rtype_fujitsu_1:	#actually measured carrier=37.5KHz(set value11)		#model number 08
rtype_fujitsu_2:	#actually measured carrier=37.5KHz(set value 11)		#model number 08
	.hword	(8920 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4570 - DLoff) / Deffi				#<02>header stop time
	.hword	( 560 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1670 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 560 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 560 - DLoff) / Deffi				#<10>data 0 stop
	.hword	0									#<12>pause 
	.hword	0x0080,0x0040,0x00c0,0x0020,0x00a0,0x0060	#<14> buttons 1-6ch
	.hword	0x00e0,0x0010,0x0090,0x0050,0x00d0,0x0030	#<26> 		7-12ch
	.hword	0x0048,0x0068,0x00e8,0x00b8,0x0038		#<38> Power supply, volume loud,small, ch-,+
	.hword	0x0000,0x00c8,0x00a8,0x0028,0x00f8		#<48>TV,others
	.hword	0x0a857					#<58>fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverteed,2:same
	.hword	0						#<66>repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>at the time of repetitions 0:no header,1: there is a header
	.hword	0x0000					#<70>fixed data2
	.hword	0						#<72>number of bits of fixed data 2

rtype_sony_1:		#actually measured carrier=39.4KHz( set value 10,11)		#Model number 09
rtype_sony_3:		#actually measured carrier=39.4KHz(set value 10,11)		#Model number 09
	.hword	(2400 - DHoff) / Deffi				#<00>header light emitting time
	.hword	( 600 - DLoff) / Deffi				#<02>header stop time
	.hword	(1200 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	( 600 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 600 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 600 - DLoff) / Deffi				#<10>data 0 stop
	.hword	(25500 - DLoff) / Deffi				#<12>pause
	.hword	0x0008,0x0408,0x0208,0x0608,0x0108,0x0508	#<14>buttons 1-6ch
	.hword	0x0308,0x0708,0x0088,0x0488,0x0288,0x0688	#<26> 		7-12ch
	.hword	0x0548,0x0248,0x0648,0x0448,0x0048		#<38> Pow4r supply, volume loud, smallch-,+
	.hword	0x0528,0x0748,0x0148,0x02e8,0x0368		#<48>TV,others
	.hword	0x0000					#<58>fixed data
	.hword	0						#<60>number of bits of fixed data
	.hword	11						#<62>number of bits of button data
	.hword	0						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	2						#<66>repeat 0:none,1:pause once,2:twice
	.hword	1						#<68>at the time of repetitions 0:no header,1:there is a header.
	.hword	0x0000					#<70>fixed data2
	.hword	0						#<72>number of bits of fixed data 2
rtype_sony_4:		#actually measured carrier =39.4KHz(set value10,11)		#Model number 10
	.hword	(2400 - DHoff) / Deffi				#<00>header light emitting time
	.hword	( 600 - DLoff) / Deffi				#<02>header stop time
	.hword	(1200 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	( 600 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 600 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 600 - DLoff) / Deffi				#<10>data 0 stop
	.hword	(24500 - DLoff) / Deffi				#<12>pause
	.hword	0x000e,0x040e,0x020e,0x060e,0x010e,0x050e	#<14>buttons 1-6ch
	.hword	0x030e,0x070e,0x008e,0x048e,0x028e,0x068e	#<26> 		7-12ch
	.hword	0x054e,0x024e,0x064e,0x044e,0x004e		#<38>Power supply, volume loud, small, ch-,+
	.hword	0x079e,0x074e,0x056e,0x02de,0x036e		#<48>TV,others
	.hword	0x0000					#<58>fixed data
	.hword	0						#<60>number of bits of fixed data
	.hword	11						#<62>number of bits of button data
	.hword	0						#<64>button data inversion0 :None,1:inverted,2:same
	.hword	2						#<66>repeat 0:none,1:pause once,2:twice
	.hword	1						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data 2
	.hword	0						#<72>number of bits of fixed data 2
rtype_toshiba_1:	#actually measured carrier=37.5KHz(set value 11)		#model number 11
rtype_toshiba_2:	#actually measured carrier =37.4KHz(set value 11)		#model number 11
	.hword	(8970 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4470 - DLoff) / Deffi				#<02>header stop time
	.hword	( 560 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1670 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 560 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 560 - DLoff) / Deffi				#<10>data 0 stop
	.hword	0									#<12>pause
	.hword	0x0080,0x0040,0x00c0,0x0020,0x00a0,0x0060	#<14> Buttons 1-6ch
	.hword	0x00e0,0x0010,0x0090,0x0050,0x00d0,0x0030	#<26> 		7-12ch
	.hword	0x0048,0x0058,0x0078,0x00f8,0x00d8		#<38> Power supply, Volume loud, small,ch-,+
	.hword	0x000f0,0x00c8,0x0008,0x0038,0x00e8		#<48>TV,others
	.hword	0x02fd					#<58>fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	0						#<66>repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data 2
	.hword	0						#<72>number of bits of fixed data 2
rtype_nec_1:		#actually measured carrier=37.5KHz(set value 11)		#model number 12
rtype_nec_2:		#actually measured carrier =37.5KHz(set value 11)		#model number 12
	.hword	(9030 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4420 - DLoff) / Deffi				#<02>header stop time
	.hword	( 560 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1670 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 560 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 560 - DLoff) / Deffi				#<10>data 0 stop
	.hword	0									#<12>pause
	.hword	0x0008,0x0088,0x0048,0x00c8,0x0028,0x00a8	#<14>buttons 1-6ch
	.hword	0x0068,0x00e8,0x0018,0x0098,0x0058,0x00d8	#<26> 		7-12ch
	.hword	0x0010,0x0040,0x00c0,0x0080,0x0000		#<38>Poser supply, volume, loud, small,ch-,+
	.hword	0x0050,0x00b8,0x0090,0x00f0,0x0078		#<48>TV,others
	.hword	0x18e7					#<58>fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>mnumber of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	0						#<66>repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixe data 2
	.hword	0						#<72>number of bits of fixed data 2
rtype_pioneer_1:	#actually measured carrier=39.5KHz(set value 10,11)		#model number13
	.hword	(8460 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4280 - DLoff) / Deffi				#<02>header stop time
	.hword	( 530 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1590 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 530 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 530 - DLoff) / Deffi				#<10>data 0 stop
	.hword	0									#<12>pause
	.hword	0x0080,0x0040,0x00c0,0x0020,0x00a0,0x0060	#<14> Buttons 1-6ch
	.hword	0x00e0,0x0010,0x0090,0x0000,0x0062,0x00e2	#<26> 		7-12ch
	.hword	0x0038,0x0050,0x00d0,0x0088,0x0008		#<38> Power supply, volume loud, small,ch-,+
	.hword	0x00a2,0x0078,0x0092,0x0052,0x0012		#<48>TV,others
	.hword	0x55aa					#<58>Fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	0						#<66>repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data 2
	.hword	0						#<72>number of bits of fixed data 2
rtype_hitachi_1:	#actually measured carrier =37.5KHz(set value11)		#model number14
	.hword	(9010 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4430 - DLoff) / Deffi				#<02>header stop time
	.hword	( 600 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1620 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 600 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 530 - DLoff) / Deffi				#<10>data 0 stop
	.hword	0									#<12>pause
	.hword	0x00b0,0x0070,0x00f0,0x0038,0x00b8,0x0078	#<14>Buttons 1-6ch
	.hword	0x00f8,0x0020,0x00a0,0x0060,0x00e0,0x0030	#<26> 		7-12ch
	.hword	0x00e8,0x0048,0x00a8,0x0018,0x0098		#<38> Power supply, volume loud, small,ch-,+
	.hword	0x0090,0x0010,0x00d0,0x0008,0x0088		#<48>TV, others
	.hword	0x0af5					#<58>fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	0						#<66>repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>Fixed data2
	.hword	0						#<72>number of bits of fixed data2
rtype_hitachi_2:	#actually measured carrier=37.5KHz(set value 11)		#model number 15
	.hword	(9020 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4420 - DLoff) / Deffi				#<02>header stop time
	.hword	( 600 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1640 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 600 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 530 - DLoff) / Deffi				#<10>data 0 stop
	.hword	0									#<12>pause
	.hword	0x00a0,0x0060,0x00e0,0x0030,0x00b0,0x0070	#<14>Buttons 1-6ch
	.hword	0x00f0,0x0038,0x00b8,0x0020,0x00da,0x003b	#<26> 		7-12ch
	.hword	0x0028,0x001a,0x009a,0x0098,0x0018		#<38> Power Supply, volume loud, small, ch-,+
	.hword	0x006a,0x0000,0x00ba,0x0078,0x003a		#<48>TV,others
	.hword	0x7689					#<58>fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	0						#<66>repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data2
	.hword	0						#<72>number of bits of fixed data 2
rtype_funai_1:		#actually measured carrier=36.1KHz(set value 11,12)		#model number 16
	.hword	(3500 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(3450 - DLoff) / Deffi				#<02>header stop time
	.hword	( 890 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(2600 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 890 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 830 - DLoff) / Deffi				#<10>data 0 stop
	.hword	(34000 - DLoff) / Deffi				#<12>pause
	.hword	0x097e,0x0961,0x0951,0x0971,0x0949,0x0969	#<14> buttons 1-6ch
	.hword	0x0959,0x0979,0x0945,0x0965,0x0955,0x0975	#<26> 		7-12ch
	.hword	0x0941,0x0943,0x0963,0x0944,0x0942		#<38> Power supply, volume loud, small ch-,+
	.hword	0x0000,0x0000,0x0973,0x0000,0x0968		#<48>TV,others
	.hword	0x0000					#<58>fixed data
	.hword	0						#<60>number of bits of fixed data
	.hword	12						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	2						#<66>repeat 0:none,1:pause once,2:twice
	.hword	1						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data 2
	.hword	0						#<72>number of bits of fixed data 2
rtype_funai_3:		#actually measured carrier=37.5KHz(set value11)		#model number 17
	.hword	(4570 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4280 - DLoff) / Deffi				#<02>header stop time
	.hword	( 610 - DHoff) / Deffi				#<04>data 1 light emission 
	.hword	(1590 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 610 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 610 - DLoff) / Deffi				#<10>data 0 stop
	.hword	0									#<12>pause
	.hword	0x0000,0x0080,0x0040,0x00c0,0x0020,0x00a0	#<14> buttons 1-6ch
	.hword	0x0060,0x00e0,0x0010,0x0090,0x0050,0x00d0	#<26> 		7-12ch
	.hword	0x0028,0x0048,0x00c8,0x0088,0x0008		#<38> Power supply, Volume, loud, small,ch-,+
	.hword	0x0068,0x0000,0x0000,0x0000,0x0000		#<48>TV,others
	.hword	0x7070					#<58>fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	0						#<66>repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data 2
	.hword	0						#<72>number of bits of fixed data 2
rtype_funai_4:		#actually measured carrier =36.2KHz(set value 11,12)		#model number 18
	.hword	(3500 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(3450 - DLoff) / Deffi				#<02>header stop time
	.hword	( 890 - DHoff) / Deffi				#<04>data 1 light emission 
	.hword	(2600 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 890 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 830 - DLoff) / Deffi				#<10>data 0 stop
	.hword	(34000 - DLoff) / Deffi				#<12>pause
	.hword	0x097e,0x0961,0x0951,0x0971,0x0949,0x0969	#<14> buttons 1-6ch
	.hword	0x0959,0x0979,0x0945,0x0965,0x0955,0x0975	#<26> 		7-12ch
	.hword	0x0941,0x0143,0x0163,0x0144,0x0142		#<38>Power supply, volume loud, small,ch-,+
	.hword	0x0000,0x0000,0x0973,0x0000,0x0968		#<48>TV,others
	.hword	0x0000					#<58>fixed data
	.hword	0						#<60>number of bits of fixed data
	.hword	12						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:sae
	.hword	2						#<66>repeat 0:none,1:pause once,2:twice
	.hword	1						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data2
	.hword	0						#<72>number of bits of fixed data 2
rtype_funai_5:		#actually measured carrier=37.5KHz(set value11)		#model number19
	.hword	(9000 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4400 - DLoff) / Deffi				#<02>header stop time
	.hword	( 610 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1610 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 610 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 550 - DLoff) / Deffi				#<10>data 0 stop
	.hword	(40700 - DLoff) / Deffi				#<12>pause
	.hword	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000	#<14>buttons 1-6ch
	.hword	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000	#<26> 		7-12ch
	.hword	0x00d4,0x00a8,0x0028,0x0068,0x00e8		#<38>Power supply, volume loud, small,ch-,+
	.hword	0x0000,0x0000,0x0000,0x0000,0x0000		#<48>TV,others
	.hword	0xc1ca					#<58>fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	2						#<66>repeat 0:none,1:pauase once,2:twice
	.hword	1						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data 2
	.hword	0						#<72>number of bits of fixed data2
rtype_national_1:	#actually measured carrier =36.2KHz(set value 11,12)		#model number20
rtype_national_2:	#actually measured carrier =36.1KHz(set value11,12)		#model number20
rtype_national_4:	#actually measured carrier =36.1KHz(set value 11,12)		#model number20
	.hword	(3600 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(1700 - DLoff) / Deffi				#<02>header stop time
	.hword	( 460 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1260 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 460 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 400 - DLoff) / Deffi				#<10>data 0 stop
	.hword	(74770 - DLoff) / Deffi				#<12>pause
	.hword	0x00809,0x08889,0x04849,0x0c8c9,0x02829,0x0a8a9	#<14> buttons 1-6ch
	.hword	0x06869,0x0e8e9,0x01819,0x09899,0x05859,0x0d8d9	#<26> 		7-12ch
	.hword	0x0bcbd,0x00405,0x08485,0x0acad,0x02c2d		#<38> Power supply,volume, loud, small, ch-,+
	.hword	0x0a0a1,0x0cccd,0x04c4d,0x09c9d,0x0f0f1		#<48>TV,others
	.hword	0x4004					#<58>fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	16						#<62>number of bits of button data
	.hword	0						#<64>button data inversions 0:none,1:inverted,2:same
	.hword	1						#<66>repeat 0:none,1:pause once,2:twice
	.hword	1						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x0100					#<70>fixed data 2
	.hword	16						#<72>number of bits of fixed data 2
rtype_national_3:	#actually measured carrier=36.2KHz(set value 11,12)		#model number 21
	.hword	(3550 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(3400 - DLoff) / Deffi				#<02>header stop time
	.hword	( 890 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(2600 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 890 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 820 - DLoff) / Deffi				#<10>data 0 stop
	.hword	(39000 - DLoff) / Deffi				#<12>pause
	.hword	0x0002,0x0022,0x0012,0x0032,0x000a,0x002a	#<14> buttons 1-6ch
	.hword	0x001a,0x003a,0x0006,0x0026,0x0016,0x0036	#<26> 		7-12ch
	.hword	0x0001,0x0009,0x0029,0x0031,0x0011		#<38> Power supply, volume, loud, small,ch-,+
	.hword	0x002c,0x002f,0x0000,0x0319,0x031c		#<48>TV,others
	.hword	0x0000					#<58>fixed data
	.hword	0						#<60>number of bits of fixed data
	.hword	11						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	2						#<66>repeat 0:none,1:pause once,2:twice
	.hword	1						#<68>At the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data2
	.hword	0						#<72>number of bits of fixed data 2
rtype_aiwa_1:		#actually measured carrier=37.5KHz(set value 11)		#model number 22
rtype_aiwa_2:		#actually measured carrier =37.5KHz(set value 11)		#model number 22
	.hword	(9180 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4280 - DLoff) / Deffi				#<02>header stop time
	.hword	( 550 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1630 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 550 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 550 - DLoff) / Deffi				#<10>data 0 stop
	.hword	0									#<12>pause
	.hword	0x0807f,0x040bf,0x0c03f,0x020df,0x0a05f,0x0609f	#<14> buttons 1-6ch
	.hword	0x0e01f,0x010ef,0x0906f,0x050af,0x0d02f,0x030cf	#<26> 		7-12ch
	.hword	0x000ff,0x018e7,0x09867,0x0827d,0x002fd		#<38> Power supply, volume, loud, small, ch-,+
	.hword	0x0708f,0x0c837,0x052ad,0x0f20d,0x0c23d		#<48>TV,others
	.hword	0x0378					#<58>fixed data
	.hword	10						#<60>number of bits of fixed data
	.hword	16						#<62>number of bits of button data
	.hword	0						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	0						#<66>repeat 0:none,1:pause once,2:twice
	.hword	0						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x043f					#<70>fixed data2
	.hword	16						#<72>number of bits of fixed data2
rtype_aiwa_3:		#actually measured carrier =37.4KHz(set value11)		#model number 23
	.hword	(9000 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4430 - DLoff) / Deffi				#<02>header stop time
	.hword	( 600 - DHoff) / Deffi				#<04>data 1 light emission
	.hword	(1640 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 600 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 530 - DLoff) / Deffi				#<10>data 0 stop
	.hword	(44000 - DLoff) / Deffi				#<12>pause
	.hword	0x0080,0x0040,0x00c0,0x0020,0x00a0,0x0060	#<14> buttons 1-6ch
	.hword	0x00e0,0x0010,0x0090,0x0000,0x0032,0x00b2	#<26> 		7-12ch
	.hword	0x0092,0x0030,0x00b0,0x00d0,0x0050		#<38> Power supply, volume, loud, small,ch-,+
	.hword	0x00c2,0x0022,0x0002,0x0042,0x0082		#<48>TV,others
	.hword	0x6140					#<58>fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	2						#<66>repeat 0:none,1:pause once,2:twice
	.hword	1						#<68>at the time of repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data2
	.hword	0						#<72>number of bits of fixed data 2
rtype_aiwa_4:		#actually measured carrier=37.4KHz(set value 11)		#model numer 24
	.hword	(9010 - DHoff) / Deffi				#<00>header light emitting time
	.hword	(4420 - DLoff) / Deffi				#<02>header stop time 
	.hword	( 600 - DHoff) / Deffi				#<04>data 1 light emission 
	.hword	(1630 - DLoff) / Deffi				#<06>data 1 stop
	.hword	( 600 - DHoff) / Deffi				#<08>data 0 light emission
	.hword	( 540 - DLoff) / Deffi				#<10>data 0 stop
	.hword	(43000 - DLoff) / Deffi				#<12>pause
	.hword	0x0080,0x0040,0x00c0,0x0020,0x00a0,0x0060	#<14> buttons 1-6ch
	.hword	0x00e0,0x0010,0x0090,0x0000,0x0032,0x00b2	#<26> 		7-12ch
	.hword	0x0092,0x0030,0x00b0,0x001a,0x002a		#<38> Power supply, volume, loud, small, ch-,+
	.hword	0x00c2,0x0022,0x0002,0x0042,0x0082		#<48>TV,others
	.hword	0x013a					#<58>fixed data
	.hword	16						#<60>number of bits of fixed data
	.hword	8						#<62>number of bits of button data
	.hword	1						#<64>button data inversion 0:none,1:inverted,2:same
	.hword	2						#<66>repeat 0:none,1:pause once,2:twice
	.hword	1						#<68>at the time if repetitions 0:no header,1:there is a header
	.hword	0x0000					#<70>fixed data2
	.hword	0						#<72>number of its of fixed data2
working:
	.hword	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0		#1 data 1,0 data 0
	.hword	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0		#2 pause,3 header
	.hword	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.hword	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.hword	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.hword	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.hword	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.hword	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
#################################################


#===============================================================================
# Copyright (c) 1998-1999.  Seiko Instruments Inc.  All rights reserved. 
#===============================================================================
