/****************************************/
/* Sample programs of remote controller	*/
/****************************************/

#include<stdio.h>	/* C language standard library sprintf */

#include"rupsys.h"
#include"lcdbios.h"
#include"wbios.h"
#include"psdos.h"

void RMopenTx(void);		/* Start remote control communications through light emission.	*/
void RMopenRx(void);		/* Start remote control communications through light reception.	*/
void RMclose (void);		/* Terminate remote control communications	*/
void COMmode(unsigned char);/* (1)Set a communications method sw=7learning remote control II,sw=4 learning remote control,sw=0 none */
void REMmode(int);			/* (2) Set either light emission or light reception. sw=1 light emission state,sw=0 light reception state */
void rem_set(int,int);		/* (3) comrem.asm */
void FILset(unsigned char);	/* (4)Set a filter. sw=6=15KHz-,sw=0=Stop */
void REMout_test(int);		/* Light emission test sw=1 emit light,sw=0stop */
void rem_out(int,int);		/* Emit light  comrem.asm */

int main(void)
{
	int Key=1;
	int rREMtitle,rREMkey;
	#define REMCONtype 8
	#define REMCONfreq 23	/*  9=46.0KHz, 10=41.8KHz, 11=38.3KHz (SYSCLK=920KHz) */
							/* 12=35.4KHz, 13=32.9KHz, 14=30.7KHz (SYSCLK=920KHz) */
							/* 19=46.0KHz, 21=41.8KHz, 23=38.3KHz (SYSCLK=1840KHz) */
							/* 25=35.4KHz, 27=32.9KHz, 29=30.7KHz (SYSCLK=1840KHz) */
	
	/* Note:When you change a model of a remote control,				*/
	/*		Change the following three, namely  						*/
	/*		"REMCONtype", "REMCONfreq" and "first line of gv_kput". 	*/
	
    screen(1);

	cls(4);
	gv_kput(0,0, "TV RemC - FUJITSU",0,0,0);		/* Character display */
	gv_kput(0,12,"      Enter=Power",1,0,0);
	gv_kput(0,22,"    Channel(+)   ",1,0,0);
	gv_kput(0,32," Vol(-) + Vol(+) ",1,0,0);
	gv_kput(0,42,"    Channel(-)    ",1,0,0);
	gv_kput(0,52,"        Menu=Exit",1,0,0);
	rREMtitle = gv_reverse(0,0,101,11);				/* Set an inverted area */

    while( !(Key&Bkey_D) ){			/* Exit if Menu */
	    Key=bi_getbtn();

		if( Key&Bkey_B ){			/* Powe if Enter */
			rREMkey = gv_reverse(6*6,12,6*17-1,21);
			RMopenTx();						/* Start remote control communications through light emission	*/
			rem_out(REMCONtype, 12);		/* Emit light */
			RMclose();						/* Terminate remote control communications.	*/
			rREMkey = gv_reverse(6*6,12,6*17-1,21);
		}
		if( Key&Bkey_rg ){			/* Vol (*) if -> */
			rREMkey = gv_reverse(6*10,32,6*16-1,41);
			RMopenTx();						/* Start remote control communications through light emission.	*/
			rem_out(REMCONtype, 13);		/* Emit light. */
		    RMclose();						/* Terminate remote control communications.	*/
			rREMkey = gv_reverse(6*10,32,6*16-1,41);
		}
		if( Key&Bkey_lf ){			/* Vol (-) if <-*/
			rREMkey = gv_reverse(6*1,32,6*7-1,41);
			RMopenTx();						/* Start remote control communications through light emission.	*/
			rem_out(REMCONtype, 14);		/* Emit light. */
		    RMclose();						/* Terminate remote control communications.	*/
			rREMkey = gv_reverse(6*1,32,6*7-1,41);
		}
		if( Key&Bkey_dw ){			/* Cannel(-) if v  */
			rREMkey = gv_reverse(6*4,42,6*14-1,51);
			RMopenTx();						/* Start remote control communications through light emission.	*/
			rem_out(REMCONtype, 15);		/* Emit light. */
		    RMclose();						/* Terminate remote control communications. 	*/
			rREMkey = gv_reverse(6*4,42,6*14-1,51);
		}
		if( Key&Bkey_up ){			/* Cannel(+) if ^  */
			rREMkey = gv_reverse(6*4,22,6*14-1,31);
			RMopenTx();						/* Start remote control communications through light emission.	*/
			rem_out(REMCONtype, 16);		/* Emit light */
		    RMclose();						/* Terminate remote control communications.	*/
			rREMkey = gv_reverse(6*4,22,6*14-1,31);
		}
		if( Key&Bkey_C ){			/* Light reception (test) if EL */
			RMopenRx();						/* Start remote control communications through light reception.	*/
		}
		if( Key&Bkey_A ){			/* Light emission (test) if Filer */
		}
		bi_clrbtn();
    }
    /* Terminate operation */
    RMclose();						/* Terminate remote control communications.	*/
	gv_place(0,0);
	cls(4);

	return 0;
}
/******************  Subroutines  *****************/
void RMopenTx ( void )
{
/* 	*/
	COMmode( 7 );				/* (1)Set communications method.=7 Leraning remote control II*/
	REMmode( 1 ); 				/* (2)Set either light emission or light reception.=Emit light. */
	rem_set( 1, REMCONfreq );	/* (3)Set carrier.=38KHz */
	FILset( 0 );				/* (4)Set a filter.=Stop. */
}
void RMopenRx ( void )
{
/* Start remote control communications through light reception.	*/
	COMmode( 7 );			/* (1)Set a communications method7 =Learning remote control II. */
	REMmode( 0 ); 			/* (2)Set either light emission or light reception.=Receive light.*/
	rem_set( 0, 0 );		/* (3)Stop carrier.=Stop. */
	FILset( 6 );			/* (4)Set a filter.=15KHz- */
}
void RMclose ( void )
{
/* Terminate remote control communications.	*/
	FILset( 0 );			/* (4)Set a filer.=Stop. */
	rem_set( 0, 0 );		/* (3)Set carrier.=Stop. */
	REMmode( 1 ); 			/* (2)Set either light emission or light reception.=Emit light. */
	COMmode( 0 );			/* (1)Set a communications method=0 None */
}
#define PORT70 *(unsigned char*)0x0070
void COMmode( unsigned char sw )
{
/* (1)Set a communications method. sw=7 learning remote control II,sw=4learning remote control,sw=0 none */
	PORT70=sw;
}
#define SRADY *(unsigned char*)0xffc3
#define P4DIR *(unsigned char*)0xffe4
#define POWCT2 *(unsigned char*)0xffc5
void REMmode( int sw )
{
/* (2)Set either light emission or light reception. sw=1 light emission state,sw=0 light reception state */
    if( sw!=0 ){
    /* Emit light. SRADY=0,P4DIR=out,POWCT2=off */
	SRADY =SRADY &(~0x40);
	P4DIR =P4DIR |( 0x20);
	POWCT2=POWCT2&(~0x02);
    }else{
    /* Receive light. SRADY=1,P4DIR=in,POWCT2=on */
	SRADY =SRADY |( 0x40);
	P4DIR =P4DIR &(~0x20);
	POWCT2=POWCT2|( 0x02);
    }
}
#define PORT72 *(unsigned char*)0x0072
void FILset( unsigned char sw )
{
/* (4)Select a filter. sw=6=15KHz-,sw=0=Stop */
	PORT72=sw;
}
#define REMCN *(unsigned char*)0xffc4
void REMout_test( int sw )
{
/* Light emission test sw=1 Emit light.,sw=0 Stop. */
    if( sw!=0 ){
    /* Emit light. REMCN=1 */
	REMCN =REMCN |( 0x20);
    }else{
    /* Stop. REMCN=0 */
	REMCN =REMCN &(~0x20);
    }
}
