/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		onHand/Ruputer sample program 									*/
/*		<<Model for xmodem>>     										*/
/*======================================================================*/

#include<string.h>
#include"lcdbios.h"
#include"wbios.h"
#include"psdos.h"
#include"rupsys.h"

#include"applib.h"

/* Conversion from a integer to a character string  */
char *itoa( int test,int carr )
{
    static char data[20];
    int i, flg=0;

    if( carr<=0 || 5<carr ) carr=5;

    for( i=0; i<=carr; i++ )
		data[i]=' ';

    i=carr;
    if( test==0 )
		data[i--]='0';
    else if( test<0 ){
		flg=1;
		test=-test;
    }
    while( test!=0 ){
		if( i<1 ){
		    data[0]=data[1]=data[2]=data[3]=data[4]='U';
		    data[carr+1]='\0';
		    return(data);
		}
		data[i]=test%10+'0';
		test   =test/10;
		i--;
    }

    if( flg==1 ) data[i]='-';

    data[carr+1]='\0';
    return( data );
}
/* 3D rendering */
void disp3D( int x0,int y0,int x1,int y1,int mx,int my )
{
    char buff[1024];

    gv_get(x0,y0,x1,y1,buff);
    gv_put(x0+mx  ,y0+my  ,buff,2);
}


/***********************Relations****************************/
void chk_WALL( int wall0,int wall1, int *X, int *dX )
{
/* Line screen */
    if( *X<wall0 ){
	*X =2*wall0-(*X);
/*	*dX=-((*dX)+*X/10);*/
	*dX=-(*dX);
    }else if( wall1<*X ){
	*X =2*wall1-(*X);
	*dX=-(*dX);
    }
}
void lineSCR(int LN,int logic,unsigned char style1)
{
    char buf[1024];
    int i,ii;
    unsigned char       style0=0x00;

    static int x0[10]={20,20,20,20,20,20,20,20,20,20},
               x1[10]={50,50,50,50,50,50,50,50,50,50},
               y0[10]={13,13,13,13,13,13,13,13,13,13},
               y1[10]={30,30,30,30,30,30,30,30,30,30};
    static int dx0=2, dx1=-3, dy0=6, dy1=1;
    static int xp0=20,xp1=50,yp0=13,yp1=30;

    LN=LN-1;
    if( LN>9 ) LN=9;
    if( logic==1 ) style0=style1;

    gv_get(0,0,101,63,buf);
    gv_line(xp0,yp0,xp1,yp1,1,0x00);

    bi_clrbtn();
    while(!bi_scanbtn()&&!(scanALM())){
		x0[LN]+=dx0; x1[LN]+=dx1; y0[LN]+=dy0; y1[LN]+=dy1;

		chk_WALL( 0,101, &x0[LN], &dx0 );
		chk_WALL( 0,101, &x1[LN], &dx1 );
		chk_WALL( 0, 63, &y0[LN], &dy0 );
		chk_WALL( 0, 63, &y1[LN], &dy1 );

		gv_line(xp0,yp0,xp1,yp1,logic,style0);
		gv_line(x0[LN],y0[LN],x1[LN],y1[LN],logic,style1);

		xp0=x0[0]; xp1=x1[0]; yp0=y0[0]; yp1=y1[0];
		for(i=0;i<LN;i++){
		    ii=i+1;
		    x0[i]=x0[ii]; x1[i]=x1[ii]; y0[i]=y0[ii]; y1[i]=y1[ii];
		}
    }
    gv_put(0,0,buf,0);
    for(i=0;i<10;i++){
		x0[i]=x0[LN]; x1[i]=x1[LN]; y0[i]=y0[LN]; y1[i]=y1[LN];
    }
    xp0=x0[0]; xp1=x1[0]; yp0=y0[0]; yp1=y1[0];
    bi_clrbtn();
}

/***************** Function selection menu *****************/

MENU Mp[] = {
	{ setExitMenu,  "Exit",0,0}
};

int Select_menu( struct SELfunc S )
{
    char buf[1024];
    int  SEL,SELpos,rst;
	unsigned int Key;
    const int  LSTx=20, LSTy=40;
    const int  LSTup=LSTy-12, LSTdw=LSTy+14;
    const int  SIGup=LSTy-11, SIGdw=LSTy+14, SIGx=LSTx+28;

    static int  SELstg=0;

    if( S.mode!=1 ) S.mode=0;

    cls(3+getscreen());


	/* Display title */
	dispTitle("HyperX");

    if( S.pre==0 ){
		SEL=SELpos=1;
		Key=Bkey_up;
    }else{
		SEL=SELpos=S.pre-1;
		Key=Bkey_dw;
		if( S.mode==0 ) gv_kput(SIGx,SIGup,"/\\",2,0,0);
    }
    if( S.mode==0 ) gv_kput(SIGx,SIGdw,"\\/",2,0,0);
    do{
		if(Key&Bkey_SH)
			Key=bi_scanbtn();

		if( Key&Bkey_up && SEL>0 ){
		    SEL--;
		    if( S.mode==0 ){
				if( SELpos==S.max-1 ) gv_kput(SIGx,SIGdw,"\\/",2,0,0);
				else if( SEL==0 )     gv_kput(SIGx,SIGup,"  ",2,0,0);
		    }
		}else if( Key&Bkey_dw && SEL<S.max-1 ){
		    SEL++;
		    if( S.mode==0 ){
				if( SEL==S.max-1 )   gv_kput(SIGx,SIGdw,"  ",2,0,0);
				else if( SELpos==0 ) gv_kput(SIGx,SIGup,"/\\",2,0,0);
		    }
		}else if( Key&Bkey_B ){
		    if( S.func[SEL]==(void*)0 )	return(SEL);
		    gv_get(0,0,101,63,buf);

		    cls(3+getscreen());
		    
		    SELstg++;
		    S.func[SEL](); /* Execute */
		    SELstg--;

		    gv_put(0,0,buf,0);
		}
		if( SELpos!=SEL ){
		    if( S.mode==0 ){
				gv_kput(LSTx,LSTy,(char*)S.LIST[SEL],0,0,0);
		    }else if( S.mode==1 ){
				if( SEL-1>=0 ) gv_kput(LSTx,LSTup,(char*)S.LIST[SEL-1],2,0,0 );
				else           gv_kput(LSTx,LSTup,"             ",2,0,0 );
				gv_kput(LSTx,LSTy,(char*)S.LIST[SEL],0,0,2);
				if( SEL+1<S.max ) gv_kput(LSTx,LSTdw,(char*)S.LIST[SEL+1],2,0,0 );
				else              gv_kput(LSTx,LSTdw,"             ",2,0,0 );
		    }
		    SELpos=SEL;
		}

		/* Key process */
		Key=Keyin(Bkey_up|Bkey_dw,-1);

		rst = EventCall(Key&~Bkey_SH);

		if (rst==-1)
			return -1;			/* Request for exiting application */
		else if (rst==1) {
		    gv_get(0,0,101,63,buf);

			rst = EventExec();
			if (rst==-1)
				return -1;		/* Request for exiting application */

		    gv_put(0,0,buf,0);
		}
		else if (Key&Bkey_D) {
		    gv_get(0,0,101,63,buf);

			if(aprMenu( "HyperX Menu",Mp,1 ) == -2)
				return -1;		/* Request for exiting application */

		    gv_put(0,0,buf,0);
		}

    }while(1);
}


/********************************/
/** Test routine for alarm   **/
/********************************/
#define ALMKEY *(unsigned char*)0xf080

/* Function registered to timer */
void ALM_PINT(void)
{
    ALMKEY=0xF0;
}
void clrALM(void)
{
    ALMKEY=0;
}
int scanALM(void)
{
    return( ALMKEY );
}

/* Timer waits */
void waitTM(int tm,int cnt)
{
    int *TM,Key=0;


    TM=bi_tmset(tm,255,cnt,ALM_PINT);
    while( 0xF0!=(Key=bi_getbtn()&0xFF) ){
		if( Key==Bkey_C ) bi_el(10);
		else              lineSCR(10,1,0xD0);
    }
    bi_tmdel(TM);
    bi_clrbtn();
}
