/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		onHand/Ruputer sample program 									*/
/*		<<Model for xmodem>>     										*/
/*======================================================================*/

#include"lcdbios.h"
#include"wbios.h"
#include"rupsys.h"
#include"rsh.h"


#define	FAILED		-1
#define	SUCCEED		0

int init(int comkind, int baudrate)
{
	int err;
/*==================*/
/* Initializing communication port	*/
/*==================*/
	err = bi_cominit(comkind, baudrate, 0, 10);

	if (err == FAILED) {
		return(ERR_COMINIT_FAILED);
	}
/*======================*/
/* Communication port opened		*/
/*======================*/

	err = bi_comopen();
	if (err == FAILED) {
		return(ERR_COMOPEN_FAILED);
	}

	return(SUCCEED);
}


void DownLoad(void)
{
	cls(4);
	gv_kput(10,10,"Mount ",5,0,0);
	gv_kput(10,22,"     on the station",5,0,0);

	while( !(bi_getbtn()&Bkey_SH) ){
		if (bi_scanbtn()&Bkey_D) return;
	}	/* Waiting to be connected to a Rs-232c cable  */
	cls(4);

	/* rs232c,38400bps */
	if (FAILED==init(2,3))
		return;

	gv_kput(10,10,"Start ",5,0,0);
	gv_kput(10,22,"     receiving ",5,0,0);

	dwlcall("\\hyperX.exf");
	bi_comclose();

}
void UpLoad(void)
{
	unsigned int dm,dt;

	cls(4);
	gv_kput(10,10,"Mount",5,0,0);
	gv_kput(10,22,"     on the station",5,0,0);

	while( !(bi_getbtn()&Bkey_SH) ){
		if (bi_scanbtn()&Bkey_D) return;
	}	/* Waiting to be connected to Rs232c cable */
	cls(4);

	dm = (unsigned)(1999-1980)*0x200U + (unsigned)10*0x20U + (unsigned)28U;
	dt = (unsigned)15*0x800U + (unsigned)19*0x20U + (unsigned)10U;

	/* rs232c,38400bps */
	if (FAILED==init(2,3))
		return;

	gv_kput(10,10,"Start ",5,0,0);
	gv_kput(10,22,"     sending",5,0,0);


	uplcall("\\upload.txt",256,dm,dt,0);
	bi_comclose();
}
