/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		AD2COM1 Battery Status											*/
/*		Key Operation version  											*/
/*======================================================================*/

#include<stdio.h>	/* C language standard library sprintf */

#include"wbios.h"
#include"psdos.h"
#include"lcdbios.h"

#include"rupsys.h"	/* onHand/Ruputer header Bkey_** key */

int main(void)
{
	int Key=1;
	char buff[32];

    screen(1);		/*Set to the graphic mode*/

	cls(4);
	gv_kput(10,10,"Battery",0,0,0);			/*Write the specified strings to GVRAM*/

    while( !(Key&Bkey_D) ){  				/*Escape when MENU Key is pressed*/
	    Key=bi_getbtn();					/*Button is*/

		if( Key&Bkey_up ){ 					/*if up key*/
			lcdon(1);						/* LCD driver ON */
		}
		if( Key&Bkey_dw ){ 					/*if down key*/
			lcdon(0);						/* LCD driver OFF */
		}
		if( Key&Bkey_lf && getlcdon() ){	/*if left key and LCD-ON*/
			sprintf(buff,"pwlead =%3dd",bi_powerread());	/* Voltage read&string conversion */
			gv_kput(10,25,buff,2,0,0);		/*Character size=2*/
		}
		if( Key&Bkey_rg && getlcdon() ){	/*if right key and LCD-O*/
			sprintf(buff,"pwlead2=%3dd",bi_powerread2());	/* Voltage 2 read&string conversion */
			gv_kput(10,37,buff,2,0,0);		/*Character size=2*/
		}
		bi_clrbtn();						/*Button data buffer clear*/
    }
	lcdon(1);					/*lcd-on*/
	gv_place(0,0);				/*Correspond GVRAM coordinates to the left and upper margin of the physical LCD panel.*/
	cls(4);						/*GVRAM clear*/
    gv_kput(0,2,"application",0,0,0);
    gv_kput(30,40,"terminated",0,0,0);
    cls(4);
}

