/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		Welcome to onHand/Ruputer Park									*/
/*		File operation        											*/
/*======================================================================*/

#include<string.h>
#include"wbios.h"	/* bios */
#include"lcdbios.h"	/* LCD drawing */

int main(void)
{
	int Key=0;
	char filename[80];
	int fp,ret;
	unsigned int Melody[1024];
	unsigned long len;

    screen(1);
	cls(4);
	bi_clrbtn();

	/* Initializes a memory in 0xFFFF */
	memset( &Melody, 0xFFFF, sizeof( Melody ) );
	/* Sets a file name */
	strcpy(filename,"Open.SND");

	if( CheckVol() ){/* Prechecking the voltage */
		dispVOLerr();
		dos_exit(0);
	}

	/* Opens a file with a lead mode */
	if( ( fp = dos_fopen( filename, 0 ) ) <0 ) {
		gv_kput(0,20,"Open.SND Open NG",5,0,0);
	}
	else {
		/* Obtains the file length */
		len = dos_fseek( fp, 2, 0 );
		if( len > 1024 ) len = 1024;

		/* Transfers it from the head to the buffer */
		dos_fseek( fp, 0, 0 );
		ret = dos_fread( fp, (char *)Melody, (int)len );

		if (ret==len)
			gv_kput(0,20,"Open snd playing",5,0,0);
		else
			gv_kput(0,20,"Abnormal reading",5,0,0);

		/* Closes a file */
		dos_fclose( fp );

		/* Makes a sound */
		bi_canmelody();/* Stopping the sound */
		bi_buzzinit( Melody[0], Melody[1] );
		bi_melody( &Melody[2] );

	}

	cls(4);

	/* Writes a file */
	/* Sets a file name */
	strcpy(filename,"New.SND");

	if( CheckVol() ){/* Pre-checks the voltage */
		dispVOLerr();
		dos_exit(0);
	}
	if (dos_freespace(len)) {/* Checks the memory over */
		dispMEMORYerr();
		dos_exit(0);
	}

	/* Creates a new file. If it already exists, exits with an error. */
	if ( (fp = dos_fcrnew( filename )) <0 ) {
		gv_kput(0,20,"New.SND Create NG",5,0,0);
	}
	else {
		/* Writes a file */
		if ( (ret = dos_fwrite(fp,(char*)&Melody,len)) <0 ) {
			gv_kput(0,20,"New.SND Write NG",5,0,0);

			/* Closes the file */
			dos_fclose( fp );

			/* Flushes the flush memory */
			bi_vwrflush();

			bi_canmelody();/* Stops the sound */
			dos_exit(0);
		}

		/* Confirms file writing   */
		if (ret==len)
			gv_kput(10,33,"finishing writing",5,0,0);
		else
			gv_kput(10,33,"full memory",5,0,0);

		/* Closes the file */
		gv_kput(10,46,"Closing",5,0,0);
		dos_fclose( fp );

		/* Flushes the flush memory */
		gv_kput(10,46,"Flushing",5,0,0);
		bi_vwrflush();
	}

	gv_kput(0,46,"Exits with any key",5,0,0);

	bi_clrbtn();
	bi_getbtn();
	bi_getbtn();

	bi_canmelody();/* Stops the sound */
	bi_clrbtn();
    cls(4);
}
