/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		Welcome to onHand/Ruputer Park									*/
/*		Hello,World        												*/
/*======================================================================*/

#include"wbios.h"	/* bios */
#include"lcdbios.h"	/* LCD drawing */
#include"rupsys.h"	/* rupsys */

int main(void)
{
	int Key=0;

    screen(1);
/***********************************************************
		 This is the onHand/Ruputer display mode settings.
		 In general, 1=GVRAM (320x240).
		 Actual LCD display area is 102x64.
		 Set the left upper corner to x=0, y=0.
***********************************************************/

	cls(4);
/***********************************************************
		 Clear all range of GVRAM display.
		 In general, 4=GVRAM mode.
***********************************************************/

	gv_kput(10,20,"Hello,World!!",0,0,0);
/***********************************************************
		 Display the strings to any GVRAM coordinate.
		 
		 Format
		  gv_kput(x,y,str,size,space,logic)

		  int   x     Display start point of GVRAM coordinate x(from the left margin)
		  int   y     Display start point of GVRAM coordinate y(from the upper margin)
		  char *str   Display strings
		  int   size  Character size 12dot=0,10dot=1,8dot=2,....
		  int   space Character interval space (usually 0)
		  int   logic Usually 0. XOR and INVERTE can be used.
***********************************************************/

	if (pSystemCtl->EventManager->event&EVENT_DBLCLICK) { Keyin(0,-1);}
/***********************************************************
		 if you start this program by right cursor double click,clear the key buffer.
		 Refer to <rupsysLibManu(c).txt> Keyin()
************************************************************/

    while( Key==0 ){
	    Key=bi_getbtn();
/***********************************************************
			bi_getbtn()
			 Return the state of key.
			 This function is not returned until the key event occurs (press down or press up).

			 Format
			  int bi_getbtn()

			  Return value
			  		 The key state when the key event occurs (press down or press up).
			         Each key is allocated by 1 bit from all 8 bit.
			         It is defined in rupsys.h.  Refer to this.
									(In this case, C:\onHand_SDK\RupSDK\Inc\rupsys.h)

						Bkey_D  --- The value of Menu key was defined in rupsys.h.
						Bkey_up --- The value of up key was defined in rupsys.h
						Bkey_dw --- The value of down key was defined in rupsys.h
						Bkey_lf --- The value of left key was defined in rupsys.h
						Bkey_rg --- The value of right key was defined in rupsys.h

					 onHand(MC120) runs at 3.68MHz,returns usually high at 0x1000(Bkey_CK).
					 And Ruputer(MP110,MP120,MP140) runs at 1.84MHz,returns usually low.
***********************************************************/

		bi_clrbtn();
/***********************************************************
			bi_clrbtn();
			 Clear the key buffer.
***********************************************************/

    }

    cls(4);
}

