/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		onHand/Ruputer Sample Program 									*/
/*		<<onHand/RuputerAPI>>     										*/
/*======================================================================*/

#include "psdos.h"
#include "lcdbios.h"
#include "wbios.h"
#include "rupsys.h"
#include "font.h"
#include "softkey.h"

/* button status define	*/
#define Key_file		0x0001		/*	swA(K0) key interruption */
#define Key_enter		0x0008		/*	swB(K3) key interruption */
#define Key_el			0x0004		/*	swC(K2)key interruption  */
#define Key_menu		0x0002		/*	swD(K1)key interruption  */
#define Key_left		0x0010		/*	swE(K4)key interruption  */
#define Key_up			0x0020		/*	swF(K5)key interruption  */
#define Key_right		0x0040		/*	swG(K6)key interruption  */
#define Key_down		0x0080		/*	swH(K7)key interruption  */

int com_getArg(void);
int com_Keyin(void);
int com_softkey(void);
int com_dispMess(void);
int com_dispMessBar(void);
int com_dispYN(void);
int com_dispYNLarge(void);
int com_dispCancelYN(void);
int com_dispWaiting(void);
int com_dispVOLerr(void);
int com_dispMEMORYerr(void);
int com_dispTitle(void);
int com_dispTitleMore(void);
int com_sendTime(void);
int com_recvTime(void);
int com_sendFile(void);
int com_recvFile(void);
int com_TIMERStart(void);
int com_dispTime(void);
int com_dos_freespace(void);
int com_dos_freesect(void);
int com_CheckVol(void);	

static const RECT CLRLCD={0,0,101,63};
static MENU menuLIST[]={
	{ com_getArg,		"getArg            ",0,0},
	{ com_Keyin,		"Keyin             ",0,0},
	{ com_softkey,		"softkey           ",0,0},
	{ com_dispMess,		"dispMess          ",0,0},
	{ com_dispMessBar,	"dispMessBar       ",0,0},
	{ com_dispYN,		"dispYN            ",0,0},
	{ com_dispYNLarge,	"dispYNLarge       ",0,0},
	{ com_dispCancelYN,	"dispCancelYN      ",0,0},
	{ com_dispWaiting,	"dispWaiting       ",0,0},
	{ com_dispVOLerr,	"dispVOLerr        ",0,0},
	{ com_dispMEMORYerr,"dispMEMORYerr     ",0,0},
	{ com_dispTitle,	"dispTitle         ",0,0},
	{ com_dispTitleMore,"dispTitleMore     ",0,0},
	{ adjTime,			"adjTime           ",0,0},
	{ com_sendTime,		"sendTime          ",0,0},
	{ com_recvTime,		"recvTime          ",0,0},
	{ com_sendFile,		"sendFile          ",0,0},
	{ com_recvFile,		"recvFile          ",0,0},
	{ com_TIMERStart,	"TIMERStart,Stop   ",0,0},
	{ com_dispTime,		"dispTime          ",0,0},
	{ com_dos_freespace,"dos_freespace     ",0,0},
	{ com_dos_freesect,	"dos_freesect      ",0,0},
	{ com_CheckVol,		"CheckVol          ",0,0},
};

/*-----------------------------------------------------------*/
/*	 getArg:Obtain a name of a file to start  				 */
/*-----------------------------------------------------------*/
int com_getArg(void)
{
	KANJI_PUT Fname = {{0,0},0,5,0,0};

	Fname.str = getArg();
	pv_clear((RECT *)&CLRLCD);		/* Clear screen 		             */
	pv_kput((KANJI_PUT *)&Fname);	/* Display a name of a file to start */
	while(1){
		Keyin(0,-1);
		return 0;
	}
}
/*------------------------------------------------------------*/
/*	 Keyin:Obtain button status	  		    				  */
/*------------------------------------------------------------*/
int com_Keyin(void)
{
	KANJI_PUT Mess[] = {
		{{0, 0},"Waiting for a key",5,0,0},
		{{0,13},"Exit with Any key",5,0,0}
	};
	int bt;
	int ret;

	while(1){
		/* A screen is redrawn when you exit from EventExec. */
		pv_clear((RECT *)&CLRLCD);		/* Clear screen.		*/
		pv_kput((KANJI_PUT *)&Mess[0]);
		pv_kput((KANJI_PUT *)&Mess[1]);
		bt = Keyin(0,-1);
		ret = EventCall(bt);
		if( ret == -1 ){
				/* Request for end of application. */
			dos_exit(0);
		}
		else if( ret == 1 ){
			ret = EventExec();
			if (ret == -1){
				/* Request for end of application. */
				dos_exit(0);
			}
		}
		else return 0; /* You can exit when a key is entered.*/
	}
}
/*-----------------------------------------------------------*/
/*	 softkey:Soft keys		      				 			 */
/*-----------------------------------------------------------*/
int com_softkey(void)
{
	static char str[17];
	KANJI_PUT Mess0 = {{0, 0},"Start with Enter.",5,0,0};
	KANJI_PUT Mess1 = {{0,13},"  Exit with Menu.",5,0,0};
	KANJI_PUT Inputstr = {{0,32},str,5,0,0};
	STRSTS ctrl = { picNAME	,ALPHA_U_TYPE,	2,2,0,0,0,16};
	int bt;

	pv_clear((RECT *)&CLRLCD);		/* Clear screen. 		 */
	while(1){
		pv_kput((KANJI_PUT *)&Mess0);
		pv_kput((KANJI_PUT *)&Mess1);

		bt = bi_getbtn();
		if( bt&Key_menu ){
			return 0;
		}
		else if( bt&Key_enter ){
			if( softkey( &ctrl,Inputstr.str,0,0 )==-1 )
				/* If a returned value is -1, application ends. */
				dos_exit(0);
			pv_clear((RECT *)&CLRLCD);		/* Clear screen. 		 */
			pv_kput((KANJI_PUT *)&Inputstr);
		}
	}
}
/*-----------------------------------------------------------*/
/*	 dispMess:Display messages	  		     	 			 */
/*-----------------------------------------------------------*/
int com_dispMess(void)
{
	char *Mess[] = {
		" Messages ",
		" up to three lines.",
		" Can display\?"
	};
	pv_clear((RECT *)&CLRLCD);		/* Clear screen. 		*/
	dispMess( (char **)Mess, 3 );
	return 0;
}
/*-----------------------------------------------------------*/
/*	 dispMessBar:Display full-size 3 letters and bar.		 */
/*-----------------------------------------------------------*/
int com_dispMessBar(void)
{
	KANJI_PUT Mess = {{0,0},"Exit with Any key",5,0,0};

	pv_clear((RECT *)&CLRLCD);		/* Clear screen 		*/
	pv_kput((KANJI_PUT *)&Mess);
	dispMessBar("Operating");
	Keyin(0,-1);
	/* Whenever you call dispMessBar function, you should finish with */
	endMessBar();
	return 0;
}

/*-----------------------------------------------------------*/
/*	 dispYN:Yes/No confirmation display(standard)			 */
/*-----------------------------------------------------------*/
int com_dispYN(void)
{
	int ret;

	while(1){
		pv_clear((RECT *)&CLRLCD);		/* Clear screen. 		 */
		if( (ret=dispYN("Select button","  Are you sure?",0))==-1 )
			/* If -1 is returned, application ends. 	   */
			dos_exit(0);
		else if( !ret ) return 0;/* if 0 is returned, Yes  */
	}
}
/*------------------------------------------------------------*/
/*    dispYNLarge:Yes/No confirmation display(Large frame)	  */
/*------------------------------------------------------------*/
int com_dispYNLarge(void)
{
	int ret;

	while(1){
		pv_clear((RECT *)&CLRLCD);		/* Clear screen. 		*/
		if( (ret=dispYNLarge("Select button","  Are you sure?",0))==-1 )
			/* If -1 is returned, application ends.  */
			dos_exit(0);
		else if( !ret ) return 0;/* if 0 is returned,Yes */
	}
}
/*-----------------------------------------------------------*/
/*	 dispCancelYN:Cancel of setting Yes/No display			 */
/*-----------------------------------------------------------*/
int com_dispCancelYN(void)
{
	int ret;

	while(1){
		pv_clear((RECT *)&CLRLCD);		/* Clear screen. 		*/
		if( (ret=dispCancelYN())==-1 )
			/* If -1 is returned, application ends. */
			dos_exit(0);
		else if( !ret ) return 0;/* If 0 is returned, Yes */
	}
}
/*-----------------------------------------------------------*/
/*	 dispWaiting:Waiting WaitAnimation display				 */
/*-----------------------------------------------------------*/
int com_dispWaiting(void)
{
	KANJI_PUT Mess = {{0,0},"Exit with Any key.",5,0,0};

	pv_clear((RECT *)&CLRLCD);		/* Clear screen. 		*/
	pv_kput((KANJI_PUT *)&Mess);
	dispWaiting();
	/* Two bi_getbtn are necessary since two interruptions are made at the rising and falling edges of key.*/
	bi_getbtn();
	bi_getbtn();
	/* Whenever you call dispWaiting function, you should finish with endWaiting.*/
	/*  Stop at the top of Keyin function. */
	endWaiting();
	return 0;
}
/*-----------------------------------------------------------*/
/*	 dispVOLerr:Abnormal voltage alarm display				 */
/*-----------------------------------------------------------*/
int com_dispVOLerr(void)
{
	pv_clear((RECT *)&CLRLCD);		/* Clear screen. 		*/
	dispVOLerr();
	/* Usually, after this, you should execute dos_exit(0). */
	bi_getbtn();
	return 0;
}
/*-----------------------------------------------------------*/
/*	 dispMEMORYerr:Abnormal memory alarm display			 */
/*-----------------------------------------------------------*/
int com_dispMEMORYerr(void)
{
	pv_clear((RECT *)&CLRLCD);		/* Clear screen. 		*/
	dispMEMORYerr();
	/* Usually, after this, you should execute dos_exit(0). */
	bi_getbtn();
	return 0;
}
/*-----------------------------------------------------------*/
/*	 dispTitle:Set screen title display						 */
/*-----------------------------------------------------------*/
int com_dispTitle(void)
{
	KANJI_PUT Mess = {{0,26},"Display a title",5,0,0};
	/* Insert \ to cope with a situation when due to failure of a compiler, 2byte containing 0x5c code cannot be handled properly. */

	pv_clear((RECT *)&CLRLCD);		/* Clear screen. 		*/
	dispTitle("Set onHand");
	pv_kput((KANJI_PUT *)&Mess);
	Keyin(0,-1);
	return 0;
}
/*------------------------------------------------------------------------------*/
/*    dispTitleMore:Set screen title display(When UP/DOWN arrows are assigned)  */
/*------------------------------------------------------------------------------*/
int com_dispTitleMore(void)
{
	int csr,listno;
	int bt;
	int listmax;
	int i,j;
	int ret;
	char buf[1024];
	GVRAM_GET SCROLLget[]={
		{{0,13,101,50},0},
		{{0,26,101,63},0}
	};
	GVRAM_PUT SCROLLput[]={
		{{0,26},0,0},
		{{0,13},0,0}
	};
	KANJI_PUT Listkput = {{1,0},0,5,0,0};
	const GVRAM_PUT UEYAput={{83,3},(char *)mmpUEYA,0};
	const GVRAM_PUT SITAYAput={{92,3},(char *)mmpSITAYA,0};
	const SQUARE_DRAW UEYAsqu={{83,3,91,8},0x0004,0x55aa55aa};
	const SQUARE_DRAW SITAYAsqu={{92,3,100,8},0x0004,0xaa55aa55};
	const RECT REV4[]={
			{0,12,101,25},
			{0,25,101,38},
			{0,38,101,51},
			{0,51,101,63}
	};
	char *List[] = {
		"First  column",
		"Second column",
		"Third  column",
		"Fourth column",
		"Fifth  column",
		"Sixth  column"
	};

	csr = 0;
	listno = 0;
	pv_clear((RECT *)&CLRLCD);		/* Clear screen. 		*/
	listmax = sizeof(List)/sizeof(char *);
	while(1){
		lcdfreeze(1);
		dispTitleMore("List Display?");		/* Display a title 		*/
		if(listmax-csr>4)
					pv_put((GVRAM_PUT *)&SITAYAput);/*	indication of down key	*/
		if(csr)		pv_put((GVRAM_PUT *)&UEYAput);	/*	Display UP arrow     	*/
		for( i=0,j=listno;i<4;i++,j++ ){	/*	Display a menu item	*/
			Listkput.pos.y = 13+i*13;
			Listkput.str = List[j];
			pv_kput((KANJI_PUT *)&Listkput);
		}
		pv_reverse((RECT *)&REV4[csr]);	/* reverse		*/
		lcdfreeze(0);
		while(1){
			bt = Keyin((Key_up|Key_down),-1);
			ret = EventCall(bt);
			if( ret == -1 ){
				/* Request for end of application */
				dos_exit(0);
			}
			else if( ret == 1 ){
				ret = EventExec();
				if (ret == -1){
					/* request for end of application */
					dos_exit(0);
				}
			}
			if( bt==Key_menu ){
				return 0;
			}
			else if( bt==Key_up && listno ){
				pv_reverse((RECT *)&REV4[csr]);		/* reverse release */
				listno --;
				if(csr!=0)	csr--;
				else{/*	scroll screen */
					if(!listno)	pv_square((SQUARE_DRAW *)&UEYAsqu);	/* Erase UP arrow     */
					if(listno+3<listmax-1)	
								pv_put((GVRAM_PUT *)&SITAYAput);	/* Display DOWN arrow */
					SCROLLget[0].buf=buf;
					pv_get((GVRAM_GET *)&SCROLLget[0]);
					Listkput.pos.y = 13;
					Listkput.str = List[listno];
					pv_kput((KANJI_PUT *)&Listkput);
					SCROLLput[0].buf=buf;
					pv_put((GVRAM_PUT *)&SCROLLput[0]);
				}
				pv_reverse((RECT *)&REV4[csr]);		/* reverse */
			}
			else if( bt==Key_down && listno!=listmax-1 ){
				pv_reverse((RECT *)&REV4[csr]);		/* reverse release */
				listno ++;
				if(csr<3)	csr++;
				else{/*	Scroll screens	*/
					if(listno==listmax-1)	pv_square((SQUARE_DRAW *)&SITAYAsqu);	/* Erase DOWN arrow */
					if(listno==4)			pv_put((GVRAM_PUT *)&UEYAput);			/* Display UP arrow */
					SCROLLget[1].buf=buf;
					pv_get((GVRAM_GET *)&SCROLLget[1]);
					Listkput.pos.y = 52;
					Listkput.str = List[listno];
					pv_kput((KANJI_PUT *)&Listkput);
					SCROLLput[1].buf=buf;
					pv_put((GVRAM_PUT *)&SCROLLput[1]);
				}
				pv_reverse((RECT *)&REV4[csr]);		/* reverse */
			}
		}
	}
}
/*-----------------------------------------------------------*/
/*	 adjTime:Modify time									 */
/*-----------------------------------------------------------*/
/* You can call this from a menu. */

/*-----------------------------------------------------------*/
/*	 Time data communications	    						 */
/*-----------------------------------------------------------*/
/* 
	errcode returned value
	-1	 Unable to use a communications port.
	-2	 Error during communications
	-3	 Cancel through manipulation of buttons.
	-4	 Detect that backside of battery lid is open.
	-5	 Timeout
	-6	 Cancelled by a destination party.
*/
#define	BLDSTOP			-4	/* Detected that backside of battery lid is open. */
#define	TIMEOUTerr		-5	/* Timeout 										  */
static const char *eMess0[] =	{"      No response"};
static const char *eMess1[] =	{"   Transmission","            aborted."};
static const char *eMess2[] =	{"    Reception  ","            aborted."};
/*-----------------------------------------------------------*/
/*	 sendTime: Time data communications						 */
/*-----------------------------------------------------------*/
int com_sendTime(void)
{
	int ret;
	int rst;
	KANJI_PUT Mess[] = {
		{{ 13, 15},"Ready to transmit",5,0,0},
		{{ 28,  0},"Time data",5,0,0}
	};

	rst  =  dispYN(" Do you send","         time data?",-1);
	if( rst == -1 )	dos_exit(0);
	if( !rst ){
		pv_clear((RECT *)&CLRLCD);
		pv_kput((KANJI_PUT *)&Mess[0]);
		pv_kput((KANJI_PUT *)&Mess[1]);
		ret = sendTime();
		if( !ret ){
			dispMessBar("Completed");
			endMessBar();
			return 0;
		}
		else if(ret==BLDSTOP)	dos_exit(0);
		else if(ret==TIMEOUTerr){
			/* transmission timeout */
			if ((dispMess((char **)eMess0,1)) == -1) dos_exit(0);
			return 0;
		}
		else{/* transmission suspended */
			if ((dispMess((char **)eMess1,2)) == -1) dos_exit(0);
			return 0;
		}
	}
	return 0;
}
/*-----------------------------------------------------------*/
/*	 recvTime:Time data reception							 */
/*-----------------------------------------------------------*/
int com_recvTime(void)
{
	int ret;
	int rst;
	WatchDT getRTCTime;
	KANJI_PUT Mess[] = {
		{{ 13, 15},"Ready to receive",5,0,0},
		{{ 28,  0},"Time data",5,0,0}
	};

	rst  =  dispYN(" Do you receive","         time data?",-1);
	if( rst == -1 )	dos_exit(0);
	if( !rst ){
		pv_clear((RECT *)&CLRLCD);
		pv_kput((KANJI_PUT *)&Mess[0]);
		pv_kput((KANJI_PUT *)&Mess[1]);
		ret=recvTime(&getRTCTime);
		if( !ret ){
			*pSystemCtl->CPUram=getRTCTime;
			/* Write received data on RAM */
			dispMessBar("Completed");
			/* Necessary processing after time is changed */
			setRTC();				/* RTC set 	 	*/
			setRTCquit();
			setPowerStandby();
			CheckExecute();			/* Start CHECK.EXF	 */
			/* Need up to here */
			return 0;
		}
		else if(ret==BLDSTOP)	dos_exit(0);
		else if(ret==TIMEOUTerr){
			/* Reception timeout */
			if ((dispMess((char **)eMess0,1)) == -1) dos_exit(0);
			return 0;
		}
		else{/* Reception suspended  */
			if ((dispMess((char **)eMess2,2)) == -1) dos_exit(0);
			return 0;
		}
	}
	return 0;
}
/*-----------------------------------------------------------*/
/*	File communications										 */
/*-----------------------------------------------------------*/
/*
	errcode Returned values
		 0	Normal end.
		-1	Cancelled by a destination party.
		-2	Communications timeout (preparation for transmission).
		-3	Illegal code.
		-4	(Suspended by) break (button).
		-5	No response from a destination.
		-6	File write error.
		-7	Unable to use a communications port.
		-8	Detected that backside of battery lid is open.
		-9	Detected low battery.
		-11	Transmission timeout (in transmission)
*/
static const char *eMess00[] =	{"      No response"};
static const char *eMess01[] =	{"   Transmission","            aborted."};
static const char *eMess02[] =	{"    Reception  ","            aborted."};
static const char *eMess03[] =	{"   Transmission","          completed."};
static const char *eMess04[] =	{"    Reception  ","          completed."};
static char *comtest = "test";
/*-----------------------------------------------------------*/
/*	 sendFile:File transmission								 */
/*-----------------------------------------------------------*/
int com_sendFile(void)
{
	int fp,ret,err;

	ret  =  dispYN(" Do you send","         test data?",-1);
	if( ret == -1 )	dos_exit(0);
	if( !ret ){
		if( dos_freespace(sizeof(comtest)) ){
			dispMEMORYerr();
			dos_exit(0);
		}
		dispMessBar("Wait....");
		if( (fp=dos_fcreate("B:\\SYSTEM\\SEND.TMP") )==-1 ){
			/* err */
			endMessBar();
			return 0;
		}
		else if( fp==-2 ){
			/* abnormal voltage */
			endMessBar();
			dispVOLerr();
			dos_exit(0);
		}
		dos_fwrite( fp,comtest,sizeof(comtest) );
		dos_fclose( fp );
		bi_vwrflush();
		fp = dos_fopen( "B:\\SYSTEM\\SEND.TMP",0 );
		endMessBar();
		err = sendFile( "Test data",fp,sizeof(comtest) );
		dos_fclose( fp );
		dos_fdelete( "B:\\SYSTEM\\SEND.TMP" );
		if( err ){
			switch( err ){
				case	-5:
						if( dispMess( (char **)eMess00, 1 )==-1 )	dos_exit(0);
						break;
				case	-8:
				case	-9:
						dispVOLerr();
						dos_exit(0);
				default:/* transmission suspended */
						if( dispMess( (char **)eMess01, 2 )==-1 ) dos_exit(0);
			}
			return 0;
		}
		/* transmission complete */
		if( dispMess( (char **)eMess03, 2 )==-1 )	dos_exit(0);
		return 0;
	}
	return 0;
}
/*-----------------------------------------------------------*/
/*	 recvFile:File reception								 */
/*-----------------------------------------------------------*/
int com_recvFile(void)
{
	int fp,ret,err;
	char mess[5];

	ret  =  dispYN(" Do you receive","         test data?",-1);
	if( ret == -1 )	dos_exit(0);
	if( !ret ){
		/* Check empty space */
		if( dos_freespace(sizeof(comtest)) ){
			dispMEMORYerr();
			dos_exit(0);
		}
		if( (fp=dos_fcreate("B:\\SYSTEM\\SEND.TMP") )==-1 ){
			/* err */
			return 0;
		}
		else if( fp==-2 ){
			/*  abnormal voltage */
			dispVOLerr();
			dos_exit(0);
		}
		pv_clear((RECT *)&CLRLCD);
		err = recvFile( "Test data",fp );
		dos_fclose( fp );
		bi_vwrflush();
		if( err ){
			dos_fdelete( "B:\\SYSTEM\\SEND.TMP" );
			switch( err ){
				case	-2:
						if( dispMess( (char **)eMess00, 1 )==-1 )	dos_exit(0);
						break;
				case	-9:
						dispVOLerr();
				case	-8:
						dos_exit(0);
				case	-10:
						dispMEMORYerr();
						dos_exit(0);
				default:/* reception suspended */
						if( dispMess( (char **)eMess02, 2 )==-1 ) dos_exit(0);
			}
			return 0;
		}
		dispMessBar("Saving!");
		fp = dos_fopen( "B:\\SYSTEM\\SEND.TMP",0 );
		dos_fread( fp,mess,sizeof(comtest) );
		dos_fclose( fp );
		dos_fdelete( "B:\\SYSTEM\\SEND.TMP" );
		endMessBar();
		if( dispMess( (char **)eMess04, 2 )==-1 )	dos_exit(0);
		return 0;
	}
	return 0;
}
/*-----------------------------------------------------------*/
/*	 TIMERStart,TIMERStop:Timer control						 */
/*-----------------------------------------------------------*/
#define RESET			0		/*	RESET		*/
#define STOP			1		/*	STOP		*/
#define RUN				2		/*	RUN			*/
static Tdata TMRdt;
/*	 Convert a numeric value into an ASCII code (use scosii code.)  */
static void INTtoASC(char *p,int val,int keta,int sup)
{
	int i;

	for(p[keta]='\0',i=keta-1;0<=i;i--){
		p[i]=val%10+0x30;
		if(i!=keta-1 && sup==1 && p[i]=='0')	p[i]='?';
		val /= 10;
	}
	return;
}
/*	 Timer display	 */
static void dispTimer(void)
{
	char buf[3];
	KANJI_PUT TMRkput[]={
		{{20,19},0,0,0,0},		/*	hour	*/
		{{26,19},":",0,0,0},	/*	 :	    */
		{{32,19},0,0,0,0},		/*	minute	*/
		{{46,19},0,0,0,0}		/*	second	*/
	};
	/* read a value of RAM counter. */
	TMRdt = *pSystemCtl->TIMERdata;
	/* Timer display processing */
	INTtoASC(buf,TMRdt.hour,1,0);
	TMRkput[0].str=buf;
	pv_kput((KANJI_PUT *)&TMRkput[0]);	/* hour */
	pv_kput((KANJI_PUT *)&TMRkput[1]);	/*  :  */
	INTtoASC(buf,TMRdt.min,2,0);
	TMRkput[2].str=buf;
	pv_kput((KANJI_PUT *)&TMRkput[2]);	/* hour */
	INTtoASC(buf,TMRdt.sec,2,0);
	TMRkput[3].str=buf;
	pv_kput((KANJI_PUT *)&TMRkput[3]);	/* hour */
}
int com_TIMERStart(void)
{
	int bt,ret;
	KANJI_PUT TimeupMess = {{0,0},"TimeUp",5,0,0};
	int Timeup = 0;

	/* Set an initial timer counter to 10 seconds. */
	TMRdt.hour=0;
	TMRdt.min=0;
	TMRdt.sec=10;
	TMRdt.co=0;
	*pSystemCtl->TimerStat=RESET;	/* Timer reset status 	         */
	*pSystemCtl->TIMERdata=TMRdt;	/* Initialize timer data of RAM. */
	pv_clear((RECT *)&CLRLCD);
	lcdfreeze(1);
	dispTimer();
	lcdfreeze(0);
	while(1){
		bt = Keyin(0,-1);
		if(bt & EVENT_REQ){/* Obtain timeup information.  */
			if ((pSystemCtl->EventManager->eventReq & EVENT_TMDWN1) &&
			    (pSystemCtl->EventManager->event    & EVENT_TMDWN1)) {	/* timeup */
				pv_kput((KANJI_PUT *)&TimeupMess);/*display timeup message */
				/* release every second processing whereby you can exit from keyin */
				pSystemCtl->EventManager->eventReq &=~ EVENT_TMDWN2;
				dispTimer();
				Timeup = 1;
			}
		}
		ret = EventCall(bt);
		/*	recover timeup information */
		if (ret == -1) {
			/* request for end of application */
			if(*pSystemCtl->TimerStat==RUN){
				/* release processing every second whereby you can exit from Keyin. */
				pSystemCtl->EventManager->eventReq &=~ EVENT_TMDWN2;
			}
			dos_exit(0);
		}
		else if (ret == 1) {
			/* Stop once as no interruption occurs due to Time check. */
			if(*pSystemCtl->TimerStat==RUN){
				/* release processing every second whereby you can exit from Keyin. */
				pSystemCtl->EventManager->eventReq &=~ EVENT_TMDWN2;
			}
			ret = EventExec();
			if (ret == -1) {
				/*request for end of application */
				dos_exit(1);
			}
			pv_clear((RECT *)&CLRLCD);
			dispTimer();
			if( *pSystemCtl->TimerStat == RUN ){/* recover and interrupt while timer is RUNning */
				/* release processing every second whereby you can exit from Keyin. */
				pSystemCtl->EventManager->eventReq |= EVENT_TMDWN2;
			}
		}
		if(bt & EVENT_REQ){
			/* release processing every second whereby you can exit from Keyin. */
			if ((pSystemCtl->EventManager->eventReq & EVENT_TMDWN2) &&
			    (pSystemCtl->EventManager->event    & EVENT_TMDWN2)) {
			    pSystemCtl->EventManager->event &= ~EVENT_TMDWN2;
				dispTimer();
			}
		}
		if(bt==Key_enter){
			if( Timeup ) return 0;
			if(*pSystemCtl->TimerStat==STOP ||
				*pSystemCtl->TimerStat==RESET){
				TIMERStart();
				/* timer status RUN */
				*pSystemCtl->TimerStat=RUN;
				/* set timer interruption */
				pSystemCtl->EventManager->eventReq |= (EVENT_TMDWN0|EVENT_TMDWN1|EVENT_TMDWN2);
			}
			else if(*pSystemCtl->TimerStat==RUN){
				TIMERStop();
				/* timer status STOP */
				*pSystemCtl->TimerStat=STOP;
				/* release processing every second whereby you can exit from Keyin. */
				pSystemCtl->EventManager->eventReq &=~ EVENT_TMDWN2;
				dispTimer();
			}
		}
		else if(bt==Key_menu){
			if(*pSystemCtl->TimerStat==STOP){
				*pSystemCtl->TimerStat=RESET;
				TMRdt.hour=0;
				TMRdt.min=0;
				TMRdt.sec=10;
				TMRdt.co=0;
				*pSystemCtl->TIMERdata=TMRdt;	/* Initialize timer data of RAM. */
				dispTimer();
			}
			else{
				/* release processing every second whereby you can exit from Keyin. */
				TIMERStop();
				pSystemCtl->EventManager->eventReq &=~ EVENT_TMDWN2;
				return 0;
			}
		}
	}
}
/*-----------------------------------------------------------*/
/*	 dispNowWeek,dispNowDate,dispNowAmPm					 */
/*	 dispNowTime,dispNowSec:Timer display					 */
/*-----------------------------------------------------------*/
int com_dispTime(void)
{
	WatchDT Time;
	int chgHour;
	KANJI_PUT Mess = {{20,55},"this is current time",7,0,0};

	pv_clear((RECT *)&CLRLCD);		/* Clear screen		 */
	pv_kput((KANJI_PUT *)&Mess);
	Time = *pSystemCtl->CPUram;							/* Read time data of RAM. */
	chgHour = dispNowTime(  4, 31, 42, 24, 60, 3, 1 );	/* hour and minute */
	dispNowSec( 74, 31, 48, 2, 1 );						/* second          */
	if( chgHour ){
		/* Hereafter, to be displayed only when a digit is changed. */
		dispNowAmPm( 5, 53, 16, 1 );					/* AM/PM           */
		dispNowDate( 0,  4, 32, 1, 0 );					/* Year,month,day  */
		dispNowWeek(84,  6,  0, 0, 0 );					/* day of the week */
	}
	Keyin(0,-1);
	return 0;
}
/*-----------------------------------------------------------*/
/*	 dos_freespace:Empty space check(in terms of bytes)		 */
/*-----------------------------------------------------------*/
int com_dos_freespace(void)
{
	KANJI_PUT Mess[] = {
		{{1,0},"Remaining space is",5,0,0},
		{{1,13},"10kbyte or more",5,0,0},
		{{1,13},"10kbyte or less",5,0,0},
	};

	pv_clear((RECT *)&CLRLCD);		/* Clear screen. 		*/
	pv_kput((KANJI_PUT *)&Mess[0]);
	if( !dos_freespace(10000) )
			pv_kput((KANJI_PUT *)&Mess[1]);
	else	pv_kput((KANJI_PUT *)&Mess[2]);
	Keyin(0,-1);
	return 0;
}
/*-----------------------------------------------------------*/
/*	 dos_freesect:Empty space check(in terms of sector) 	 */
/*-----------------------------------------------------------*/
int com_dos_freesect(void)
{
	KANJI_PUT Mess[] = {
		{{1,0},"Remaining space is",5,0,0},
		{{1,13},"100 sectors or more",5,0,0},
		{{1,13},"100 sectors or less",5,0,0},
	};

	pv_clear((RECT *)&CLRLCD);		/* Clear screen. 		*/
	pv_kput((KANJI_PUT *)&Mess[0]);
	if( !dos_freesect(100) )
			pv_kput((KANJI_PUT *)&Mess[1]);
	else	pv_kput((KANJI_PUT *)&Mess[2]);
	Keyin(0,-1);
	return 0;
}
/*-----------------------------------------------------------*/
/*	 CheckVol:Heavy load voltage check						 */
/*-----------------------------------------------------------*/
int com_CheckVol(void)
{
	KANJI_PUT Mess[] = {
		{{10,0},"Normal voltage",5,0,0},
		{{10,0},"Abnormal voltage",5,0,0},
	};

	pv_clear((RECT *)&CLRLCD);		/* Clear screen 		*/
	if( !CheckVol() )
			pv_kput((KANJI_PUT *)&Mess[0]);
	else	pv_kput((KANJI_PUT *)&Mess[1]);
	Keyin(0,-1);
	return 0;
}
/*-----------------------------------------------------------*/
/*	 Main					      	  						 */
/*-----------------------------------------------------------*/
int main(void)
{
	screen(1);						/* Graphic mode 			*/
	gv_place(0,0);					/* XY coordinates  X:0, Y:0 */
	endWaiting();					/* Stop startup animation.  */
	if( aprMenu("onHandAPI",menuLIST,
				(int)sizeof(menuLIST)/sizeof(MENU)) == -2 )
		dos_exit(0);	/* end of application */
	return 0;
}
