/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																	    */
/*		onHand/Ruputer Sample Program  									*/
/*		<<Analog Clock>>          										*/
/*======================================================================*/

#include  "math.h"
#include  "psdos.h"
#include  "lcdbios.h"
#include  "wbios.h"
#include  "rupsys.h"
#include  "font.h"

/*  button  status  define	*/
#define  Key_file		0x0001		/*	swA(K0)  key  interruption	*/
#define  Key_enter		0x0008		/*	swB(K3)key  interruption	*/
#define  Key_el			0x0004		/*	swC(K2)key  interruption	*/
#define  Key_menu		0x0002		/*	swD(K1)key  interruption	*/
#define  Key_left		0x0010		/*	swE(K4)key  interruption	*/
#define  Key_up			0x0020		/*	swF(K5)key  interruption	*/
#define  Key_right		0x0040		/*	swG(K6)key  interruption	*/
#define  Key_down		0x0080		/*	swH(K7)key  interruption	*/
/*  communications  error  code  */
#define	BLDSTOP			-4	/*  Detect  that  backside  of  battery  lid  is  open.	*/
#define	TIMEOUTerr		-5	/*  timeout												*/

int  timecom(void);
int  send(void);
int  receive(void);

static  WatchDT  AQTime;
static  const  RECT  CLRLCD={0,0,101,63};
static  MENU  menuLIST[]={
	{  adjTime,		 "Time/Date"       ,1,0},
	{  timecom,		 "Ir Communication",1,0},
	{  setExitMenu,	 "Exit"            ,0,0}
};
static  MENU  com_menuLIST[]={
	{  send,		"Time transmission",1,0},
	{  receive,		"Time reception   ",1,0},
};
static  char  *eMess0[]  =  {"      No response"};
static  char  *eMess1[]  =  {"   Transmission","            aborted."};
static  char  *eMess2[]  =  {"    Reception  ","            aborted."};

/*-----------------------------------------------------------*/
/*	  Time data transmission			   					 */
/*-----------------------------------------------------------*/
int  send(void)
{
	int  ret;
	int  rst;
	KANJI_PUT  Mess[]  =  {
		{{ 13, 15},"Ready to transmit",5,0,0},
		{{ 28,  0},"Time data",5,0,0}
	};

	rst  =  dispYN(" Do you send","         time data?",-1);
	if(  rst  ==  -1  )	dos_exit(0);
	if(  !rst  ){
		pv_clear((RECT  *)&CLRLCD);
		pv_kput((KANJI_PUT  *)&Mess[0]);
		pv_kput((KANJI_PUT  *)&Mess[1]);
		ret  =  sendTime();
		if(  !ret  ){
			dispMessBar("Completed");
			endMessBar();
			return  -4;
		}
		else  if(ret==BLDSTOP)	dos_exit(0);
		else  if(ret==TIMEOUTerr){
			/*  transmission  timeout  */
			if  ((dispMess(eMess0,1))  ==  -1)  dos_exit(0);
			return  -4;
		}
		else{/*  transmission  suspended  */
			if  ((dispMess(eMess1,2))  ==  -1)  dos_exit(0);
			return  -4;
		}
	}
	return  0;
}
/*-----------------------------------------------------------*/
/*	  Time data reception			  						 */
/*-----------------------------------------------------------*/
int  receive(void)
{
	int  ret;
	int  rst;
	WatchDT  getRTCTime;
	KANJI_PUT  Mess[]  =  {
		{{ 13, 15},"Ready to receive",5,0,0},
		{{ 28,  0},"Time data",5,0,0}
	};

	rst  =  dispYN(" Do you receive","         time data?",-1);
	if(  rst  ==  -1  )	dos_exit(0);
	if(  !rst  ){
		pv_clear((RECT  *)&CLRLCD);
		pv_kput((KANJI_PUT  *)&Mess[0]);
		pv_kput((KANJI_PUT  *)&Mess[1]);
		ret=recvTime(&getRTCTime);
		if(  !ret  ){
			*pSystemCtl->CPUram=getRTCTime;
			dispMessBar("Completed");
			/* Processing necessary when time is changed subsequently */
			setRTC();				/* RTC set 		  */
			setRTCquit();
			setPowerStandby();
			CheckExecute();			/*  Start  CHECK.EXF	  */
			/*  need  up  to  here   */
			endMessBar();			/*  End  dispMessBar      */
			return  -4;
		}
		else  if(ret==BLDSTOP)	dos_exit(0);
		else  if(ret==TIMEOUTerr){
			/*  reception  timeout     */
			if  ((dispMess(eMess0,1))  ==  -1)  dos_exit(0);
			return  -4;
		}
		else{   /*  recedption  suspended  */
			if  ((dispMess(eMess2,2))  ==  -1)  dos_exit(0);
			return  -4;
		}
	}
	return  0;
}
/*-----------------------------------------------------------*/
/*	  Time data reception		            				 */
/*-----------------------------------------------------------*/
int  timecom(void)
{
	return  aprMenu("Ir Communication", com_menuLIST,
					(int)sizeof(com_menuLIST)/sizeof(MENU));
}
/*-----------------------------------------------------------*/
/*	  Clock display(interval of 1 second)	   				 */
/*-----------------------------------------------------------*/
void  dispAQ(int  All)
{
	const  double  DEG  =  3.1415/30.0;
	static  oldMin  =  -1;
	static  GVRAM_PUT  AQput  =  {{0,0},(char  *)mmpAQ3,0};
	static  LINE_DRAW  HourLine[5]={
		{{50,31},{0,0},0,0xff},
		{{51,31},{0,0},0,0xff},
		{{49,31},{0,0},0,0xff},
		{{50,32},{0,0},0,0xff},
		{{50,30},{0,0},0,0xff},
	};
	static  LINE_DRAW  MinLine[5]={
		{{50,31},{0,0},0,0xff},
		{{51,31},{0,0},0,0xff},
		{{49,31},{0,0},0,0xff},
		{{50,32},{0,0},0,0xff},
		{{50,30},{0,0},0,0xff},
	};
	static  LINE_DRAW  SecLine={{50,31},{0,0},1,0xff};
        int  RAD;
	int  x0,y0,x1,y1,x2,y2;
	int  i;

	AQTime  =  *pSystemCtl->CPUram;
	/*  read time data on RAM  				                        */
	/*  faster, saving more power and more memory than getRTC();	*/
	lcdfreeze(1);
	if(  AQTime.NOW_Min  !=  oldMin  ||  All  ){
		/*  minute hand and hour hand appear only when a digit of minute is rewritten. */
		oldMin  =  AQTime.NOW_Min;
		pv_put((GVRAM_PUT  *)&AQput);
		if(  AQTime.NOW_Hour>=12  )  AQTime.NOW_Hour=AQTime.NOW_Hour%12;
		RAD=AQTime.NOW_Hour*5+AQTime.NOW_Min/15;
		x0=50+(int)(21.0*sin((double)(RAD)*DEG));
		y0=31+(int)(-21.0*cos((double)(RAD)*DEG));
		x1=50+(int)(27.0*sin((double)(AQTime.NOW_Min)*DEG));
		y1=31+(int)(-27.0*cos((double)(AQTime.NOW_Min)*DEG));
		for(  i=0;  i<5;  i++  ){
			HourLine[i].ed.x  =  x0;
			HourLine[i].ed.y  =  y0;
			MinLine[i].ed.x  =  x1;
			MinLine[i].ed.y  =  y1;
			pv_line((LINE_DRAW  *)&HourLine[i]);
			pv_line((LINE_DRAW  *)&MinLine[i]);
		}
		SecLine.ed.x=50+(int)(30.0*sin((double)(AQTime.NOW_Sec)*DEG));
		SecLine.ed.y=31+(int)(-30.0*cos((double)(AQTime.NOW_Sec)*DEG));
		pv_line((LINE_DRAW  *)&SecLine);
	}
	else{
		/* second hand of every second appears. */
		pv_line((LINE_DRAW  *)&SecLine);
		SecLine.ed.x=50+(int)(30.0*sin((double)(AQTime.NOW_Sec)*DEG));
		SecLine.ed.y=31+(int)(-30.0*cos((double)(AQTime.NOW_Sec)*DEG));
		pv_line((LINE_DRAW  *)&SecLine);
	}
	lcdfreeze(0);
}
/*-----------------------------------------------------------*/
/*	Main					  								 */
/*-----------------------------------------------------------*/
int  main(void)
{
	int  menuEND  =  0;
	int  bt;
	int  ret;

	screen(1);						/*	Graphic mode				*/
	gv_place(0,0);					/*	XY coordinates X:0, Y:0		*/
	endWaiting();					/*	Stop startup animation.	    */
	while(1){
		lcdfreeze(1);
		pv_clear((RECT  *)&CLRLCD);	/*  Clear screen  */
		pSystemCtl->EventManager->eventReq  |=  EVENT_SEC;
								 	/*	Set so that you can exit from Keyin every second.  */
		dispAQ(1);				 	/*	Display all screens.*/
		lcdfreeze(0);

		while(1){
			bt  =  Keyin(  0,0  );
/*  v From here, event processing other than Keyin button */
			if(  bt  &  EVENT_REQ  ){
				/*  release processing every second whereby you can exit from Keyin. */
				if  ((pSystemCtl->EventManager->eventReq  &  EVENT_SEC)  &&  
				        (pSystemCtl->EventManager->event        &  EVENT_SEC)){
				        pSystemCtl->EventManager->event  &=  ~EVENT_SEC;
				/*	1Hz display and processing	*/
					dispAQ(0);
				}
			}
			ret  =  EventCall(bt);
			if(ret  ==  -1)  {
				/*  request for end of applicaiton */
				pSystemCtl->EventManager->eventReq  &=  ~EVENT_SEC;
				/*  release processing every second whereby you can exit from Keyin. */
				dos_exit(0);
			}
			else  if(  ret  ==  1  )  {
				pSystemCtl->EventManager->eventReq  &=  ~EVENT_SEC;
				/*  release processing every second whereby you can exit from Keyin. */
				ret  =  EventExec();
				if  (ret  ==  -1)  {
				/*  request for end of application	    */
					dos_exit(0);
				}
				break;
			}
/*  ^ up to here */
/*  v event processing of buttons from here */
			if(  bt&Key_menu  ){
				pSystemCtl->EventManager->eventReq  &=  ~EVENT_SEC;
				/*  release processing every second whereby you can exit from Keyin. */
				if(  CheckVol()  ){	/* heavy load voltage check */
					dispVOLerr();	/* error display 	    */
					dos_exit(0);
				}
				menuEND  =  aprMenu("Clock Menu",menuLIST,
									(int)sizeof(menuLIST)/sizeof(MENU));
				if(  menuEND  ==  -2  )	dos_exit(0);	/*  end of application	*/
				break;
			}
		}
	}
}
/*  ^ up to here */
