/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		onHand/Ruputer  Sample  Program  								*/
/*		<<Digital  Clock>>          									*/
/*======================================================================*/

#include  "psdos.h"
#include  "lcdbios.h"
#include  "wbios.h"
#include  "rupsys.h"
#include  "font.h"

/*  Button  condition  define	*/
#define  Key_file		0x0001		/*	swA(K0)key  interruption	*/
#define  Key_enter		0x0008		/*	swB(K3)key  interruption	*/
#define  Key_el			0x0004		/*	swC(K2)key  interruption	*/
#define  Key_menu		0x0002		/*	swD(K1)key  interruption	*/
#define  Key_left		0x0010		/*	swE(K4)key  interruption	*/
#define  Key_up			0x0020		/*	swF(K5)key  interruption	*/
#define  Key_right		0x0040		/*	swG(K6)key  interruption	*/
#define  Key_down		0x0080		/*	swH(K7)key  interurption	*/
/*  communications  error  code  */
#define	BLDSTOP			-4	/*  Detect that the backside of a battery lid is open. */
#define	TIMEOUTerr		-5	/*  Timeout											   */

int  timecom(void);
int  send(void);
int  receive(void);

static  WatchDT  Time;
static  const  RECT  CLRLCD={0,0,101,63};
static  MENU  menuLIST[]={
	{  adjTime,		 "Time/Date"       ,1,0},
	{  timecom,		 "Ir Communication",1,0},
	{  setExitMenu,	 "Exit"            ,0,0}
};
static  MENU  com_menuLIST[]={
	{  send,		"Time transmission",1,0},
	{  receive,		"Time reception   ",1,0},
};
static  char  *eMess0[]  =  {"      No response"};
static  char  *eMess1[]  =  {"   Transmission","            aborted."};
static  char  *eMess2[]  =  {"    Reception  ","            aborted."};

/*-----------------------------------------------------------*/
/*	  Time Data Transmission								 */
/*-----------------------------------------------------------*/
int  send(void)
{
	int  ret;
	int  rst;
	KANJI_PUT  Mess[]  =  {
		{{ 13, 15},"Ready to transmit",5,0,0},
		{{ 28,  0},"Time data",5,0,0}
	};

	rst  =  dispYN(" Do you send","         time data?",-1);
	if(  rst  ==  -1  )	dos_exit(0);
	if(  !rst  ){
		pv_clear((RECT  *)&CLRLCD);
		pv_kput((KANJI_PUT  *)&Mess[0]);
		pv_kput((KANJI_PUT  *)&Mess[1]);
		ret  =  sendTime();
		if(  !ret  ){
			dispMessBar("Completed");
			endMessBar();
			return  -4;
		}
		else  if(ret==BLDSTOP)	dos_exit(0);
		else  if(ret==TIMEOUTerr){
			/*  Transmission timeout  */
			if  ((dispMess(eMess0,1))  ==  -1)  dos_exit(0);
			return  -4;
		}
		else{/*  Transmission  suspended  */
			if  ((dispMess(eMess1,2))  ==  -1)  dos_exit(0);
			return  -4;
		}
	}
	return  0;
}
/*-----------------------------------------------------------*/
/*	  Time data reception			     	 				 */
/*-----------------------------------------------------------*/
int  receive(void)
{
	int  ret;
	int  rst;
	WatchDT  getRTCTime;
	KANJI_PUT  Mess[]  =  {
		{{ 13, 15},"Ready to receive",5,0,0},
		{{ 28,  0},"Time data",5,0,0}
	};

	rst  =  dispYN(" Do you receive","         time data?",-1);
	if(  rst  ==  -1  )	dos_exit(0);
	if(  !rst  ){
		pv_clear((RECT  *)&CLRLCD);
		pv_kput((KANJI_PUT  *)&Mess[0]);
		pv_kput((KANJI_PUT  *)&Mess[1]);
		ret=recvTime(&getRTCTime);
		if(  !ret  ){
			*pSystemCtl->CPUram=getRTCTime;
			dispMessBar("Completed");
			/* Processing necessary when time has been changed subsequently */
			setRTC();				/*  RTC set  		    */
			setRTCquit();
			setPowerStandby();
			CheckExecute();			/*  Start CHECK.EXF	    */
			/*  Need  up  to  here  */
			endMessBar();			/*  end of dispMessBar  */
			return  -4;
		}
		else  if(ret==BLDSTOP)	dos_exit(0);
		else  if(ret==TIMEOUTerr){
			/*  reception  timeout  */
			if  ((dispMess(eMess0,1))  ==  -1)  dos_exit(0);
			return  -4;
		}
		else{/*  reception  suspended  */
			if  ((dispMess(eMess2,2))  ==  -1)  dos_exit(0);
			return  -4;
		}
	}
	return  0;
}
/*-----------------------------------------------------------*/
/*	  Time data communications								 */
/*-----------------------------------------------------------*/
int  timecom(void)
{
	return  aprMenu("Ir Communication", com_menuLIST,
					(int)sizeof(com_menuLIST)/sizeof(MENU));
}
/*-----------------------------------------------------------*/
/*	  Clock display (one second interval)	  				 */
/*-----------------------------------------------------------*/
void  dispWATCH(int  All)
{
	int  chgHour;

	Time  =  *pSystemCtl->CPUram;
	/*  Read time data on RAM.  				            */
	/*  faster, saving more power and memory than getRTC();	*/
	dispNowTime(    14,  41,  52,  24,  57,  2,  All  );/*  hour and minute */
}
/*-----------------------------------------------------------*/
/*	  Main						 							 */
/*-----------------------------------------------------------*/
int  main(void)
{
	int  menuEND  =  0;
	int  bt;
	int  ret;
	int  BLINK_no;
	const  BLINK_DRAW  tmBLINK  =  {{43,24,  51,43},0x0060};/*  1Hz blink  */

	screen(1);						/*	Graphic mode				*/
	gv_place(0,0);					/*	XY coordinate X:0, Y:0		*/
	endWaiting();					/*	Stop startup animation.		*/
	while(1){
		lcdfreeze(1);
		pv_clear((RECT  *)&CLRLCD);		/* 	Clear screen.  */
		pSystemCtl->EventManager->eventReq  |=  EVENT_SEC;
							/*	Setting for exiting from Keyin ever second  */
		dispWATCH(1);				/*	Display all screens.	*/
		BLINK_no=pblink((BLINK_DRAW  *)&tmBLINK);
		blstart(BLINK_no);			/*  	Colon: Blinking starts.		*/
		lcdfreeze(0);

		while(1){
			bt  =  Keyin(  0,-1  );
/*  v Hereafter event processing other than buttons of Keyin  */
			if(  bt  &  EVENT_REQ  ){
				/*  event processing to exit from Keyin for every 1Hz  */
				if  ((pSystemCtl->EventManager->eventReq  &  EVENT_SEC)  &&  
				        (pSystemCtl->EventManager->event    &  EVENT_SEC)){
				        pSystemCtl->EventManager->event  &=  ~EVENT_SEC;
					/*	1Hz  display  and  processing	*/
					dispWATCH(0);
				}
			}
			ret  =  EventCall(bt);
			if(ret  ==  -1)  {
				/*  request for end of application  */
				pSystemCtl->EventManager->eventReq  &=  ~EVENT_SEC;
				/*  Deselect setting to exit from Keyin every second */
				blend(BLINK_no);/*  stop  blink  */
				dos_exit(0);
			}
			else  if(  ret  ==  1  )  {
				pSystemCtl->EventManager->eventReq  &=  ~EVENT_SEC;
				/*  Deselect setting for exiting from Keyin every second. */
				blend(BLINK_no);/*  stop  blink  */
				ret  =  EventExec();
				if  (ret  ==  -1)  {
				/*  request for end of application */
					dos_exit(0);
				}
				break;
			}
/*  ^ up  to  here  */
/*  v hereafter event processing of buttons */
			if(  bt&Key_menu  ){
				pSystemCtl->EventManager->eventReq  &=  ~EVENT_SEC;
				/* deselect setting for exiting from Keyin every second. */
				blend(BLINK_no);/* stop blink */
				if(  CheckVol()  ){	/* Heady load voltage check */
					dispVOLerr();	/* error display */
					dos_exit(0);
				}
				menuEND  =  aprMenu("Clock Menu",menuLIST,
									(int)sizeof(menuLIST)/sizeof(MENU));
				if(  menuEND  ==  -2  )	dos_exit(0);	/* end of application */
				break;
			}
		}
	}
}
/*  ^ up to here  */
