/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		onHand/Ruputer Sample Program 									*/
/*		<<Font Display>>     											*/
/*======================================================================*/

#include "string.h"
#include "psdos.h"
#include "lcdbios.h"
#include "wbios.h"
#include "rupsys.h"
#include "font.h"

/* Buton condition define	*/
#define Key_file		0x0001		/*	swA(K0) key interruption*/
#define Key_enter		0x0008		/*	swB(K3) key interruption*/
#define Key_el			0x0004		/*	swC(K2)key interruption	*/
#define Key_menu		0x0002		/*	swD(K1)key interruption	*/
#define Key_left		0x0010		/*	swE(K4)key interruptoin	*/
#define Key_up			0x0020		/*	swF(K5)key interruption	*/
#define Key_right		0x0040		/*	swG(K6)key interruption	*/
#define Key_down		0x0080		/*	swH(K7)key interruption	*/

/*	font code character width table	*/
const static int ScodeWide[]={	 12,12,12, 6, 5, 6, 6, 6, 3, 3,
								  3, 4, 5, 0, 0, 0, 5, 5, 0, 5,
								  6, 0, 0, 0, 6, 6, 6, 0, 0, 0,
								  0, 0, 7, 7, 0, 0, 0, 0, 0, 0,
								  9, 9, 0, 0, 0, 0, 0, 0,11,11,
								 11, 0, 0, 0, 0, 0,13,13,13,13,
								 13
};
const static int ScodeHight[]={	 12,10, 8,12, 7,12,10, 8, 5, 7,
								  9, 9, 7, 0, 0, 0, 9, 9, 0,10,
								 11, 0, 0, 0,13,13,13, 0, 0, 0,
								  0, 0,13,13, 0, 0, 0, 0, 0, 0,
								 16,16, 0, 0, 0, 0, 0, 0,17,17,
								 17, 0, 0, 0, 0, 0,19,19,19,19,
								 24
};
/*-----------------------------------------------------------*/
/*	 Convert a numeric value into an ASCII code	 			 */
/*-----------------------------------------------------------*/
static void INTtoASC(char *p,int val,int keta,int sup)
{
	int i;

	for(i=keta-1;0<=i;i--){
		p[i]=val%10+0x30;
		if(i!=keta-1 && sup==1 && p[i]=='0')	p[i]=' ';
		val /= 10;
	}
	return;
}
/*-----------------------------------------------------------*/
/*	 Display font			      							 */
/*-----------------------------------------------------------*/
static void dispFont( int no )
{
	int i;
	char buf[2] = " ";
	KANJI_PUT font = {{0,0},buf,no,1,0};
	const RECT CLR={0,13,114,63};
	int f = 0;
	int imem;
	
	pv_clear((RECT *)&CLR);
	/* Clear font display area */
	if( no >= 0 && no <= 2 ){/* S_JIS,ANK  */
		gv_kput(0,13,"0123456789:;<=>?@",no,0,0);
		gv_kput(0,(ScodeHight[no]+1)+13,
			"ABCDEFGHabcdefghi",no,0,0);
		gv_kput(0,(ScodeHight[no]+1)*2+13,
			"",no,0,0);
		gv_kput(0,(ScodeHight[no]+1)*3+13,
			"",no,0,0);
		/*
			gv_kput can be displayed in pv_kput
			as pv_kput has a smaller number of arguments than gv_kput has, it is effective in reducing memory.
		*/
	}
	else if( no >= 5 && no <= 7 ){/* alphanumeric proportional font display */
		gv_kput(0,13,"0123456789:;<=>?@",no,0,0);
		gv_kput(0,(ScodeHight[no]+1)+13,"ABCDEFGHabcdefghi",no,0,0);
		gv_kput(0,(ScodeHight[no]+1)*2+13,"",no,0,0);
		gv_kput(0,(ScodeHight[no]+1)*3+13,"",no,0,0);
		/*
			gv_kput can be displayed with pv_kput.
			As pv_kput has a smaller number of arguments than gv_kput does, it is effective in reducing memory. 
		*/
	}
	else{
		for( i = 0; i < 15 ; i ++ ){/* numeric font display */
			font.pos.x = (ScodeWide[no]+1)*i+1;
			font.pos.y = 13;
			if( (ScodeWide[no]+1)*(i+1)+1 > 101 ){
				if( !f ){
					f = 1;
					imem = i;
				}
				font.pos.x = (ScodeWide[no]+1)*(i-imem)+1;
				font.pos.y = 15 + ScodeHight[no];
			}
			if( i < 10 )	INTtoASC( buf,i,1,0 );
			else{
				switch( i ){
					case 10:buf[0] = ':';/* : */
							break;
					case 11:buf[0] = ';';/* - */
							break;
					case 12:buf[0] = '<';/* A */
							break;
					case 13:buf[0] = '>';/* P */
							break;
					case 14:buf[0] = '=';/* M */
				}
			}
			pv_kput( (KANJI_PUT *)&font );
		}
	}
	return;
}
/*-----------------------------------------------------------*/
/*	 main					     							 */
/*-----------------------------------------------------------*/
int main(void)
{
	int bt;
	int ret;
	int FontNo[] = {
		0,1,2,5,6,7,8,9,
		10,11,12,16,17,19,20,24,25,26,
		32,33,40,41,48,49,50,56,57,58,
		59,60
		};/*  font_no : 32 kinds */
	char buf[3]="  ";
	char buf0[1024],buf1[1024];
	int co = 0;

	KANJI_PUT mess = {{10,0},"font_code = ",0,0,0};
	KANJI_PUT dispno = {{82,0},buf,0,0,0};
	GVRAM_GET fontget[] = {
		{ {0,13,101,63},buf0 },
		{ {13,13,114,63},buf1 },
	};
	GVRAM_PUT fontput = { {0,13},0,0 };

	screen(1);						/*	graphic mode			 */
	gv_place(0,0);					/*	XY coordiantes  X:0, Y:0 */
	endWaiting();					/*	stop startup animation.	 */
	cls(4);							/* 	clear screen 			 */
	pv_kput( (KANJI_PUT *)&mess );
	INTtoASC( buf,FontNo[co],2,1 );
	pv_kput( (KANJI_PUT *)&dispno );
	/* font No. display */
	dispFont( FontNo[co] );
	/* font display */
	while(1){
		bt = Keyin( (Key_up|Key_down),-1 );
/* v hereafer event processing other than Keyin button */
		ret = EventCall(bt);
		if(ret == -1) {
			/* request for end of application */
			dos_exit(0);
		}
		else if( ret == 1 ) {
			ret = EventExec();
			if (ret == -1) {
				/* request for end of application */
				dos_exit(0);
			}
			/* redraw because display is rewritten in . */
			cls(4);							/* Clear screen */
			pv_kput( (KANJI_PUT *)&mess );
			INTtoASC( buf,FontNo[co],2,1 );
			pv_kput( (KANJI_PUT *)&dispno );
			/* font display */
			dispFont( FontNo[co] );
			/* font display */
		}
/* ^ up to here */
/* v hereafter event processing of buttons */
		if( bt&Key_menu ){
			/* end with menu key. */
			dos_exit(0);
		}
		else if( bt&Key_up ){
			co ++;
			if( co > 31 )	co = 0;
			INTtoASC( buf,FontNo[co],2,1 );
			pv_kput( (KANJI_PUT *)&dispno );
			/* font No. display */
			dispFont( FontNo[co] );
			/* font display */
			if( co >= 27 ){
				memset( buf0, 0, 1024 );
				memset( buf1, 0, 1024 );	/*buffer clear	*/
				pv_get( (GVRAM_GET *)&fontget[0] );
				pv_get( (GVRAM_GET *)&fontget[1] );
			}
		}
		else if( bt&Key_down ){
			co --;
			if( co < 0 )	co = 31;
			INTtoASC( buf,FontNo[co],2,1 );
			pv_kput( (KANJI_PUT *)&dispno );
			/* font No display */
			dispFont( FontNo[co] );
			/* font display */
			if( co >= 27 ){
				memset( buf0, 0, 1024 );
				memset( buf1, 0, 1024 );	/* buffer clear	*/
				pv_get( (GVRAM_GET *)&fontget[0] );
				pv_get( (GVRAM_GET *)&fontget[1] );
			}
		}
		else if( bt&Key_right ){
			if( co >= 27 ){
				/* display unhidden part */
				fontput.buf = buf1;
				pv_put( (GVRAM_PUT *)&fontput );
			}
		}
		else if( bt&Key_left ){
			if( co >= 27 ){
				fontput.buf = buf0;
				pv_put( (GVRAM_PUT *)&fontput );
			}
		}
	}
}
/* ^| up to here */
