/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		Jumping Hour	 												*/
/*		psdos version		     										*/
/*======================================================================*/

#include"lcdbios.h"
#include"wbios.h"
#include"psdos.h"
#include"rupsys.h"
#include"ruptool.h"

MENU Mp[] = {
	{ setExitMenu,"Exit",0,0}
};

/* font display information */
static int FONT0,X0,Y0,w0,h0,W0;


/**************** Do you hit on a wall ****************/
static void chkWALL( int wall0,int wall1, int *X, int *dX );
/****************      two-digit display       ******************/
/* static char *itoa2( int test, int zero ); */


typedef struct{
	int yy; int mm; int dd;
	int h;  int m;  int s;
} st_RTM;

/* data, time information */
static st_RTM RTM;

/*************real time clock ************/
static void GetRTC(void)
{
/* obtain date, time information */
    RTM.yy=pSystemCtl->CPUram->NOW_Year;
    RTM.mm=pSystemCtl->CPUram->NOW_Month;
    RTM.dd=pSystemCtl->CPUram->NOW_Day;

/* obtain time information */
    RTM.h=pSystemCtl->CPUram->NOW_Hour;
    RTM.m=pSystemCtl->CPUram->NOW_Min;
    RTM.s=pSystemCtl->CPUram->NOW_Sec;
}

static char *itoa2( int test, int zero )
{
/* two digit display */
    static char data[20];
    int ptr=0;

    if( test==0 )
	if( !zero ) return( "00" );
	else	    return( "?0" );

    if( test>=100 )
		test=test%100;
    else if( test>=10 ){
		data[ptr++]=0x30+test/10;
		test=test%10;
    }else{
		if( zero ) data[ptr++]='?';
		else	   data[ptr++]='0';
    }

    data[ptr++]=0x30+test;
    data[ptr]='\0';
    return( data );
}
static void saverDISP(int disp)
{
/* time check & display */
	static int pmin=-100;
    GetRTC();
	if (pmin!=RTM.m||disp) {
		pmin=RTM.m;
		gv_kput(150     ,150,"??:??",FONT0,0,0);
		gv_kput(150	,150,itoa2(RTM.h,1),FONT0,0,0);
		gv_kput(150+3*w0,150,itoa2(RTM.m,0),FONT0,0,0);
	}
}
/********************* calculate coordinates **********************/
static int  GRAV;  /* gravity */
static int  dy;    /* acceleration y direction */
static int  dx;    /* acceleration x direction */
/******************************************************************/
static void saverPROC(void)
{
/* movement version */
	static int  px,py;
	px =X0;
	py =Y0;
	dy+=GRAV;	/* calculate gravity */
	X0+=dx;
	Y0+=dy;

	/* check X coordinate */
	if( RTM.h>=10 )
		chkWALL(0   ,101-W0,&X0,&dx);
	else
		chkWALL(0-w0,101-W0,&X0,&dx);

	/* check Y coordinate */
	chkWALL(0,63-h0,&Y0,&dy);

	/* draw */
	lcdfreeze(1);
	saverDISP(0);
	gv_place(150-X0,150-Y0);
	lcdfreeze(0);
}
/****************** Temporarily stop timer **********************/
static void saverSTOP(int *TM)
{
	TM[0] = 0;
	cls(LCD_ERASE);
}
static void saverRESTART(int *TM)
{
	saverDISP(1);
	TM[0] = 1;
}
/****************** execution routine **********************/
void SvExec(int *TM)
{
	int bt,rst;

	bt=rst=0;
	while (bt==0 && rst==0) {
		/* wait for entry of button & event */
		bt = Keyin(0,-1);
		/* Check an event. */
		rst = EventCall(bt&~Bkey_A);

		if (rst == 1) {
			saverSTOP(TM);

			rst = EventExec();
			if (bt&Bkey_A)
				bt=0;

			saverRESTART(TM);
		}
		/* El event is not returned with Keyin(). */
		if (bi_scanbtn()&Bkey_C)
			bt=rst=0;
	}

}
void Exec(int *TM)
{
	int bt,rst;

	bt=rst=0;
	while(1) {
		bt=Keyin(0,-1);
		rst = EventCall(bt);

		if (rst==-1) {
			return;			/* request for end of application */
		}
		else if (rst==1) {
			saverSTOP(TM);

			rst = EventExec();
			if (rst==-1)
				return;		/* request for end of application */

			saverRESTART(TM);
		}
		else {
			if (bt==Bkey_D) {
				saverSTOP(TM);

				if((rst= aprMenu( "Jumping Hour",Mp,(int)sizeof(Mp)/sizeof(MENU))) == -2)
					return;	/* request for end of application */

				saverRESTART(TM);
			}
/*****************
			else if (bi_scanbtn()&Bkey_C)
				bt=rst=0;	* EL event is not returned with Keyin(). *
			else if (bt&0xFF)
				return;		* request for end of application *
******************/
		}
	}
}


int main(void)
{
	char *argv;
	int  *TMsvr=(int*)-1;
	int x,y;

	/* obtain coordinate from ruptool.h*/
	getGvPos(&x,&y);

	/* Incorporate arguments. */
	argv =getArg();
	/* Initialize screen. */
    screen(LCD_GRAPH);
	cls(LCD_ERASE);

	/* Pulled by jump, jump gravity 3. */
	GRAV=3;
	/* Initialize acceleration. */
	dx=  2;
	dy=-11;
	FONT0=60;X0=13;Y0=40;w0=13;h0=24;W0=w0*5;

	/* Register display routine */
	TMsvr=bi_tmset(1,255,1,saverPROC);

	if (pSystemCtl->EventManager->eventReq & EVENT_SvExec) {
		/* power save being executed */
		SvExec(TMsvr);
	} else {
		/* simply being executed */
		Exec(TMsvr);
	}

	/* end of display routine  */
	if( TMsvr!=(int*)-1 )
		bi_tmdel(TMsvr);

	cls(LCD_ERASE);
	gv_place(x,y);	/* return to the original coordinate*/

}

/****************  do you hit on a wall  ******************/
static void chkWALL( int wall0,int wall1, int *X, int *dX )
{
/* wall check */
	if( *X<wall0 ){
	*X =2*wall0-(*X);
	*dX=-((*dX)+*X/10);
/*	*dX=-(*dX);
*/
	}else if( wall1<*X ){
	*X =2*wall1-(*X);
	*dX=-(*dX);
	}
}

