/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		Lines			 			 									*/
/*		psdos version		     										*/
/*======================================================================*/

#include"lcdbios.h"
#include"wbios.h"
#include"psdos.h"
#include"rupsys.h"


MENU Mp[] = {
	{ setExitMenu,"Exit",0,0}
};

/****************  Do you hit on a wall ******************/
static void chkWALL( int wall0,int wall1, int *X, int *dX );

/********************* Calculate coordinates **********************/
static int LN,logic;
static unsigned char style0=0x00,style1;
static int x0[10],x1[10],y0[10],y1[10];
static int dx0=2, dx1=-3, dy0=6, dy1=1;
static int xp0=20,xp1=50,yp0=13,yp1=30;
/******************************************************************/
static void initLine(int num,int lg,unsigned char stl1)
{
	int i;

    LN=num-1;
    if( LN>9 ) LN=9;

	style1=stl1;
	logic =lg;
    if( logic==1 ) style0=style1;

	/* Using filer resource time information, set initial coordinates appropriately. */
	xp0=10+pSystemCtl->CPUram->NOW_Min;
	xp1=30+pSystemCtl->CPUram->NOW_Sec;
	yp0= 2+pSystemCtl->CPUram->NOW_Sec;
	yp1=20+pSystemCtl->CPUram->NOW_Hour;

	for (i=0;i<10;i++) {
		x0[i]=xp0; x1[i]=xp1; y0[i]=yp0; y1[i]=yp1;
	}

    gv_line(xp0,yp0,xp1,yp1,1,0x00);
}
static void endLine(void)
{
	int i;
    for (i=0;i<10;i++) {
		x0[i]=x0[LN]; x1[i]=x1[LN]; y0[i]=y0[LN]; y1[i]=y1[LN];
    }
    xp0=x0[0]; xp1=x1[0]; yp0=y0[0]; yp1=y1[0];
}

static void saverPROC(void)
{
    int i,ii;
	x0[LN]+=dx0; x1[LN]+=dx1; y0[LN]+=dy0; y1[LN]+=dy1;

	chkWALL( 0,101, &x0[LN], &dx0 );
	chkWALL( 0,101, &x1[LN], &dx1 );
	chkWALL( 0, 63, &y0[LN], &dy0 );
	chkWALL( 0, 63, &y1[LN], &dy1 );

	gv_line(xp0,yp0,xp1,yp1,logic,style0);
	gv_line(x0[LN],y0[LN],x1[LN],y1[LN],logic,style1);

	xp0=x0[0]; xp1=x1[0]; yp0=y0[0]; yp1=y1[0];
	for(i=0;i<LN;i++){
	    ii=i+1;
	    x0[i]=x0[ii]; x1[i]=x1[ii]; y0[i]=y0[ii]; y1[i]=y1[ii];
	}
}
/****************** Temporarily stop a timer **********************/
static void saverSTOP(int *TM)
{
	TM[0] = 0;
	cls(LCD_ERASE);
}
static void saverRESTART(int *TM)
{
	cls(LCD_ERASE);
	TM[0] = 1;
}
/****************** execution routine ****************************/
void SvExec(int *TM)
{
	int bt,rst;

	bt=rst=0;
	while (bt==0 && rst==0) {
		/* Wait for entry of button & event. */
		bt = Keyin(0,-1);
		/* Check an event. */
		rst = EventCall(bt&~Bkey_A);

		if (rst == 1) {
			saverSTOP(TM);

			rst = EventExec();
			if (bt&Bkey_A)
				bt=0;

			saverRESTART(TM);
		}
		/* EL event is not returned with Keyin(). */
		if (bi_scanbtn()&Bkey_C)
			bt=rst=0;
	}

}
void Exec(int *TM)
{
	int bt,rst;

	bt=rst=0;
	while(1) {
		bt=Keyin(0,-1);
		rst = EventCall(bt);

		if (rst==-1) {
			return;			/* request for end of application */
		}
		else if (rst==1) {
			saverSTOP(TM);

			rst = EventExec();
			if (rst==-1)
				return;		/* request for end of application */

			saverRESTART(TM);
		}
		else {
			if (bt==Bkey_D) {
				saverSTOP(TM);

				if((rst= aprMenu( "Lines",Mp,(int)sizeof(Mp)/sizeof(MENU))) == -2)
					return;	/* request for end of application */

				saverRESTART(TM);
			}
/*****************
			else if (bi_scanbtn()&Bkey_C)
				bt=rst=0;	* EL event is not returned with Keyin(). *
			else if (bt&0xFF)
				return;		* request for end of application *
******************/
		}
	}
}


int main(void)
{
	char *argv;
	int  *TMsvr=(int*)-1;

	/* Incorporate arguments. */
	argv =getArg();
	/* Initialize screen. */
    screen(LCD_GRAPH);
	cls(LCD_ERASE);

	/* Initialize display attributes. */
	initLine(10,0,0xFF);

	/* Register display routines. */
	TMsvr=bi_tmset(1,255,1,saverPROC);

	if (pSystemCtl->EventManager->eventReq & EVENT_SvExec) {
		/* power save being executed. */
		SvExec(TMsvr);
	} else {
		/* simply being executed. */
		Exec(TMsvr);
	}

	/* end of display routine */
	if( TMsvr!=(int*)-1 )
		bi_tmdel(TMsvr);

	/* store a displayed value */
	endLine();
}
/****************  do you hit on a wall  ******************/
void chkWALL( int wall0,int wall1, int *X, int *dX )
{
/* line screen */
    if( *X<wall0 ){
		*X =2*wall0-(*X);
/*		*dX=-((*dX)+*X/10);*/
		*dX=-(*dX);
    }else if( wall1<*X ){
		*X =2*wall1-(*X);
		*dX=-(*dX);
    }
}
