/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		onHand/Ruputer Sample Program 									*/
/*		<<Picture Drawing>>	   											*/
/*																		*/
/*======================================================================*/

#include "psdos.h"
#include "lcdbios.h"
#include "wbios.h"
#include "rupsys.h"

/* Picture data in MMP format */
const char Picmmp[]={
0x21,0x00,0x20,0x00,
0x00,0x00,0xFC,0xFC,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,
0x0C,0x0C,0x8C,0x4C,0x2C,0x2C,0x2C,0x2C,0x2C,0x4C,
0x8C,0x0C,0x0C,0x0C,0x4C,0xAC,0x4C,0x0C,0x0C,0xFC,
0xFC,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x02,0x45,
0xA2,0x40,0x00,0x80,0x40,0x27,0x28,0x10,0x11,0x10,
0x11,0x10,0x28,0x27,0x40,0x88,0x14,0x08,0x40,0xA0,
0x40,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x3F,0x40,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x40,0x3F,
0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,
0x00,0x3F,0x3F,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
0x30,0x31,0x31,0x32,0x32,0x32,0x32,0x32,0x31,0x31,
0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3F,0x3F,
0x00,0x00
};
static int px,py;/* picture display coordinates */
static GVRAM_PUT Picput = {{0,0},(char *)Picmmp,0};
/*-----------------------------------------------------------*/
/*	 Display picture movement		      	                 */
/*-----------------------------------------------------------*/
static void movPic(void)
{
	static int fwx=0,fwy=0;

	/* Obtain display coordinates. */
	if( !fwx ){
		px += 2;
		if( px > 102-(0x21+2) )	fwx = 1;
	}
	else{
		px -= 2;
		if( px < 2 )			fwx = 0;
	}
	if( !fwy ){
		py += 2;
		if( py > 64-(0x20+2) )	fwy = 1;
	}
	else{
		py -= 2;
		if( py < 2 )			fwy = 0;
	}
	Picput.pos.x = px;
	Picput.pos.y = py;
	pv_put((GVRAM_PUT *)&Picput);	/* Picture display */
	return;
}
/*-----------------------------------------------------------*/
/*	 Main					   	                             */
/*-----------------------------------------------------------*/
int main(void)
{
	const RECT CLRLCD={0,0,101,63};
	int *tm_movPic = (int *)-1;

	screen(1);						/* graphic mode 			*/
	gv_place(0,0);					/* XY coordinates  X:0, Y:0	*/
	endWaiting();					/* Stop startup animation.	*/
	pv_clear((RECT *)&CLRLCD);		/* Clear screen. 			*/

	if (pSystemCtl->EventManager->event&EVENT_DBLCLICK) { Keyin(0,-1);}
	/*
		 if you start this program by right cursor double click,clear the key buffer.
		 Refer to <rupsysLibManu(c).txt> Keyin()
	*/

	px = 100;
	py = 10;
	Picput.pos.x = px;
	Picput.pos.y = py;
	pv_put((GVRAM_PUT *)&Picput);	   /* Picture display	 */
	tm_movPic=bi_tmset(2,255,8,movPic);/* 8/64Hz  timer set  */
	Keyin(0,-1);
	if( tm_movPic != (int *)-1 )	bi_tmdel(tm_movPic);
	/* 
		Process so that a timer identifier, if it is other than -1, should close. 
		This is because a program may run away out of control, 
		for instance, if you try to close a timer that has not been opened. 
	*/
	dos_exit(0);/* End if some key is pressed. */
}
