/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		Labyrinth escape ver0.9		by cherry							*/
/*		psdos version	        										*/
/*======================================================================*/

#include<stdio.h>

#include"lcdbios.h"
#include"wbios.h"
#include"psdos.h"
#include"rupsys.h"
#include"applib.h"

/* constant definition */
#define G_T 0x01  /* wall information up 	  */
#define G_R 0x02  /* wall information right   */
#define G_B 0x04  /* wall information down 	  */
#define G_L 0x08  /* wall information left	  */

#define BLK_X 10  /* how many tatami mats in width	    */
#define BLK_Y  5  /* how many tatami mats in length 	*/
#define MMM    6  /* total number of characters	        */

#define SCOREMAX 10000

/* class */

#define SELmax 5
char LIST[SELmax][20]={
    {"finger training"},   /* mode=0 */
    {" introduction  "},   /* mode=1 */
    {" finger easy   "},   /* mode=2 */
    {" finger medium "},   /* mode=3 */
    {" finger hard   "},   /* mode=4 */
};


/* constant definition */
static int START; /* starter 		*/
static int TD;    /* remaining time */


int Pgame;        /* front, back    */
int Hiscore=0;
int Pscore;
int Pend;
char Pmap[BLK_Y][BLK_X]; /* feed map 	 */
char ENG[5][128];        /* feed picture */
char PAC[5][128];        /* yourself?    */
char MON[1][128];        /* bad guys     */

volatile static int Gx[MMM],Gy[MMM],Gxp[MMM],Gyp[MMM],
           Gmx[MMM],Gmy[MMM],Gmxp[MMM],Gmyp[MMM],
           Gf[MMM];


const char BLOCK[BLK_Y][BLK_X]={
    { 6,10,12, 6,10,10,12, 6,10,12},
    { 5, 6,13, 5, 6,12, 5, 7,12, 5},
    {13, 5, 3,13, 3, 9, 7, 9, 5, 7},
    { 5, 3,12, 3,10,10, 9, 6, 9, 5},
    { 3,10,11,10,10,10,10,11,10, 9}
};
const char Score[BLK_Y][BLK_X]={
    { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2},
    { 2, 2, 2, 2, 0, 0, 2, 2, 2, 1},
    { 2, 4, 2, 2, 0, 0, 4, 2, 2, 2},
    { 2, 2, 1, 2, 2, 2, 2, 2, 2, 2},
    { 2, 4, 2, 2, 2, 1, 2, 3, 4, 1}
};
const int x0=5,y0=12,S=9;


/******* function definition ********/
void yubiINIT(void);
void yubiMAIN(int,int,int);
int  Side(char,char);
void yubiMOVE(int,int);
int  yubiOVER(int);
void yubiSCORE(int);
void yubiCLASS(int);
void TimeDISP(void);
void TimeSTART(void);
int  (*ConvKEY)(int);
int  ConvKEY_norm(int);
int  ConvKEY_rev(int);

void yubikeySET( int game )
{
/* front, back */

    Pgame=game;
    if( game==1 )
		ConvKEY=ConvKEY_norm;
    else
		ConvKEY=ConvKEY_rev;
}

/******* Implementation ********/
void yubiPOS(int x,int y,int key)
{
    static int cnt=0;
    static int dir;

    if( cnt==0 ){
		dir=4;
		cnt++;
    }else{
		if( key&0x0001 )      dir=0; /* ^  */
		else if( key&0x0004 ) dir=2; /* v  */
		
		if( key&0x0002 )      dir=1; /* -> */
		else if( key&0x0008 ) dir=3; /* <- */
		cnt=0;
    }
    gv_put(x,y,PAC[dir],0);
}
void yubiDEL(int x,int y)
{
    gv_put(x,y,ENG[0],0);
}
void MonPOS(int x, int y)
{
    gv_put(x,y,MON[0],0);
}
int ConvKEY_norm( int key )
{
    int KEY=0;

    if( (key&Bkey_up) )  		KEY+=0x0001;
    else if( (key&Bkey_dw) )	KEY+=0x0004;

    if( (key&Bkey_rg) )  		KEY+=0x0002;
    else if( (key&Bkey_lf) )	KEY+=0x0008;

    return( KEY );
}
int ConvKEY_rev( int key )
{
    int KEY=0;

    if( (key&Bkey_up) )  		KEY+=0x0004;
    else if( (key&Bkey_dw) )	KEY+=0x0001;

    if( (key&Bkey_rg) )  		KEY+=0x0008;
    else if( (key&Bkey_lf) )	KEY+=0x0002;

    return( KEY );
}
int MonDir2( int i, int pkey )
{
    static int randkey=0;
    randkey=(randkey+pkey+1)%13;

    if( Gf[i]>100 ){
		Gf[i]-=100;
		return( Gf[i]%100 );
    }else if( Gx[i]==Gxp[i]&&Gy[i]==Gyp[i] &&
	                    Gmxp[i]==Gmx[i]&&Gmyp[i]==Gmy[i] ){
		Gf[i]=200+randkey;
		return( randkey );
    }
    return( pkey );
}
int MonDir( int yubiX, int yubiY, int MonX, int MonY )
{
    int KeyX=0,KeyY=0,DisX=MonX-yubiX,DisY=MonY-yubiY;
    int dx,dy;

    if(DisX>=0) dx= 1;
    else        dx=-1;
    if(DisY>=0) dy= 1;
    else        dy=-1;

    DisX=DisX*dx;
    DisY=DisY*dy;
    if( DisX*dx<BLK_X/2*dx ){
		if( Side(BLOCK[MonY][MonX],G_L)/*&&Side(BLOCK[MonY][MonX-1],G_R)*/ )
		    KeyX=0x0008; /*left*/
    }else{
		if( Side(BLOCK[MonY][MonX],G_R)/*&&Side(BLOCK[MonY][MonX+1],G_L)*/ )
		    KeyX=0x0002; /*right*/
		DisX=BLK_X-DisX;
    }
    if( DisY*dy<BLK_Y/2*dy ){
		if( Side(BLOCK[MonY][MonX],G_T)/*&&Side(BLOCK[MonY-1][MonX],G_B)*/ )
		    KeyY=0x0001; /*above*/
    }else{
		if( Side(BLOCK[MonY][MonX],G_B)/*&&Side(BLOCK[MonY+1][MonX],G_T)*/ )
		    KeyY=0x0004; /*below*/
		DisY=BLK_Y-DisY;
    }
    if( DisX*BLK_Y<DisY*BLK_X ){
		if( KeyY!=0 ) return(KeyY);
		else          return(KeyX);
    }else{
		if( KeyX!=0 ) return(KeyX);
		else          return(KeyY);
    }
}
void yubiMOVE(int pkey,int mode)
{
/* finger art, motion in a dream */
    const  int xx0=x0-4,yy0=y0-4;
    volatile static int x=1,y=1,xp,yp,mx=0,my=0,mxp,myp;

    int i=pkey/100;
    if( i!=0 ){
        /* decide how bad buys move around. */
	    pkey=MonDir(Gx[0],Gy[0],Gx[i],Gy[i]);
	    pkey=MonDir2( i, pkey );
    }

    Gxp[i]=xp=x=Gx[i];     Gyp[i]=yp=y=Gy[i];
    Gmxp[i]=mxp=mx=Gmx[i]; Gmyp[i]=myp=my=Gmy[i];

    if( pkey&0x0001 ){      /* Top ^  */
		if( my==+1 ){
		    my=mx=0;
		}else if( y==0 && Side(BLOCK[y][x],G_T) ){
		    if( my==-1 ){
				y=BLK_Y-1; my=+1;
		    }else          my=-1;
		    mx=0;
		}else if( Side(BLOCK[y][x],G_T)&&Side(BLOCK[y-1][x],G_B) ){
		    if( my==-1 ){
				y--;       my=+1;
		    }else          my=-1;
		    mx=0;
		}
    }else if( pkey&0x0004 ){	/* BOTTOM v  */
		if( my==-1 ){
		    my=mx=0;
		}else if( y==BLK_Y-1 && Side(BLOCK[y][x],G_B) ){
		    if( my==+1 ){
				y=0;      my=-1;
		    }else         my=+1;
		    mx=0;
		}else if( Side(BLOCK[y][x],G_B)&&Side(BLOCK[y+1][x],G_T) ){
		    if( my==+1 ){
				y++;      my=-1;
		    }else         my=+1;
		    mx=0;
		}
    }

    if( pkey&0x0002 ){		/* Right -> */
		if( mx==-1 ){
		    my=mx=0;
		}else if( x==BLK_X-1 && Side(BLOCK[y][x],G_R) ){
		    if( mx==+1 ){
				x=0;       mx=-1;
		    }else          mx=+1;
		    my=0;
		}else if( Side(BLOCK[y][x],G_R)&&Side(BLOCK[y][x+1],G_L) ){
		    if( mx==+1 ){
				x++;       mx=-1;
		    }else          mx=+1;
		    my=0;
		}
    }else if( pkey&0x0008 ){	/* Left <- */
		if( mx==+1 ){
		    my=mx=0;
		}else if( x==0 && Side(BLOCK[y][x],G_L) ){
		    if( mx==-1 ){
				x=BLK_X-1; mx=+1;
		    }else          mx=-1;
		    my=0;
		}else if( Side(BLOCK[y][x],G_L)&&Side(BLOCK[y][x-1],G_R) ){
		    if( mx==-1 ){
				x--;       mx=+1;
		    }else          mx=-1;
		    my=0;
		}
    }

    yubiDEL(xx0+xp*S+S/2+mxp*S/3, yy0+yp*S+S/2+myp*S/3);

    /* Movement of characters */
    if( i==0 ){
		/* yourself? */
		yubiPOS(xx0+x *S+S/2+mx *S/3, yy0+y *S+S/2+my *S/3,pkey);
		Pscore+=Pmap[y][x];
		Pmap[y][x]=0;
		/* score display */
		gv_kput(0,0,itoa(Pscore,3),10,1,0);
    }else{
		/* bad guys */
		MonPOS(xx0+x *S+S/2+mx *S/3, yy0+y *S+S/2+my *S/3);
		if( (xp!=x||yp!=y)&&Pmap[yp][xp]!=0 ){
		  gv_put(xx0+xp*S+S/2,yy0+yp*S+S/2,ENG[Score[yp][xp]],0);
		}
    }
    Gx[i]=x;Gy[i]=y;Gmx[i]=mx;Gmy[i]=my;

    /* Are you eaten? */
    for(i=1;i<=mode;i++){
		if(Gx[0]==Gx[i]&&Gy[0]==Gy[i]){
		    Pscore=-100;
		    break;
		}
    }
}
void yubiMAIN(int Pmode,int Pacc,int Prem)
{
    int Key,*TM_mon,*TM_rem;
    int mons=0,monsCNT=0;

	static int TryNum=0;

    gv_place(109,0);
    gv_clear(109,0,211,64);
    START=3;
    TM_mon=bi_tmset(0,255,1,TimeSTART);

    /* Initialize the screen */
    yubiINIT();
    yubiMOVE( 0,Pmode );
    /* starter */
    gv_kput(113,3," Class ",5,0,2);
	gv_kput(117,16,LIST[Pmode],5,0,0);
	if (Pgame==2)
		gv_kput(117-6,16,"Back",5,0,0);

    while( START>=0 ){}

    bi_tmdel(TM_mon);
    gv_place(0,0);

    /* set key event */
    TM_mon=bi_tmset(2,255,6,ALM_PINT);

    /* set remaining time */
    TD=Prem;
    TM_rem=bi_tmset(0,255,1,TimeDISP);
    bi_clrbtn();
    do{

		if( 0xF0==(scanALM()&0xF0) ){
		    if( (Key=ConvKEY(bi_scanbtn()))!=0 ){
			    /* change your key. */
				yubiMOVE(Key,Pmode);
				bi_clrbtn();
		    }
		    if( monsCNT>=Pacc ){
			    /* bad buys' movement */
				mons=1;
				while( mons<=Pmode ){
				    yubiMOVE( mons*100,Pmode );
				    mons++;
				}
				monsCNT=0;
		    }else
				monsCNT++;
		    clrALM();
		}
		else if (bi_scanbtn()&Bkey_C)
			bi_el(10);

    }while( bi_scanbtn()!=Bkey_D && Pscore!=Pend && Pscore>=0 && TD>0 );

	Key=bi_scanbtn();

    bi_tmdel(TM_mon);
    bi_tmdel(TM_rem);

	if (Key==Bkey_D) return;

    gv_clear(0,y0-2,102,64);

    bi_clrbtn();
    if( Pscore==Pend ){
		/* Clear the number of accumulated games. */
		TryNum=0;

		gv_kput(13,15,"Good Job!!",5,1,0);
		gv_kput(14,15,"Good Job!!",5,1,1);
		waitTM(0,2);

		/* Score display */
		gv_kput(70,30,itoa(TD,2),2,0,0);
		gv_kput(10,30,"remaining time:",2,0,0);
		waitTM(0,1);
		yubiSCORE(Pmode);
    }else{
		/* Increase the number of accumulated games. */
		TryNum++;

		gv_kput(40,15,"Too Bad!!",5,1,0);
		gv_kput(41,15,"Too Bad!!",5,1,1);
		waitTM(1,1);

		if (TD==0) {
			gv_kput(12,28,"Time out!!",0,0,0);
			waitTM(1,3);
		}

		gv_kput(10,30,"No good",5,1,0);
		gv_kput(11,30,"No good",5,1,0);
		waitTM(1,1);
		gv_kput(1,40,"NO good",5,0,0);
		waitTM(1,1);
		gv_kput(19,23,"What're you doing",5,1,0);
		gv_kput(20,23,"What're you doing",5,1,1);
		waitTM(1,1);
		gv_kput(10,50,"You still young",5,1,0);
		waitTM(1,1);
		gv_kput(18,20,"No good",5,2,0);
		gv_kput(19,20,"No good",5,2,1);
		waitTM(1,1);
		gv_kput(10,43,"You still young",5,1,0);
		gv_kput(11,43,"You still young",5,1,1);
		waitTM(1,1);
		if (TryNum>4) {
			gv_kput(3,33,"Take a rest",5,1,0);
			gv_kput(4,33,"Take a rest",5,1,1);
		}
		else {
			gv_kput(3,33,"What're you doing",5,2,0);
			gv_kput(4,33,"What're you doing",5,2,1);
		}
		waitTM(1,1);
		if (TryNum>6) {
			gv_kput(2,13,"Your finger might hurt",5,0,0);
			gv_kput(3,13,"Your finger might hurt",5,0,0);
		}
		else {
			gv_kput(16,12,"try to come again",5,2,0);
			gv_kput(16,13,"try to come again",5,2,1);
		}
		waitTM(1,1);
		if (TryNum>8) {
			gv_kput(10, 3,"you had better rest",5,1,0);
			gv_kput(11, 3,"you had better rest",5,1,1);
		}
		else {
			gv_kput(10, 3,"try to come again",5,1,0);
			gv_kput(11, 3,"try to come again",5,1,1);
		}
		waitTM(0,1);
    }
}

int Side(char block,char flag)
{
/* Return whether or not there is a wall */
    return( block&flag );
}
void yubiMAKE(void)
{
    int x=0,y=0;
    UCHR buff[8000];

    /* Feed data */
    gv_get(0,0,S-2,S-2,ENG[0]);
    gv_circle(x0+x*S+S/2,y0+y*S+S/2, 1,0, 0,0,0,0xFF,(UCHR*)NULL);
    gv_get(x0+x*S,y0+y*S,x0+x*S+S-2,y0+y*S+S-2,ENG[1]);
    gv_circle(x0+x*S+S/2,y0+y*S+S/2, 1,1, 0,0,0,0xFF,(UCHR*)NULL);
    gv_get(x0+x*S,y0+y*S,x0+x*S+S-2,y0+y*S+S-2,ENG[2]);
    gv_circle(x0+x*S+S/2,y0+y*S+S/2, 2,1, 0,0,0,0xFF,(UCHR*)NULL);
    gv_get(x0+x*S,y0+y*S,x0+x*S+S-2,y0+y*S+S-2,ENG[3]);
    gv_circle(x0+x*S+S/2,y0+y*S+S/2, 1,2, 0,0,0,0xFF,(UCHR*)NULL);
    gv_get(x0+x*S,y0+y*S,x0+x*S+S-2,y0+y*S+S-2,ENG[4]);

    /* Data on you */
    x=2;
    gv_circle(x0+x*S+S/2,y0+y*S+S/2,2,2,140, 30,8*3+4,0xFFFFFFFF,(UCHR*)buff);
    gv_get(x0+x*S,y0+y*S,x0+x*S+S-2,y0+y*S+S-2,PAC[0]);
    x=3;
    gv_circle(x0+x*S+S/2,y0+y*S+S/2,2,2,230,120,8*3+4,0xFFFFFFFF,(UCHR*)buff);
    gv_get(x0+x*S,y0+y*S,x0+x*S+S-2,y0+y*S+S-2,PAC[1]);
    x=4;
    gv_circle(x0+x*S+S/2,y0+y*S+S/2,2,2,320,210,8*3+4,0xFFFFFFFF,(UCHR*)buff);
    gv_get(x0+x*S,y0+y*S,x0+x*S+S-2,y0+y*S+S-2,PAC[2]);
    x=5;
    gv_circle(x0+x*S+S/2,y0+y*S+S/2,2,2, 50,300,8*3+4,0xFFFFFFFF,(UCHR*)buff);
    gv_get(x0+x*S,y0+y*S,x0+x*S+S-2,y0+y*S+S-2,PAC[3]);
    x=6;
    gv_circle(x0+x*S+S/2,y0+y*S+S/2,2,2,  0,  0,    4,0xFFFFFFFF,(UCHR*)NULL);
    gv_get(x0+x*S,y0+y*S,x0+x*S+S-2,y0+y*S+S-2,PAC[4]);

    /* Data on bad guys */
    x=7;
    gv_circle(x0+x*S+S/2,y0+y*S+S-3,3,4,0,180,8*3+4,0xFFFFFFFF,(UCHR*)buff);
    gv_get(x0+x*S,y0+y*S,x0+x*S+S-2,y0+y*S+S-2,MON[0]);

}
void yubiINIT(void)
{
/* Clear initial screen and scores */
    int x=0,y=0;
    const int xx0=x0-1,yy0=y0-1;

    Pscore=Pend=0;
    Gx[0]=1; Gx[1]=4; Gx[2]=6; Gx[3]=4; Gx[4]=3; Gx[5]=2;
    Gy[0]=1; Gy[1]=3; Gy[2]=4; Gy[3]=0; Gy[4]=4; Gx[5]=4;
    Gmx[0]=Gmx[1]=Gmx[2]=Gmx[3]=Gmx[4]=Gmx[5]=0;
    Gmy[0]=Gmy[1]=Gmy[2]=Gmy[3]=Gmy[4]=Gmy[5]=0;

    Gf[0]=Gf[1]=Gf[2]=Gf[3]=Gf[4]=Gf[5]=0;

    cls(4);
    for( y=0;y<BLK_Y;y++ ){
		for( x=0;x<BLK_X;x++ ){
		    Pmap[y][x]=Score[y][x];
		    Pend+=Pmap[y][x];
		    /* Draw a wall */
		    if( !Side(BLOCK[y][x],G_T) )
				gv_line(xx0+x*S  ,yy0+y*S  ,xx0+x*S+S,yy0+y*S  ,0,0xFF);
		    if( !Side(BLOCK[y][x],G_B) )
				gv_line(xx0+x*S  ,yy0+y*S+S,xx0+x*S+S,yy0+y*S+S,0,0xFF);
		    if( !Side(BLOCK[y][x],G_R) )
				gv_line(xx0+x*S+S,yy0+y*S  ,xx0+x*S+S,yy0+y*S+S,0,0xFF);
		    if( !Side(BLOCK[y][x],G_L) )
				gv_line(xx0+x*S  ,yy0+y*S  ,xx0+x*S  ,yy0+y*S+S,0,0xFF);
		    /* draw feed */
		    gv_put(x0+x*S,y0+y*S,ENG[Score[y][x]],0);
		}
    }
}
void yubiSTART( int Pmode )
{
/* set a class and start a game */
    int Pacc,Prem;
    if( Pmode<=1 ){
		Pacc=2;
		Prem=40;
    }else if( Pmode<=2 ){
		Pacc=1;
		Prem=50;
    }else{
		Pacc=1;
		Prem=60;
    }
    yubiMAIN(Pmode,Pacc,Prem);
}
void yubiSCORE(int Pmode)
{
    int td=0,end=0;

	if( TD!=0 ) end=1;
    gv_kput(10,45,"score:",0,0,0);
    while( td!=TD ){
		gv_kput(50,45,itoa( Pgame*(td*(10+Pmode*30)+end*Pmode*1100),4),20,0,0);
		td++;
    }
    waitTM(0,1);
    Pscore=Pgame*(TD*(10+Pmode*30)+end*Pmode*1100);
    if( Hiscore<Pscore )
		Hiscore=Pscore;

    yubiCLASS(Pscore);

	/* Complete in capturing the final stage */
	if (Pgame==2&&Pmode==4) {
		cls(4);
		gv_kput( 2,4,"Congratulations",5,0,0);
	    waitTM(0,2);
		gv_kput( 4,20,"You've got a onHand ",6,0,0);
		gv_kput( 70,31,"callus?",6,0,0);
	    waitTM(0,2);
		gv_kput( 2,43,"From Master of",7,0,0);
		gv_kput( 60,53,"fingerist",7,0,0);
	    waitTM(0,3);
		cls(4);
		gv_kput(30,44,"Cherry presents",7,0,0);
	    waitTM(0,1);
		cls(4);
	}
}
void yubiCLASS(int score)
{
    char buff[128];
    gv_kput(0,15,"You are            ",5,0,0);
    gv_kput(0,30,"                   ",0,0,0);
    buff[1]='\0';

    if( score>12*(SCOREMAX/13) ){
		buff[0]=0x39; /* 9 */
		buff[1]=0x39; /* 9 */
		buff[2]='\0';
    }else if( score>10*(SCOREMAX/13) ){
		buff[0]=0x31; /* 1 */
		buff[1]=0x30; /* 0 */
		buff[2]='\0';
    }
    else if( score> 9*(SCOREMAX/13) ) buff[0]=0x39; /* 9 */
    else if( score> 8*(SCOREMAX/13) ) buff[0]=0x38; /* 8 */
    else if( score> 7*(SCOREMAX/13) ) buff[0]=0x37; /* 7 */
    else if( score> 6*(SCOREMAX/13) ) buff[0]=0x36; /* 6 */
    else if( score> 5*(SCOREMAX/13) ) buff[0]=0x35; /* 5 */
    else if( score> 4*(SCOREMAX/13) ) buff[0]=0x34; /* 4 */
    else if( score> 3*(SCOREMAX/13) ) buff[0]=0x33; /* 3 */
    else if( score> 2*(SCOREMAX/13) ) buff[0]=0x32; /* 2 */
    else if( score> 1*(SCOREMAX/13) ) buff[0]=0x31; /* 1 */
    else if( score>=0*(SCOREMAX/13) ) buff[0]=0x30; /* 0 */
    gv_kput(50,18,buff,59,0,0);

    waitTM(0,2);

}
#define SELover 4
int yubiOVER(int Pmode)
{
    int SEL;
    static char LISTover[SELover][20]={
		{"I cannot accept!"},
		{"  Upper class   "},
		{"  Lower class   "},
		{"  Stop it       "},
    };
    struct SELfunc St;
    St.LIST=LISTover;
 St.func=(void*)0;
 St.max=SELover;
 St.pre=0;
 St.mode=1;
	
    bi_clrbtn();
    cls(4);
    if( (SEL=Select_menu( St ))!=-1 ){
		if( SEL==3 )				return( -1 );
		else if( SEL==1&&Pmode<4 )	return( Pmode+1 );
		else if( SEL==2&&Pmode>0 )	return( Pmode-1 );
		else return(Pmode);
    }
    bi_clrbtn();
    return(-1);
}
void TimeDISP(void)
{
/* indication of left time */
    TD--;
    gv_kput(60,0,itoa(TD,2),9,1,0);
}

void TimeSTART(void)
{
/* starter display */
    char buff[128];
    buff[0]='0'+START;
    buff[1]='\0';
    gv_clear(151,28,164,47);
    gv_kput(154,30,buff,41,0,0);

    disp3D(154,30,164,47,-2,-2);

    START--;
}
