/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		onHand/Ruputer Sample Program									*/
/*		<<CalcTime>>     												*/
/*======================================================================*/

/*-----------------------------------------------------------*/
/*	 Leap Year Judgement									 */
/*-----------------------------------------------------------*/
/* Leap year:1 */
static int	checkLeapYear( int	yy )
{
	return (!(yy%4) && (yy%100) )|| !(yy%400 ) ? 1 : 0;
}
/*-----------------------------------------------------------*/
/*   Function to calculate a date and time after n minutes   */
/*-----------------------------------------------------------*/
void calcTime( int *yy, int *mm, int *dd, int *hour, int *min, int value )
{
	static int DAYLAST[12]={31,0,31,30,31,30,31,31,30,31,30,31};
	int CpuTime;
	int CalMin;

	CpuTime = (*hour)*60 + *min;
	CalMin= CpuTime + value;
	if( CalMin < 0 ){
		*hour = ( 1440 + CalMin )/60;
		*min =  ( 1440 + CalMin )%60;
		*dd -= 1;
		if( !*dd ){
			*mm -= 1;
			if( !*mm ){
				*yy -=  1;
				*mm  = 12;
				*dd	 = 31;
			}
			else{
				DAYLAST[1] = checkLeapYear( *yy )?29:28;
				*dd  = DAYLAST[ *mm-1 ];
			}
		}
	}
	else if( CalMin >= 1440 ){
		*hour = ( CalMin - 1440 )/60;
		*min  = ( CalMin - 1440 )%60;
		*dd += 1;
		DAYLAST[1] = checkLeapYear( *yy )?29:28;
		if( *dd > DAYLAST[ *mm-1 ] ){
			*dd  = 1;
			*mm += 1;
			if( *mm > 12 ){
				*yy += 1;
				*mm  = 1;
			}
		}
	}
	else{
		*hour = CalMin/60;
		*min  = CalMin%60;
	}
}
