/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		onHand/Ruputer Sample Program									*/
/*		<<CalcTime>>     												*/
/*======================================================================*/

#include "psdos.h"
#include "lcdbios.h"
#include "wbios.h"
#include "rupsys.h"
#include "ruptool.h"
#include "font.h"
#include "softkey.h"

/* Button condition define */
#define Key_file		0x0001		/*	swA(K0) key interruption	*/
#define Key_enter		0x0008		/*	swB(K3)key interruption		*/
#define Key_el			0x0004		/*	swC(K2) key interruption	*/
#define Key_menu		0x0002		/*	swD(K1)keuy interruption	*/
#define Key_left		0x0010		/*	swE(K4)key interruption		*/
#define Key_up			0x0020		/*	swF(K5)key interruption		*/
#define Key_right		0x0040		/*	swG(K6)key interruption		*/
#define Key_down		0x0080		/*	swH(K7)key interruptiojn	*/

static const RECT CLRLCD={0,0,101,63};

/*-----------------------------------------------------------*/
/*	 Convert a numeric value to ASCII code	      	 		 */
/*-----------------------------------------------------------*/
static void INTtoASC( char *p, int val, int keta, int sup )
{
	int i;

	for(i=keta-1;0<=i;i--){
		p[i]=val%10+0x30;
		if(i!=keta-1 && sup==1 && p[i]=='0')	p[i]=' ';
		val /= 10;
	}
}
/*-----------------------------------------------------------*/
/*	 Display operation after n minutes						 */
/*-----------------------------------------------------------*/
static void dispValue( int value )
{
	char val[10] = "+00000min";
	KANJI_PUT Valuekput = {{25,26},0,0,0,0};

	if( value < 0 ){
		val[0] = '-';
		value *= -1;
		INTtoASC((val+1),value,5,0);
	}
	else{
		val[0] = '+';
		INTtoASC((val+1),value,5,0);
	}
	Valuekput.str = val;
	pv_kput( (KANJI_PUT *)&Valuekput );
}
/*-----------------------------------------------------------*/
/*	 Time data display operation		      	 			 */
/*-----------------------------------------------------------*/
static void dispTimed( int yy, int mm, int dd, int hour, int min, int sel )
{
	char ymd[11] = "0000/00/00";
	char hm[6] = "00:00";
	KANJI_PUT Datekput = {{5,0},0,0,0,0};
	KANJI_PUT Timekput = {{5,13},0,0,0,0};

	INTtoASC((ymd+0),yy,4,0);
	INTtoASC((ymd+5),mm,2,1);
	INTtoASC((ymd+8),dd,2,1);
	INTtoASC((hm+0),hour,2,0);
	INTtoASC((hm+3),min,2,0);
	if( !sel ){
		Datekput.pos.y = 0;
		Timekput.pos.y = 13;
	}
	else{
		Datekput.pos.y = 39;
		Timekput.pos.y = 52;
	}
	Datekput.str = ymd;
	Timekput.str = hm;
	pv_kput( (KANJI_PUT *)&Datekput );
	pv_kput( (KANJI_PUT *)&Timekput );
}
/*-----------------------------------------------------------*/
/*	 Main					      	  						 */
/*-----------------------------------------------------------*/
int main(void)
{
	int bt;
	int ret;
	WatchDT Time;
	static int Val = 5;
	static int yy,mm,dd,hour,min;

	screen(1);					    /*	Graphic mode			    */
	gv_place(0,0);					/*	XY coordinates  X:0, Y:0	*/
	endWaiting();					/*	Stop startup animation.		*/
	while(1){
		lcdfreeze(1);
		pv_clear((RECT *)&CLRLCD);	/* Clear screen. */
		Time = *pSystemCtl->CPUram;		/* Obtian current time. */
		yy = Time.NOW_Year;
		mm = Time.NOW_Month;
		dd = Time.NOW_Day;
		hour = Time.NOW_Hour;
		min = Time.NOW_Min;
		dispTimed( yy,mm,dd,hour,min,0 );	    /* Display current time.                    */
		dispValue( Val );			            /* Display after n minutes                  */
		calcTime( &yy,&mm,&dd,&hour,&min,Val ); /* Obtain data and time after Value minutes */
		dispTimed( yy,mm,dd,hour,min,1 );	    /* Display time obtained                    */
		lcdfreeze(0);
		while(1){
			bt = Keyin( (Key_up|Key_down),-1 ); 
/* v Hereafter event processing other than Keyin button */
			ret = EventCall(bt);
			if(ret == -1) {
							/*request for end of application */
				dos_exit(0);
			}
			else if( ret == 1 ) {
				ret = EventExec();
				if (ret == -1) {
							/*request for end of application */
					dos_exit(0);
				}
				break;
			}
/* ^ up to here */
/* v from here event processing of button */
			if( bt&Key_menu ){
				dos_exit(0);
			}
			else if( bt&Key_up ){
				Val ++;
				yy = Time.NOW_Year;
				mm = Time.NOW_Month;
				dd = Time.NOW_Day;
				hour = Time.NOW_Hour;
				min = Time.NOW_Min;
				dispValue( Val );	                    /* display after what minutes               */
				calcTime( &yy,&mm,&dd,&hour,&min,Val ); /* Obtain date and time after Value minutes */
				dispTimed( yy,mm,dd,hour,min,1 );       /* Display time obtained                    */
			}
			else if( bt&Key_down ){
				Val --;
				yy = Time.NOW_Year;
				mm = Time.NOW_Month;
				dd = Time.NOW_Day;
				hour = Time.NOW_Hour;
				min = Time.NOW_Min;
				dispValue( Val );	                    /* display after what minutes               */
				calcTime( &yy,&mm,&dd,&hour,&min,Val ); /* Obtain date and time after Value minutes */
				dispTimed( yy,mm,dd,hour,min,1 );       /* display time obtained                    */
			}
		}
	}
}
/* ^ up to here */
