/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		onHand/Ruputer Sample Program									*/
/*		<<Digital Clock>>	   											*/
/*		Alarm Setting				 									*/
/*======================================================================*/

#include "string.h"
#include "psdos.h"
#include "lcdbios.h"
#include "wbios.h"
#include "rupsys.h"
#include "font.h"

/* Button condition define	*/
#define Key_file		0x0001		/*	swA(K0)key interruption	*/
#define Key_enter		0x0008		/*	swB(K3)key interruption	*/
#define Key_el			0x0004		/*	swC(K2)key interruption	*/
#define Key_menu		0x0002		/*	swD(K1)key interruption	*/
#define Key_left		0x0010		/*	swE(K4)key interruption	*/
#define Key_up			0x0020		/*	swF(K5)key interruption	*/
#define Key_right		0x0040		/*	swG(K6)key interruption */
#define Key_down		0x0080		/*	swH(K7)key interruption	*/

typedef struct{
	short DISPno;
	short Chaim;
	short ALmode[4];
	unsigned short ALweek[4];
}WATCH;
typedef struct{
	short hour;
	short min;
	short sec;
	short type;	/*	0:12h 1:24h	*/
}TIME;

static TIME alTM;
static WEEKLYTABLE ALdata[4];
static WATCH WTini;
static char Sndfile[32][9];
static TIME weekalTM;
static int sndMAX;
static int f_SOUSA;

const static RECT CLRLCD={0,0,101,63};
static KANJI_PUT AlarmModePut[]={
	{{72,0},"Off  ",5,0,0},
	{{72,0},"Day  ",5,0,0},
	{{72,0},"Week ",5,0,0}
};
static GVRAM_PUT MMPput[]={
	{{97,26},(char *)mmpRYAs,0},
	{{25,41},(char *)mmpWEEK_WAKU,0},
	{{0,53},(char *)mmpALARM,0}
};
/*-------------------------------------------------------------------*/
/*	Convert a numeric value into an ASCII code( use scosii code)	 */
/*-------------------------------------------------------------------*/
void INTtoASC(char *p,int val,int keta,int sup)
{
	int i;

	for(p[keta]='\0',i=keta-1;0<=i;i--){
		p[i]=val%10+0x30;
		if(i!=keta-1 && sup==1 && p[i]=='0')	p[i]='?';
		val /= 10;
	}
	return;
}
/*-----------------------------------------------------------*/
/*	 Display set time										 */
/*-----------------------------------------------------------*/
void dispSetTime(TIME *TM,KANJI_PUT *XY)
{
	int HourDATA;
	char buf[3];
	int fAMorPM=0;

	HourDATA=TM->hour;
	if( !(pSystemCtl->RupDefine->ClockType) ){/* Read hour-system of clock */
		if(HourDATA>12){/*	AMPMCheck_fAMorPM 1:PM  0:AM	*/
			HourDATA-=12;
			fAMorPM=1;
		}
		else if(HourDATA==12)	fAMorPM=1;
		else if(HourDATA==0)	HourDATA=12;
		if(fAMorPM)		XY[0].str=">=";/* PM */
		else			XY[0].str="<=";/* AM */
		pv_kput((KANJI_PUT *)&XY[0]);
	}
	INTtoASC(buf,HourDATA,2,1);
	XY[1].str=buf;
	pv_kput((KANJI_PUT *)&XY[1]);	/*display hour  */
	XY[2].str=":";
	pv_kput((KANJI_PUT *)&XY[2]);	/*:display      */
	INTtoASC(buf,TM->min,2,0);
	XY[3].str=buf;
	pv_kput((KANJI_PUT *)&XY[3]);	/*display minute*/
	return;
}
/*--------------------------------------------------------------*/
/*	 Obtain a sound file										*/
/*--------------------------------------------------------------*/
/*	The maximum number of SND files you can obtain is 32.	*/
static int GetSndFileName( char sndfile[32][9] )
{
	char DTA[44];
	int i,n;

	n =0;
	dos_setdta( DTA );		/*	Set DTA	*/
	if(!dos_fnd_first("B:\\SYSTEM\\SOUND\\*.snd",0x3f)){
		for( i = 31; DTA[i] && i < 39; i ++ ){
			 if( DTA[i] == '.' ) break;
		}
		strncpy( (char *)&sndfile[0], &DTA[31], i-31 );
		sndfile[0][i-31] = '\0';
		for( n=1; ( !dos_fnd_next() ) && n < 32; n++ ){
			for( i = 31; DTA[i] && i < 39; i ++ ){
				 if( DTA[i] == '.' ) break;
			}
			strncpy( (char *)&sndfile[n], &DTA[31], i-31 );
			sndfile[n][i-31] = '\0';
		}
	}
	return n;	/*	Return the number of obtained files	*/
}
/*-----------------------------------------------------------*/
/*	 Alarm sound demo									     */
/*-----------------------------------------------------------*/
static unsigned int Melody[256];
static void alsoundDEMO( char *snd )
{
	long ms;
	int fp;
	char rFile[30] = SOUNDPATH;

	if( CheckVol() ){/* voltage check in advance */
		dispVOLerr();
		dos_exit(0);
	}
	memset( &Melody, 0, sizeof( Melody ) );
	strcat( rFile, snd );
	strcat( rFile, ".SND" );
	if( ( fp = dos_fopen( rFile, 0 ) ) == -1 ) return;
	ms = dos_fseek( fp, 2, 0 );
	if( ms > 512 ) ms = 512;
	dos_fseek( fp, 0, 0 );
	dos_fread( fp, (char *)Melody, (int)ms );
	Melody[255] = 0xffff;/* compatible with sound having size of 512byte or greater */
	dos_fclose( fp );
	bi_canmelody();/* Mute */
	memcpy( pSystemCtl->MelodyPlay, Melody, ms );
	bi_buzzinit( pSystemCtl->MelodyPlay[0], pSystemCtl->MelodyPlay[1] );
	bi_melody( &pSystemCtl->MelodyPlay[2] );
	return;
}
/*-----------------------------------------------------------*/
/*	 Display Weekly mark								     */
/*-----------------------------------------------------------*/
static void disp_ALmark(int DT,int Mode)
{
	const GVRAM_PUT GARA[]={
		{{0,26},(char *)mmpGARA,3},
		{{0,39},(char *)mmpGARA,3},
		{{0,52},(char *)mmpGARA,3}
	};
	RECT CLRmmp={0,52,0,62};
	int k,i;

	switch(Mode){	/* display weekly alarm mark  */
		case 0:	/* OFF  */
			for(i=0;i<7;i++){
				CLRmmp.x1=26+i*10;
				CLRmmp.x2=33+i*10;
				pv_clear((RECT *)&CLRmmp);
			}
			for(i=0;i<3;i++){
				pv_put((GVRAM_PUT *)&GARA[i]);	/*	item shading of being disabled	*/
				gv_line(0,51,101,51,3,0xaa);
			}
			break;
		case 1:	/* DAILY  */
			for(i=0;i<7;i++){
				MMPput[2].pos.x=27+i*10;
				pv_put((GVRAM_PUT *)&MMPput[2]);/*display weekly alarm mark*/
			}
			break;
		case 2:	/* WEEKLY	*/
			for(i=0,k=0x01;i<7;i++,k*=2){
				if(!(DT&k)){/*off*/
					CLRmmp.x1=26+i*10;
					CLRmmp.x2=33+i*10;
					pv_clear((RECT *)&CLRmmp);
				}
				else{		/*on*/
					MMPput[2].pos.x=27+i*10;
					pv_put((GVRAM_PUT *)&MMPput[2]);/*display weekly alarm mark*/
				}
			}
	}
	return;
}
/*-----------------------------------------------------------*/
/*	Display arrows											 */
/*-----------------------------------------------------------*/
static void dispYA(int csr,int Mode)
{
	SIICODE_PUT YAput[]={
		{{13,13},0,0},/* First column arrow coordinate  */
		{{13,26},0,0},/* Second column arrow coordinate */
		{{13,52},0,0} /* Third column arrow coordinate  */
	};

	if(0<=csr && csr<=3){		/*	Cursor is positioned on the first column	*/
		if(csr==0)		YAput[0].code=picRYAB;
		else			YAput[0].code=picLYAB;	/*$$*/
		pv_sput((SIICODE_PUT *)&YAput[0]);
		YAput[1].code=picRYAW;					/*$*/
		pv_sput((SIICODE_PUT *)&YAput[1]);
		if(Mode==2){/* WEEKLY */
			YAput[2].code=picRYAW;				/*$*/
			pv_sput((SIICODE_PUT *)&YAput[2]);
		}
		else{
	 		gv_kput(0,52,"    ",0,0,0);
		}
	}
	else if(4<=csr && csr<=5){	/*	Cursor is placed on the second column 	*/
		YAput[0].code=picRYAW;					/*$*/
		pv_sput((SIICODE_PUT *)&YAput[0]);
		if(csr==4)		YAput[1].code=picRYAB;
		else			YAput[1].code=picLYAB;	/*$$*/
		pv_sput((SIICODE_PUT *)&YAput[1]);
		if(Mode==2){/* WEEKLY */
			YAput[2].code=picRYAW;				/*$*/
			pv_sput((SIICODE_PUT *)&YAput[2]);
		}
	}
	else if(6<=csr){			/*	Cursor is placed on the third column	*/
		YAput[0].code=picRYAW;					/*$*/
		pv_sput((SIICODE_PUT *)&YAput[0]);
		YAput[1].code=picRYAW;					/*$*/
		pv_sput((SIICODE_PUT *)&YAput[1]);
		if(Mode==2){/* WEEKLY */
			if(csr==6)	YAput[2].code=picRYAB;
			else		YAput[2].code=picLYAB;	/*$$*/
			pv_sput((SIICODE_PUT *)&YAput[2]);
		}
	}
	return;
}
/*-----------------------------------------------------------*/
/*	 Set details of alarm									 */
/*-----------------------------------------------------------*/
static char *ALMENU[]={
		"Alarm1ch",
		"Alarm2ch",
		"Alarm3ch",
		"Alarm4ch",
};
static const char *SndFileErr[]={"  Set","  sound file","  does not exist"};
static const char *SndNoFileErr[]={" Sound file"," does not exist"};
void weeklyal( int csr )
{
	WEEKLYTABLE ALdataAL;
	WATCH WTiniAL;
	static int BLINK_no[14];
	int ALCH=csr/4;
	int	bt,ret;
	int cansel;
	int i,k;
	int weekcsr;
	int sndNo;
	int f_SOUSAL;
	int REPkey=(Key_up|Key_down);
	const BLINK_DRAW alBLINK[]={
		{{1,13, 12,24},0x00a0},	/*	Icon 1	*/
		{{39,13, 49,24},0x00a0},/*	Hour	*/
		{{57,13, 67,24},0x00a0},/*	minute	*/
		{{72,13, 94,24},0x00a0},/*	mode    */
		{{ 1,26, 12,37},0x00a0},/*	icon 2	*/
		{{25,26,75,37},0x00a0},	/*	sound	*/
		{{ 1,52, 12,63},0x00a0},/*	icon 3	*/
		{{26,42, 34,50},0x00a0},/*	weekly Monday	*/
		{{36,42, 44,50},0x00a0},/*	weekly Tuesday 	*/
		{{46,42, 54,50},0x00a0},/*	weekly Wednesday*/
		{{56,42, 64,50},0x00a0},/*	weekly Thursday	*/
		{{66,42, 74,50},0x00a0},/*	weekly Friday	*/
		{{76,42, 84,50},0x00a0},/*	weekly Saturday	*/
		{{86,42, 94,50},0x00a0}	/*	weekly Sunday	*/
	};
	const SIICODE_PUT PICput[]={
		{{1,13},picCLOCK,0},
		{{1,26},picMELODY2,0},
		{{1,52},picWEEKLY,0},
		{{86,26},picMELODY,0}
	};
	SIICODE_PUT YAput[]={
		{{13,13},picRYAB,0},
		{{13,13},picLYAB,0},
	};
	const KANJI_PUT AlarmModePut[]={
		{{72,13},"Off  ",5,0,0},
		{{72,13},"Day  ",5,0,0},
		{{72,13},"Week ",5,0,0}
	};
	KANJI_PUT dispALTIME[]={
		{{25,17},0,12,1,0},		/*	AM/PM	*/
		{{39,14},0,19,1,0},		/*	hour	*/
		{{51,14},0,19,1,0},		/*	:	    */
		{{57,14},0,19,1,0},		/*	minute	*/
	};
	KANJI_PUT SNDname[]={
		{{25,26},0,0,0,0},
		{{25,26},"NO     ",0,0,0},
		{{25,26},"       ",0,0,0}
	};
	int SndFileOK;

	f_SOUSAL = 0;
	weekcsr = 0;
	WTiniAL = WTini;
	ALdataAL = ALdata[ALCH];
	if( ALdataAL.snd[0] ){
		SndFileOK = 0;
		for( i = 0; i < sndMAX; i ++ ){
			if( !strncmp( Sndfile[i], ALdataAL.snd, 8 ) ){
				sndNo = i;
				SndFileOK = 1;
				break;
			}
		}
		if( !SndFileOK ){/* no set sound file can be found */
			if( WTiniAL.ALmode[ALCH] ){
				if( dispMess( (char **)SndFileErr, 3 )==-1 )	dos_exit(0);
			}
			/* Forcibly turn alarm OFF */
			ALdataAL.snd[0] = '\0';
			sndNo = 0;
			WTiniAL.ALmode[ALCH] = 0;
			f_SOUSAL = 1;
		}
	}
	else{/* alarm not set */
		sndNo = 0;
	}
	while(1){
		pv_clear((RECT *)&CLRLCD);
		lcdfreeze(1);
		for(i=0;i<14;i++){
			BLINK_no[i]=pblink((BLINK_DRAW *)&alBLINK[i]);
			blstop(BLINK_no[i]);
		}
		dispTitle(ALMENU[ALCH]);
		for(i=0;i<4;i++){
			pv_sput((SIICODE_PUT *)&PICput[i]);
		}
		pv_put((GVRAM_PUT *)&MMPput[0]);	 /*	right small arrow   */
		dispYA(weekcsr,WTiniAL.ALmode[ALCH]);/* arrow icon  display */
		weekalTM.hour=ALdataAL.hour;
		weekalTM.min=ALdataAL.min;
		dispSetTime(&weekalTM,(KANJI_PUT *)&dispALTIME);/*time display*/
		pv_kput((KANJI_PUT *)&AlarmModePut[WTiniAL.ALmode[ALCH]]);
		pv_put((GVRAM_PUT *)&MMPput[1]);	/* weekly data display */
		if( sndMAX ){
			SNDname[0].str=Sndfile[sndNo];
			pv_kput((KANJI_PUT *)&SNDname[0]);/*sound file display*/
		}
		else	pv_kput((KANJI_PUT *)&SNDname[1]);	/*no sound file*/
		disp_ALmark(WTiniAL.ALweek[ALCH],WTiniAL.ALmode[ALCH]);
											/* weekly alarm mark display  */
		lcdfreeze(0);
		blstart(BLINK_no[weekcsr]);

		while(1){
			bt=Keyin(REPkey,BLINK_no[weekcsr]);
//			bt&=~Key_file;
			ret = EventCall(bt);
			if (ret == -1) {
				/* request for end of application */
				for( i=0;i<14;i++ )		blend(BLINK_no[i]);/*	blink release	*/
				dos_exit(1);
			}
			else if (ret == 1) {
				for( i=0;i<14;i++ )		blend(BLINK_no[i]);/*	blink lifting	*/
				ret = EventExec();
				if (ret == -1) {
					/* request for end of application */
					dos_exit(1);
				}
				break;
			}
			if(bt==Key_enter){
				if(weekcsr==0||weekcsr==4||weekcsr==6){
					for( i=0;i<14;i++ )		blend(BLINK_no[i]);/*	blink releae	*/
					WTini = WTiniAL;
					ALdata[ALCH] = ALdataAL;
					f_SOUSA |= f_SOUSAL;
					return;
				}
				else{
					blstop(BLINK_no[weekcsr]);
					if(0<weekcsr&&weekcsr<4)		weekcsr=0;
					else if(weekcsr==5)				weekcsr=4;
					else if(6<weekcsr)				weekcsr=6;
					if(WTiniAL.ALmode[ALCH]==0 && weekcsr==0){
						pv_sput((SIICODE_PUT *)&YAput[0]);
					}
					else dispYA(weekcsr,WTiniAL.ALmode[ALCH]);/*  arrow icon display*/
					blstart(BLINK_no[weekcsr]);
				}
			}
			else if(bt==Key_menu ||(bt==Key_left &&( weekcsr==0||weekcsr==4||weekcsr==6))){
				for( i=0;i<14;i++ )		blend(BLINK_no[i]);/*	blink release	*/
				if(	f_SOUSAL ){
					cansel=dispCancelYN();			/*	check if setting has been cancelled	*/
					if( cansel == -1 ) 	dos_exit(0);
					if( cansel )		break;		/*	If cancel NO, recover	*/
				}
				return;
			}
			else if(bt==Key_up){
				if(weekcsr==4||weekcsr==6){	/*if cursor is placed on the icon position*/
					blstop(BLINK_no[weekcsr]);
					if(weekcsr==6)	weekcsr=4;
					else			weekcsr=0;
					dispYA(weekcsr,WTiniAL.ALmode[ALCH]);/*  arrow icon display*/
					blstart(BLINK_no[weekcsr]);
				}
				else if(weekcsr==1){/*	if cursor is placed on time position*/
					f_SOUSAL = 1;
					ALdataAL.hour++;
					if(ALdataAL.hour>=24)		ALdataAL.hour=0;
					weekalTM.hour=ALdataAL.hour;
					dispSetTime(&weekalTM,(KANJI_PUT *)&dispALTIME);
				}
				else if(weekcsr==2){/* if cursor is placed on minute position */
					f_SOUSAL = 1;
					ALdataAL.min++;
					if(ALdataAL.min>=60)		ALdataAL.min=0;
					weekalTM.min=ALdataAL.min;
					dispSetTime(&weekalTM,(KANJI_PUT *)&dispALTIME);
				}
				else if(weekcsr==3 && sndMAX){
					/*if cursor is placed on alarm mode set position*/
					f_SOUSAL = 1;
					WTiniAL.ALmode[ALCH]++;
					if(WTiniAL.ALmode[ALCH]>2)	WTiniAL.ALmode[ALCH]=0;
					lcdfreeze(1);
					for(i=0;i<4;i++){
						pv_sput((SIICODE_PUT *)&PICput[i]);
					}
					pv_put((GVRAM_PUT *)&MMPput[0]);	 /*	right small arrow display	*/
					dispYA(weekcsr,WTiniAL.ALmode[ALCH]);/*  arrow icon display         */
					pv_kput((KANJI_PUT *)&AlarmModePut[WTiniAL.ALmode[ALCH]]);
					if(WTiniAL.ALmode[ALCH]==1){
						pv_put((GVRAM_PUT *)&MMPput[1]); /* weekly set */
						strncpy(ALdataAL.snd,Sndfile[sndNo],8);
						SNDname[0].str = Sndfile[sndNo];
						pv_kput((KANJI_PUT *)&SNDname[2]);
						pv_kput((KANJI_PUT *)&SNDname[0]);
					}
					/* weekly alarm mark display  */
					disp_ALmark(WTiniAL.ALweek[ALCH],WTiniAL.ALmode[ALCH]);
					lcdfreeze(0);
				}
				else if(weekcsr==5 && sndMAX){
					/*	If cursor is placed on alarm sound position	*/
					f_SOUSAL=1;
					sndNo++;
					if(sndNo>=sndMAX)	sndNo=0;
					strncpy(ALdataAL.snd,Sndfile[sndNo],8);
					SNDname[0].str = Sndfile[sndNo];
					pv_kput((KANJI_PUT *)&SNDname[2]);
					pv_kput((KANJI_PUT *)&SNDname[0]);
				}
				else if(7<=weekcsr && weekcsr<=13){	
					/*if cursor is placed on weekly setting	*/
					f_SOUSAL=1;
					for(i=0,k=0x01;i<(weekcsr-7);i++){
							k*=2;
					}
					WTiniAL.ALweek[ALCH] ^= k;
					/* weekly alarm mark display  */
					disp_ALmark(WTiniAL.ALweek[ALCH],WTiniAL.ALmode[ALCH]);
				}
			}
			else if( bt==Key_down ){
				if(weekcsr==0 || weekcsr==4){
					/*if cursor is placed on icon position*/
					if( WTiniAL.ALmode[ALCH]==2 
						|| (WTiniAL.ALmode[ALCH]==1 && weekcsr==0) ){
						blstop(BLINK_no[weekcsr]);
						if(weekcsr==0)	weekcsr=4;
						else			weekcsr=6;
						dispYA(weekcsr,WTiniAL.ALmode[ALCH]);
										/*	arrow icon display	*/
						blstart(BLINK_no[weekcsr]);
					}
				}
				else if(weekcsr==1){/*	if cursor is placed on time position */
					f_SOUSAL=1;
					if(!ALdataAL.hour)	ALdataAL.hour=23;
					else				ALdataAL.hour--;
					weekalTM.hour=ALdataAL.hour;
					dispSetTime(&weekalTM,(KANJI_PUT *)&dispALTIME);
				}
				else if(weekcsr==2){/*	if cursor is placed on minute position */
					f_SOUSAL=1;
					if(!ALdataAL.min)	ALdataAL.min=59;
					else				ALdataAL.min--;
					weekalTM.min=ALdataAL.min;
					dispSetTime(&weekalTM,(KANJI_PUT *)&dispALTIME);
				}
				else if(weekcsr==3 && sndMAX){
					/*	if cursor is placed on alarm mode set	*/
					f_SOUSAL=1;
					WTiniAL.ALmode[ALCH]--;
					if(WTiniAL.ALmode[ALCH]<0)	WTiniAL.ALmode[ALCH]=2;
					lcdfreeze(1);
					for(i=0;i<4;i++){
						pv_sput((SIICODE_PUT *)&PICput[i]);
					}
					pv_put((GVRAM_PUT *)&MMPput[0]);	 /*	right arrow display	*/
					dispYA(weekcsr,WTiniAL.ALmode[ALCH]);/*  arrow icon display */
					pv_kput((KANJI_PUT *)&AlarmModePut[WTiniAL.ALmode[ALCH]]);
														 /* mode display */
					if(WTiniAL.ALmode[ALCH]==2){
						pv_put((GVRAM_PUT *)&MMPput[1]); /* weekly table display */
						strncpy(ALdataAL.snd,Sndfile[sndNo],8);
						SNDname[0].str = Sndfile[sndNo];
						pv_kput((KANJI_PUT *)&SNDname[2]);
						pv_kput((KANJI_PUT *)&SNDname[0]);/* sound file name */
					}
					disp_ALmark(WTiniAL.ALweek[ALCH],WTiniAL.ALmode[ALCH]);
													/* weekly alarm mark display  */
					lcdfreeze(0);
				}
				else if(weekcsr==5 && sndMAX){
					/*	if cursor is placed on alarm sound position	*/
					f_SOUSAL=1;
					sndNo--;
					if(sndNo<0)	sndNo=sndMAX-1;
					strncpy(ALdataAL.snd,Sndfile[sndNo],8);
					SNDname[0].str = Sndfile[sndNo];
					pv_kput((KANJI_PUT *)&SNDname[2]);
					pv_kput((KANJI_PUT *)&SNDname[0]);
				}
				else if(7<=weekcsr && weekcsr<=13){	
					/*if cursor is placed on weekly set position */
					f_SOUSAL=1;
					for(i=0,k=0x01;i<(weekcsr-7);i++){
							k*=2;
					}
					WTiniAL.ALweek[ALCH] ^= k;
					/* weekly alarm mark display  */
					disp_ALmark(WTiniAL.ALweek[ALCH],WTiniAL.ALmode[ALCH]);
				}
			}
			else if(bt==Key_left && weekcsr!=0 && weekcsr!=4 && weekcsr!=6){
				blstop(BLINK_no[weekcsr]);
				weekcsr--;
				blstart(BLINK_no[weekcsr]);
				if(weekcsr==0 || weekcsr==4 || weekcsr==6)
											REPkey=0;
				else if(weekcsr==2)			REPkey=(Key_up|Key_down);
				if(WTiniAL.ALmode[ALCH]==0){
					if(weekcsr==0)	pv_sput((SIICODE_PUT *)&YAput[0]);
					else			pv_sput((SIICODE_PUT *)&YAput[1]);
				}
				else	dispYA(weekcsr,WTiniAL.ALmode[ALCH]);
											/*  arrow icon display*/
			}
			else if(bt==Key_right && weekcsr!=3 && weekcsr!= 13){
				if(!(WTiniAL.ALmode[ALCH]==1 && weekcsr==6)){
					if(weekcsr==5){
						blstop(BLINK_no[weekcsr]);
						alsoundDEMO((char *)&Sndfile[sndNo]);
												/*	sound demo	*/
						blstart(BLINK_no[weekcsr]);
						REPkey=0;
					}
					else{
						blstop(BLINK_no[weekcsr]);
						weekcsr++;
						blstart(BLINK_no[weekcsr]);
						if(weekcsr==3 )		REPkey=0;
						else if(weekcsr==1 || weekcsr==5 )	
											REPkey=(Key_up|Key_down);
						if(WTiniAL.ALmode[ALCH]==0){
							pv_sput((SIICODE_PUT *)&YAput[1]);
						}
						else	dispYA(weekcsr,WTiniAL.ALmode[ALCH]);
											/*  arrow icon display*/
					}
				}
			}
		}
	}
}
/*-----------------------------------------------------------*/
/*	 Alarm setting				  	                         */
/*-----------------------------------------------------------*/
int alarm(void)
{
	int BLINK_no[16];
	int	bt,ret;
	int cansel;
	int i;
	int csr;
	int REPkey=(Key_up|Key_down);
	int fp;
	const BLINK_DRAW alBLINK[]={
		{{ 1,12,13,25},0x00a0},	/*icon  */
		{{39,12,49,25},0x00a0},	/*hour  */
		{{57,12,68,25},0x00a0},	/*minute*/
		{{72,12,94,25},0x00a0},	/*mode  */
		{{ 1,25,13,38},0x00a0},	/*icon  */
		{{39,25,49,38},0x00a0},	/*hour  */
		{{57,25,68,38},0x00a0},	/*minute*/
		{{72,25,94,38},0x00a0},	/*mode  */
		{{ 1,38,13,51},0x00a0},	/*icon  */
		{{39,38,49,51},0x00a0},	/*hour  */
		{{57,38,68,51},0x00a0},	/*minute*/
		{{72,38,94,51},0x00a0},	/*mode  */
		{{ 1,51,13,64},0x00a0},	/*icon  */
		{{39,51,49,64},0x00a0},	/*hour  */
		{{57,51,68,64},0x00a0},	/*minute*/
		{{72,51,94,64},0x00a0},	/*mode  */
	};
	const SIICODE_PUT PICput[]={
		{{1,13},picAL1,0},
		{{1,26},picAL2,0},
		{{1,39},picAL3,0},
		{{1,52},picAL4,0}
	};
	SIICODE_PUT YAput[]={
		{{13,13},0,0},
		{{13,26},0,0},
		{{13,39},0,0},
		{{13,52},0,0}
	};
	KANJI_PUT dispALTIME[]={
			{{25,0},0,12,1,0},		/*	AM/PM	*/
			{{39,0},0,19,1,0},		/*	hour	*/
			{{51,0},0,19,1,0},		/*	:	    */
			{{57,0},0,19,1,0},		/*	minute	*/
	};
	GVRAM_PUT MMPput={{97,0},(char *)mmpRYAs,0};

	f_SOUSA = 0;
	csr = 0;
	/*	weekly alarm data read of WEEKLY.INI	*/
	fp=dos_fopen( WEEKLYALARM, 0 );
	if( fp==-2 ){/* abnormal voltage */
		dispVOLerr();
		dos_exit(0);
	}
	dos_fread(fp,(char *)&ALdata,(int)(sizeof(WEEKLYTABLE)*4));
	dos_fread(fp,(char *)&WTini,sizeof(WATCH));
	dos_fclose(fp);
	memset( Sndfile, 0 ,sizeof(Sndfile) );
	sndMAX = GetSndFileName( Sndfile );/* obtain alarm sound file */
	if( !sndMAX ){/* no sound file is found */
		if( dispMess( (char **)SndNoFileErr, 2 )==-1 )	dos_exit(0);
		return(0);
	}

	while(1){
		pv_clear((RECT *)&CLRLCD);
		lcdfreeze(1);
		for(i=0;i<16;i++){
			BLINK_no[i]=pblink((BLINK_DRAW *)&alBLINK[i]);
			blstop(BLINK_no[i]);
		}
		for(i=0;i<4;i++){/* initial screen display */
			pv_sput((SIICODE_PUT *)&PICput[i]);
			if(csr==i*4)						YAput[i].code=picRYAB;
			else if((i*4<csr)&&(csr<=i*4+3))	YAput[i].code=picLYAB;
			else								YAput[i].code=picRYAW;
			pv_sput((SIICODE_PUT *)&YAput[i]);
			alTM.hour=ALdata[i].hour;
			alTM.min=ALdata[i].min;
			dispALTIME[0].pos.y=17+13*i;
			dispALTIME[1].pos.y=14+13*i;
			dispALTIME[2].pos.y=14+13*i;
			dispALTIME[3].pos.y=14+13*i;
			dispSetTime(&alTM,(KANJI_PUT *)&dispALTIME);
			AlarmModePut[WTini.ALmode[i]].pos.y=13+13*i;
			pv_kput((KANJI_PUT *)&AlarmModePut[WTini.ALmode[i]]);
			MMPput.pos.y=13+13*i;
			pv_put((GVRAM_PUT *)&MMPput);/* right small arrow display  */
		}
		dispTitle("Alarm");
		lcdfreeze(0);
		blstart(BLINK_no[csr]);

		while(1){
			bt=Keyin(REPkey,BLINK_no[csr]);
//			bt&=~Key_file;/* override a filer key */
			ret = EventCall(bt);
			if (ret == -1) {
				for(i=0;i<16;i++)	blend(BLINK_no[i]);/*	BLINK release	*/
				dos_exit(1);/* request for end of application */
			}
			else if (ret == 1) {
				for(i=0;i<16;i++)	blend(BLINK_no[i]);/*	BLINK release	*/
				ret = EventExec();
				if (ret == -1) {
					dos_exit(1);/* request for end of application */
				}
				break;
			}
			if(bt==Key_enter){
				if(0<(csr%4)){	/*	if cursor is placed somewher else than icon position	*/
					blstop(BLINK_no[csr]);
					csr=(csr/4)*4;
					blstart(BLINK_no[csr]);
					YAput[csr/4].code=picRYAB;
					pv_sput((SIICODE_PUT *)&YAput[csr/4]);
				}
				else{
					for(i=0;i<16;i++)	blend(BLINK_no[i]);/*	BLINK relase	*/
					if(!f_SOUSA)	return(0);
					dispMessBar("Updating");
					for(i=0;i<4;i++){
						switch(WTini.ALmode[i]){
							case 0: ALdata[i].week=0;				/*OFF	*/
									break;
							case 1: ALdata[i].week=0xff;			/*DAILY	*/
									break;
							case 2: ALdata[i].week=WTini.ALweek[i];	/*WEEKLY*/
						}
					}
					if((fp=dos_fopen( WEEKLYALARM, 1 ))==-1){
						/* assume that there is no WEEKLY.INI */
						fp = dos_fcreate( WEEKLYALARM );
					}
					else if( fp==-2 ){/* abnormal voltage */
						dispVOLerr();
						dos_exit(0);
					}
					dos_fwrite(fp,(char *)&ALdata,(int)(sizeof(WEEKLYTABLE)*4));
					dos_fwrite(fp,(char *)&WTini,(int)(sizeof(WATCH)));
					dos_fclose(fp);
					bi_vwrflush();
					setWeeklyAlarm();
					endMessBar();
					return(-1);
				}
			}
			else if(bt==Key_menu ||(bt==Key_left && csr%4==0)){
				for(i=0;i<16;i++)	blend(BLINK_no[i]);/*	BLINK release	*/
				if(f_SOUSA){
					cansel=dispCancelYN();			/*	check if setting has been cancelled	*/
					if( cansel == -1 ) dos_exit(0);
					if(cansel)	break;			/*	If cancel NO, recover	*/
				}
				return(0);
			}
			else if(bt==Key_up){
				if(csr!=0 && csr%4==0){/*if cursor is placed on icon position*/
					blstop(BLINK_no[csr]);
					YAput[csr/4].code=picRYAW;
					pv_sput((SIICODE_PUT *)&YAput[csr/4]);
					csr-=4;
					YAput[csr/4].code=picRYAB;
					pv_sput((SIICODE_PUT *)&YAput[csr/4]);
					blstart(BLINK_no[csr]);
				}
				else if(csr%4==1){/* if cursor is placed in position at alarm time */
					f_SOUSA=1;
					ALdata[csr/4].hour++;
					if(ALdata[csr/4].hour>=24)		ALdata[csr/4].hour=0;
					alTM.hour=ALdata[csr/4].hour;
					alTM.min=ALdata[csr/4].min;
					dispALTIME[0].pos.y=17+13*(csr/4);
					dispALTIME[1].pos.y=14+13*(csr/4);
					dispALTIME[2].pos.y=14+13*(csr/4);
					dispALTIME[3].pos.y=14+13*(csr/4);
					dispSetTime(&alTM,(KANJI_PUT *)&dispALTIME);
				}
				else if(csr%4==2){/*if cursor is placed in position of alarm minute*/
					f_SOUSA=1;
					ALdata[csr/4].min++;
					if(ALdata[csr/4].min>=60)		ALdata[csr/4].min=0;
					alTM.hour=ALdata[csr/4].hour;
					alTM.min=ALdata[csr/4].min;
					dispALTIME[0].pos.y=17+13*(csr/4);
					dispALTIME[1].pos.y=14+13*(csr/4);
					dispALTIME[2].pos.y=14+13*(csr/4);
					dispALTIME[3].pos.y=14+13*(csr/4);
					dispSetTime(&alTM,(KANJI_PUT *)&dispALTIME);
				}
				else if(csr%4==3){/* If cursor is placed in position of alarm mode set */
					f_SOUSA=1;
					WTini.ALmode[csr/4]+=1;
					if(WTini.ALmode[csr/4]>2)	WTini.ALmode[csr/4]=0;
					if( !ALdata[csr/4].snd[0] && sndMAX ){
						strncpy( ALdata[csr/4].snd, (char *)&Sndfile[0],8);
					}
					AlarmModePut[WTini.ALmode[csr/4]].pos.y=13+13*(csr/4);
					pv_kput((KANJI_PUT *)&AlarmModePut[WTini.ALmode[csr/4]]);
				}
			}
			else if(bt==Key_down){/* if cursor is placed on icon position */
				if(csr%4==0 && csr!=12){
					blstop(BLINK_no[csr]);
					YAput[csr/4].code=picRYAW;
					pv_sput((SIICODE_PUT *)&YAput[csr/4]);
					csr+=4;
					YAput[csr/4].code=picRYAB;
					pv_sput((SIICODE_PUT *)&YAput[csr/4]);
					blstart(BLINK_no[csr]);
				}
				else if(csr%4==1){/* if cursor is placed I position of alarm time */
					f_SOUSA=1;
					if(!ALdata[csr/4].hour)	ALdata[csr/4].hour=23;
					else					ALdata[csr/4].hour--;
					alTM.hour=ALdata[csr/4].hour;
					alTM.min=ALdata[csr/4].min;
					dispALTIME[0].pos.y=17+13*(csr/4);
					dispALTIME[1].pos.y=14+13*(csr/4);
					dispALTIME[2].pos.y=14+13*(csr/4);
					dispALTIME[3].pos.y=14+13*(csr/4);
					dispSetTime(&alTM,(KANJI_PUT *)&dispALTIME);
				}
				else if(csr%4==2){/* if cursor is placed in position of alarm minute */
					f_SOUSA=1;
					if(!ALdata[csr/4].min)		ALdata[csr/4].min=59;
					else						ALdata[csr/4].min--;
					alTM.hour=ALdata[csr/4].hour;
					alTM.min=ALdata[csr/4].min;
					dispALTIME[0].pos.y=17+13*(csr/4);
					dispALTIME[1].pos.y=14+13*(csr/4);
					dispALTIME[2].pos.y=14+13*(csr/4);
					dispALTIME[3].pos.y=14+13*(csr/4);
					dispSetTime(&alTM,(KANJI_PUT *)&dispALTIME);
				}
				else if(csr%4==3){/* if alarm is placed in alarm mode set position */
					f_SOUSA=1;
					WTini.ALmode[csr/4]-=1;
					if(WTini.ALmode[csr/4]<0)	WTini.ALmode[csr/4]=2;
					if( !ALdata[csr/4].snd[0] && sndMAX ){
						strncpy( ALdata[csr/4].snd, (char *)&Sndfile[0],8);
					}
					AlarmModePut[WTini.ALmode[csr/4]].pos.y=13+13*(csr/4);
					pv_kput((KANJI_PUT *)&AlarmModePut[WTini.ALmode[csr/4]]);
				}
			}
			else if(bt==Key_right){
				if(csr%4==3){/* if cursor is placed in alarm mode set position */
					for(i=0;i<16;i++)	blend(BLINK_no[i]);		/*	BLINK release	*/
					weeklyal(csr);
									/*	detailed alarm setting	*/
					csr=(csr/4)*4;
					break;
				}
				else{
					blstop(BLINK_no[csr]);
					csr++;
					if(csr%4==1 || csr%4==2)	REPkey=(Key_up|Key_down);
					else						REPkey=0;
					blstart(BLINK_no[csr]);
					if(csr%4==1){/* if cursor moves to a position at alarm time */
						YAput[csr/4].code=picLYAB;
						pv_sput((SIICODE_PUT *)&YAput[csr/4]);
					}
				}
			}
			else if(bt==Key_left && csr%4!=0){
				blstop(BLINK_no[csr]);
				csr--;
				if(csr%4==1 || csr%4==2)	REPkey=(Key_up|Key_down);
				else						REPkey=0;
				blstart(BLINK_no[csr]);
				if(csr%4==0){/* if cursor moves to a position of alarm icon */
					YAput[csr/4].code=picRYAB;
					pv_sput((SIICODE_PUT *)&YAput[csr/4]);
				}
			}
		}
	}
}







