/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		AD2COM2 Battery condition										*/
/*		RS-232C version        											*/
/*======================================================================*/

#include<stdio.h>	/* C Language standard library sprintf */
#include<string.h>	/* C Language standard library strcpy  */

#include"wbios.h"
#include"psdos.h"
#include"lcdbios.h"
#include"rupsys.h"	/* onHand/Ruputer header Bkey_** key */


/* Prototype declaration of functions used for MAIN.C */
void PwreadProc(void);			/* The body is located under main() */
void ComProc(int);				/* The body is located under main() */
void MessSend(char*,int);		/* The body is located under main() */

int main(void)
{
    screen(1);

	cls(4);
	gv_kput(10,10,"Mount ",5,0,0);
	gv_kput(10,22," on station",5,0,0);

	while( !(bi_getbtn()&Bkey_SH) ){
		if (bi_scanbtn()&Bkey_D) return;
	}	/* Waiting to be connected to a Rs-232c cable  */
	cls(4);

	/* Communication & key operation */
	ComProc(3);	/* Baud rate 3: 38.4kbps Can be changed by this argument */
	lcdon(1);

    while( !(bi_getbtn()&Bkey_D) ){}	/* Exit with the Menu key */

	gv_place(0,0);
	cls(4);						/* GVRAM clear */
    gv_kput(0,2,"Application",5,0,0);
    gv_kput(30,40,"exits.",5,0,0);
    cls(4);
}

void ComProc(int Bps)
{
	/* Bps:Can be set only for baud rate */
	const int Dev=2;	/* RS-232C */
	const int Pulse=0;	/* Infrared light-emission pulse width, no special meaning for RS-232C */
	const int Tout=10;	/* 	*/

	/* Communication setup */
	if( bi_cominit(Dev,Bps,Pulse,Tout) ){
		gv_kput(10,10,"Communication initialization NG ",6,0,0);	/* RS-232C disconnected */
	}
	else if( bi_comclr() ){
		gv_kput(10,10,"Buffer initialization NG",6,0,0);
	}
	else if( bi_comopen() ){
		gv_kput(10,10,"Connection NG      ",6,0,0);
	}
	else{
		/* Communication line  connection OK */
		gv_kput(10,10,"Connection OK      ",6,0,0);

		/* Sending process */
		PwreadProc(); /* Return with the Menu key */

		/* Communication line disconnected */
		if( bi_comclose() ){
			gv_kput(10,10,"Disconnection NG        ",6,0,0);
		}
		if( bi_cominit(0,0,0,0) ){
			gv_kput(10,10,"Communication termination NG    ",6,0,0);
		}
		else{
			gv_kput(10,10,"Communication terminated       ",6,0,0);
		}
	}
}

void PwreadProc(void)
{
	int Key=0;
	char buff[32];
	int	volt;

    while( !(Key&Bkey_D) ){
	    Key=bi_getbtn();

		if( Key&Bkey_up ){
			lcdon(1);				/* LCD driver ON  */
			MessSend("LCD ON\n\r",8);
		}
		if( Key&Bkey_dw ){
			lcdon(0);				/* LCD driver OFF */
			MessSend("LCDOFF\n\r",8);
		}
		if( Key&Bkey_lf ){
			volt = bi_powerread();	/* Voltage reading */

			if( (unsigned int)volt<=255 ){
				sprintf(buff,"P0=%03d\n\r",(unsigned int)volt);	/* Character string conversion */
			}else{
				strcpy(buff,"VOLERR\n\r");
			}
			MessSend(buff,8);

			if( getlcdon() ){
				/* Displays on the LCD screen */
				buff[6]='\0';
				gv_kput(10,25,buff,2,0,0);
			}
		}
		if( Key&Bkey_rg ){
			volt = bi_powerread2();	/* Voltage 2 reading */

			if( (unsigned int)volt<=255 ){
				sprintf(buff,"P2=%03d\n\r",(unsigned int)volt);	/* Character string conversion */
			}else{
				strcpy(buff,"VOLERR\n\r");
			}
			MessSend(buff,8);

			if( getlcdon() ){
				/* Displays on the LCD screen */
				buff[6]='\0';
				gv_kput(10,37,buff,2,0,0);
			}
		}
		bi_clrbtn();
    }
}

void MessSend(char *write,int len)
{
	/* Returns len bytes as a character anyway*/
	int  ret,num;

	if( ret=bi_complwrite(write,len,&num) ){
		if( ret==-2 ){
			gv_kput(10,10,"Low voltage error",5,0,0);
		}
		else{
			gv_kput(10,10,"Sending error occurs",5,0,0);
		}
	}
}
