/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*																		*/
/*		AD2COM3 Batter condition										*/
/*		Key operation version        									*/
/*======================================================================*/

#include<stdio.h>	/* C Language standard library sprintf */
#include<string.h>	/* C Language standard library strcpy */

#include"wbios.h"
#include"psdos.h"
#include"lcdbios.h"
#include"rupsys.h"	/* onHand/Ruputer hearer Bkey_** key */


/* Prototype declaration of functions used for MAIN.C */
void PwreadProc(int);			/* The body is located under main() */
void ComProc(int);				/* The body is located under main() */
void MessSend(char*,int);		/* The body is located under main() */

int main(void)
{
    screen(1);

	cls(4);

	gv_kput(10,10,"Mount ",5,0,0);
	gv_kput(10,22," on station",5,0,0);

	while( !(bi_getbtn()&Bkey_SH) ){
		if (bi_scanbtn()&Bkey_D) return;
	}	/* Waiting to be connected to a Rs-232c cable  */
	cls(4);

	/* Remote communication process */
	ComProc(3);				/* Baud rate 3: 38.4kbps Can be changed by this argument */
	lcdon(1);

    while( !(bi_getbtn()&Bkey_D) ){}		/* Exit with the Menu key */

	gv_place(0,0);
	cls(4);					/* GVRAM clear */
    gv_kput(0,2,"Application",5,0,0);
    gv_kput(30,40,"exits.",5,0,0);
    cls(4);
}

void ComProc(int Bps)
{
	/* Bps:Can be set only for baud rate */
	const int Dev=2;	/* RC-232C   */
	const int Pulse=0;	/* Infrared light-emission pulse width, no special meaning for RS-232C */
	const int Tout=10;	/* Timeout time  */

	/* Communication setup  */
	if( bi_cominit(Dev,Bps,Pulse,Tout) ){
		gv_kput(10,10,"Communication initialization NG ",6,0,0);
	}
	else if( bi_comclr() ){
		gv_kput(10,10,"Buffer initialization  NG",6,0,0);
	}
	else if( bi_comopen() ){
		gv_kput(10,10,"Communication NG      ",6,0,0);
	}
	else{
		/* Communication line  connection OK */
		gv_kput(10,10,"Communication OK      ",6,0,0);

		/* Communication process */
		PwreadProc( Tout ); /* Communication error returns by RC-232C disconnection. */

		/* Communication line disconnected */
		if( bi_comclose() ){
			gv_kput(10,10,"Disconnection NG        ",6,0,0);
		}
		if( bi_cominit(0,0,0,0) ){
			gv_kput(10,10,"Communication termination NG    ",6,0,0);
		}
		else{
			gv_kput(10,10,"Communication terminated       ",6,0,0);
		}
	}
}

#define TIMEOUT_ERR 0x10
void PwreadProc(int Tout)
{
	int Key=0;
	int i=1,count;
	char buff[32];
	char read[8];
	int	volt;

	while( !(Key&Bkey_D) ){

		/* Using the multiple character receiving function. Obtains one byte. */
		if( bi_complreadn(read,1,&count) ){
			if( BIOSerr&~TIMEOUT_ERR ){
				gv_kput(10,49,"Error occurs during receiving",6,0,0);
				Key=Bkey_D;
			}
			else{
				sprintf(buff,"No operation:%3d seconds",i*Tout);
				gv_kput(10,10,buff,6,0,0);
				i++;
			}
		}
		else{
			/* Obtaining one byte successfully */

			strcpy(buff,"Operation:");
			for(i=0;i<count;i++){
				sprintf(buff,"%s%02Xh ",buff,read[i]&0xFF);
			}
			gv_kput(10,10,buff,6,0,0);
			switch( read[0] ){
			  case '8':
				lcdon(1);				/* LCD driver ON */
				MessSend("LCD ON\n\r",8);
				break;
			  case '2':
				lcdon(0);				/* LCD driver OFF */
				MessSend("LCDOFF\n\r",8);
				break;
			  case '4':
				volt = bi_powerread();	/* Voltage reading */

				if( (unsigned int)volt<=255 ){
					sprintf(buff,"P0=%03d\n\r",(unsigned int)volt);	/* Character string conversion */
				}else{
					strcpy(buff,"VOLERR\n\r");
				}
				MessSend(buff,8);

				if( getlcdon() ){
					/* Displays on the LCD screen */
					buff[6]='\0';
					gv_kput(10,25,buff,2,0,0);
				}
				break;
			  case '6':
				volt = bi_powerread2();	/* Voltage 2 reading */

				if( (unsigned int)volt<=255 ){
					sprintf(buff,"P2=%03d\n\r",(unsigned int)volt);	/* Character string conversion */
				}else{
					strcpy(buff,"VOLERR\n\r");
				}
				MessSend(buff,8);

				if( getlcdon() ){
					/* Displays on the LCD screen */
					buff[6]='\0';
					gv_kput(10,37,buff,2,0,0);
				}
				break;
			}
			i=1;		/* Resets the number of timeouts */
			bi_comclr();/* Clears receiving buffers */
		}
		bi_clrbtn();
	}
}
void MessSend(char *write,int len)
{
	/* Returns len bytes as a character anyway */
	int  ret,num;

	if( ret=bi_complwrite(write,len,&num) ){
		if( ret==-2 ){
			gv_kput(10,10,"Low voltage error",6,0,0);
		}
		else{
			gv_kput(10,49,"Sending error occurs",6,0,0);
		}
	}
}
