/*======================================================================*/
/*Project name:RUPUTER                                                  */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*									                                    */
/*		Lines2 Input Menu							                    */
/*		psdos version		     				                        */
/*======================================================================*/

#include"lcdbios.h"
#include"wbios.h"
#include"psdos.h"
#include"rupsys.h"
#include"rupmenu.h"

extern int linenum;
extern unsigned char pattern;

extern void initLine(int num,int lg,unsigned char stl1);


int settings(void);

int runMenu(void)
{
    INPUTITEM Item[2];
	char Menu[2][20] = {
		{"Settings..."},
		{"Exit"},
	};
	int id;
	int ret;

	/* Initialize menu */
	initInputTable("Lines2",Item);

	/* menu registration operation 1 */
	id = entryItemMenu((char*)Menu[0],(int*)settings);
	setItemMenuNext(id,1);

	/* menu registration operation 2 */
	id = entryItemMenu((char*)Menu[1],(int*)setExitMenu);

	/* start of menu operation */
	ret = runInputProc();

	/* Do not forget. */
	endInputTable();

	return ret;
}


/*   entryItemMenu   menu execution functions */
int settings(void)
{
	int id,pt,ret;

    INPUTITEM Item[2];
	static char TITLES[2][20]={
		{"Number of lines"},
		{"Line patterns"},
	};
	static const char Line[][5] = {
		{"  1 "},
		{"  2 "},
		{"  3 "},
		{"  4 "},
		{"  5 "},
		{"  6 "},
		{"  7 "},
		{"  8 "},
		{"  9 "},
		{" 10 "},
		{" 11 "},
		{" 12 "},
		{" 13 "},
		{" 14 "},
		{" 15 "},
		{" 16 "},
		{" 17 "},
		{" 18 "},
		{" 19 "},
		{" 20 "},
	};
	static const char Pat[][9] = {
		{"straight"},
		{"dotted  "},
		{"broken  "},
	};


	/* Initialize menu */
	initInputTable("Settings",Item);

	/* Menu registration operation 1 */
	id = entryItem(TITLES[0],(char*)Line,20);
	setItemListVal(id,linenum-1);

	/* scroll operation 2:Non-toggle(Inverted arrangement) */
	setItemListToggle(id,2);

	/* Menu registration operation 2*/
	id = entryItem(TITLES[1],(char*)Pat,3);
	if (pattern==0xFF)		pt=0;
	else if (pattern==0xAA)	pt=1;
	else if (pattern==0x3D)	pt=2;
	setItemListVal(id,pt);

	/* Start of menu operation */
	ret = runInputProc();

	if (ret==-3) {
		/* update operation */
		dispRenew();

		linenum= getItemListVal(getItemId(TITLES[0]))+1;

		pt=getItemListVal(getItemId(TITLES[1]));
		if (0==pt)			pattern= 0xFF;
		else if (1==pt)		pattern= 0xAA;
		else if (2==pt)		pattern= 0x3D;

		initLine(linenum,0,pattern);

		endRenew();
	}

	/* Do not forget. */
	endInputTable();

	/* return value  -2:request for end of application  other than that: normal end */
	return ret;
}


