/*======================================================================*/
/*Project Name:RUPUTER                                               	*/
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. */
/*                                                                      */
/*Function Outline		:	LCD-BIOS Common Include File				*/
/*																		*/
/*======================================================================*/


/*================================================================
	Lettersize Function Interface Structure Definition	
=================================================================*/

struct moji {
	int		w ;				/* Character width	*/
	int		h ;				/* Character height	*/
	long	add ;			/* Linear address	*/
} ;

/*================================================================
		Function Prototype Declaration								
================================================================*/

int			screen( int) ;
int			getscreen( void) ;
int			cls( int) ;
int			lcdon( int) ;
int			getlcdon( void) ;
int			mpread( char *, char *) ;
struct moji *mojisize( int) ;
int			getbufsize( int, int, int, int) ;
int			reverse( int, int, int, int) ;
int			revstop( int) ;
int			revstart( int) ;
int			revend( int) ;
int			revdraw( void) ;
int			blink( int, int, int, int, int) ;
int			blstop( int) ;
int			blstart( int) ;
int			blend( int) ;
int			lcdfreeze( int) ;
int			lcdvol( int) ;
int			getlcdvol( void) ;

int			gv_place( int, int) ;
int			gv_kput( int, int, char *, int, int, int) ;
int			gv_sput( int, int, int, int) ;
int			gv_aput( int, int, int, int, unsigned long, int) ;
int			gv_mmap( int, int, char *, int) ;
int			gv_line( int, int, int, int, int, unsigned char) ;
int			gv_square( int, int, int, int, int, unsigned long) ;
int			gv_circle( int, int, int, int, int, int, int, unsigned long, unsigned char *) ;
int			gv_pset( int, int, int) ;
int			gv_point( int, int) ;
int			gv_get( int, int, int, int, char *) ;
int			gv_put( int, int, char *, int) ;
int			gv_scroll( int) ;
int			gv_reverse( int, int, int, int) ;
int			gv_clear( int, int, int, int) ;

int			lc_kput( int, int, char *, int, int, int) ;
int			lc_sput( int, int, int, int) ;
int			lc_aput( int, int, int, int, unsigned long, int) ;
int			lc_mmap( int, int, char *, int) ;
int			lc_line( int, int, int, int, int, unsigned char) ;
int			lc_square( int, int, int, int, int, unsigned long) ;
int			lc_circle( int, int, int, int, int, int, int, unsigned long, unsigned char *) ;
int			lc_pset( int, int, int) ;
int			lc_point( int, int) ;
int			lc_get( int, int, int, int, char *) ;
int			lc_put( int, int, char *, int) ;
int			lc_reverse( int, int, int, int) ;
int			lc_clear( int, int,int, int) ;


/*================================================================
	Function Prototype Declaration	Structure Interface			
================================================================*/
typedef	struct {
	int x;
	int y;
} POINT;					/* Definition of coordinates */
typedef	struct {
	int x1;
	int y1;
	int x2;
	int y2;
} RECT;						/* Definition of area(Limit:x1 < x2,y1 < y2) */

int pv_place(POINT *);		/* Display start position of */

typedef	struct {
	POINT pos;				/* Position */
	char *str;				/* Character string */
	int font;				/* Character type */
	int gap;				/* Between characters */
	int lop;				/* Logical operation */
} KANJI_PUT;				/* Definition of drawing of character strings */
int pv_kput(KANJI_PUT *);	/* Draw a string in GVRAM. */
int pc_kput(KANJI_PUT *);	/* Draw a string in LCVRAM. */

typedef struct {
	POINT pos;				/* Position */
	unsigned short code;	/* Character */
	int lop;				/* Logical operation */
} SIICODE_PUT;				/* Definition of drawing of SIIcode characters */
int pv_sput(SIICODE_PUT *);	/* Draw SII code character in GVRAM. */
int pc_sput(SIICODE_PUT *);	/* Draw SII code character in LCVRAM. */

typedef struct {
	POINT pos;				/* Position */
	int width;				/* Width */
	int hight;				/* Height */
	unsigned long addr;		/* Font data address */
	int lop;				/* Logical operation */
} FONT_PUT;					/* Definition of drawing of font data */
int pv_aput(FONT_PUT *);	/* Draw font data in GVRAM. */
int pc_aput(FONT_PUT *);	/* Draw font data in LCVRAM. */

typedef struct {
	POINT pos;				/* Position */
	char *name;				/* File name */
	int lop;				/* Logical operation */
} MMAP_PUT;					/* Definition of drawing of MMP file in flash */
int pv_mmap(MMAP_PUT *);	/* Draw MMP file in flash in GVRAM. */
int pc_mmap(MMAP_PUT *);	/* Draw MMP file in flash in LCVRAM. */

typedef struct {
	POINT st;				/* Starting point */
	POINT ed;				/* End point */
	int lop;				/* Logical operation */
	unsigned char txt;		/* Line style */
} LINE_DRAW;				/* Definition of drawing of line */
int pv_line(LINE_DRAW *);	/* Draw a line part in GVRAM. */
int pc_line(LINE_DRAW *);	/* Draw a line part in LCVRAM. */

typedef struct {
	RECT rect;				/* Corresonding area  */
	int lop;				/* Logical operation */
	unsigned long txt;		/* Line style, tile pattern */
} SQUARE_DRAW;
int pv_square(SQUARE_DRAW *squ);		/* Draw an area frame in GVRAM. */
int pc_square(SQUARE_DRAW *squ);		/* Draw an area frame in LCVRAM. */

typedef	struct {
	int xr;
	int yr;
} RADS;						/* Definition of a radius */

typedef	struct {
	int d1;
	int d2;
} DEGR;						/* Definition of a starting angle */

typedef struct {
	POINT pos;				/* Position */
	RADS rad;				/* Radius */
	DEGR deg;				/* Starting angle  */
	int lop;				/* Logical operation */
	unsigned long txt;		/* Line style, tile pattern */
	unsigned char *buf;		/* Work for filling a pie */
} CIRCLE_DRAW;
int pv_circle(CIRCLE_DRAW *cir);	/* Draw an oval area frame in GVRAM. */
int pc_circle(CIRCLE_DRAW *cir);	/* Draw an oval area frame in LCVRAM. */

typedef struct {
	POINT pos;				/* Position */
	int lop;				/* Logical operation */
} POINT_DRAW;				/* Definition of drawing of points */
int pv_pset(POINT_DRAW *);	/* Draw points in GVRAM. */
int pc_pset(POINT_DRAW *);	/* Draw points in LCVRAM. */

int pv_point(POINT *);		/* Obtain a color(monochrome) of GVRAM.  */
int pc_point(POINT *);		/* Obtain a color (monochrome) of LCVRAM. */

typedef struct {
	RECT rect;				/* Area */
	char *buf;				/* Address */
} GVRAM_GET;				/* Definition of reading from GVRAM */
int pv_get(GVRAM_GET *);	/* Read from GVRAM */
int pc_get(GVRAM_GET *);	/* Read from LCVRAM */

typedef struct {
	POINT pos;				/* Position */
	char *buf;				/* Address */
	int lop;				/* Logical operation */
} GVRAM_PUT;				/* Definition for writing out to GVRAM */
int pv_put(GVRAM_PUT *);	/* Write out to GVRAM. */
int pc_put(GVRAM_PUT *);	/* Write out to LCVRAM. */

int pv_reverse(RECT *);		/* Invert a GVRAM area. */
int pc_reverse(RECT *);		/* Invert an LCVRAM area. */

int pv_clear(RECT *);		/* Clear a GVRAM area. */
int pc_clear(RECT *);		/* Clear a LCVRAM area. */

int pgetbufsize(RECT *);	/* Obtain the number of graphic pattern bytes on LCD. */

int preverse(RECT *);		/* Specify an inverted area on LCD. */

typedef struct {
	RECT rect;				/* Flashing area */
	int color;				/* Specify a flashing method. */
} BLINK_DRAW;				/* Define a flashing area. */
int pblink(BLINK_DRAW *);	/* Specify a flashing area. */

