/*==================================================================================*/
/*Project Name:RUPUTER                                                			    */
/*      Copyright (c) Seiko Instruments Inc. 1999. All rights reserved. 			*/
/*                                                                     				*/
/*Function Outline : onHand/Ruputer InputMenu Definition(For Creating a Library)	*/
/*                                                                      			*/
/*==================================================================================*/

/************************************************************************************************/
typedef struct {
	int  myid;			/* ID												*/
	char *myname;		/* Title name										*/
	int	 ydot;			/* Display dot:y 									*/
	int  xdir;			/* <<>>Direction display 							*/
	int  chmode;		/* Display mode	  0:Input 1:PlainMenu 2:InputEx 	*/
						/*		  3:Time  4:TimeZone  5:Date				*/
						/*		  6:....user extension						*/
	int  dspmode;		/* Selection display mode 0:Flash 1:Invert 			*/
	int  disable;		/* Valid/Invalid	  0:Valid 1:Invalid 			*/
	int  xlistL;		/* List left coordinate 							*/
	int  xlistR;		/* List right coordinate 							*/
	char *list;			/* Header address of list data 						*/
	int  listnum;		/* Number of lists									*/
	int  listlen;		/* List character length 							*/
	int  listval;		/* List selection value 							*/
	int  listtgl;		/* List change method 0:Non-toggle	    1:Toggle	*/
						/*	     2:Inverted non-toggle 3:Inverted toggle	*/
	int  (*listEx)(int,int,int);
						/* List display customize function 					*/
	void (*listcallback)(int,int);
						/* Event back function when a list is operated 		*/
	int  (*menu)(void);	/* Menu function 					*/
	int  nextflg;		/* Right edge of menu >Display 0:OFF,1:ON 			*/

	char *extinfo;		/* General array/address for storing structure data	*/
} INPUTITEM;
/************************************************************************************/
typedef struct {
	char  *title;		/* Menu title 						*/
	int	   total;		/* Number of registered items		*/
	int	   ydisp;		/* Item display ID					*/
	int	   initid;		/* Initial selection ID 			*/
	int	   chfiler;		/* Transition to mini filer? 0:Disabled 1:Enabled 2:End			*/
	int    ufg; 		/* When a change is made to a list, popup display appears at the time of cancellation.	*/
	int	   font;		/* Font setting 0-3:Japanese,5-7:English						*/
						/* If you wish to change, you have to set prior to entryItem(). */
  INPUTITEM   *item;	/* Item structure												*/
} INPUTTABLE;

/* Time scale structure */
typedef struct {
	int Year;			/* Year				*/
	int Month;			/* Month			*/
	int Day;			/* Day				*/
	int Week;			/* Week				*/
	int Hour;			/* Hour(24-hour)	*/
	int Min;			/* Minute			*/
	int Hour2;			/* Hour(24-hour)	*/
	int Min2;			/* Minute			*/
} INPUTTIME;
/************************************************************************************************/
typedef struct {

	void (*initInputTable)(char *,INPUTITEM *);
	void (*endInputTable)(void);

	int  (*entryItem)(char *,char *,int);
	int  (*entryItemEx)(char *, int *);
	int  (*entryItemMenu)(char *,int *);
	int  (*entryItemExtInfo)(int,char *,char *,int *,int *);

	int  (*setInitialItemId)(int);
	void (*setInputFont)(int);		/* You should set prior to entryItem(). 	*/
	void (*setChfiler)(int);
	int (*setItemListToggle)(int,int);
	int (*setItemListVal)(int,int);
	int (*getItemListVal)(int);
	char *(*getItemListStr)(int,int);

	INPUTITEM *(*getInputItemNow)(void);
	int (*getItemId)(char *);
	int (*getLastItemId)(void);
	int (*getLastKeyState)(void);

	void (*arrangeItemListX)(int,int);

	int (*setItemExtInfoData)(int,char *);
	char *(*getItemExtInfoData)(int);

	int (*setItemMenuNext)(int,int);
	int (*setItemSelectMode)(int,int);
	int (*setItemDisable)(int,int);
	int (*setItemCallBack)(int,void *);

	void (*dispItemRW)(int);

	int (*runInputProc)(void);
	int (*retToggle)(int,int);
	int (*retToggleBoth)(int,int,int);
	int (*retNonToggle)(int,int);
	int (*retNonToggleBoth)(int,int,int);

	int (*entryItemTime)(char *,INPUTTIME *);
	void (*setDblSignal)(int);
	void (*resetKeyflg)(void);

} APIMENU;

/** System Functions  *********************/
extern APIMENU *pApiMenu;

extern void initInputTable(char *,INPUTITEM *);
extern void endInputTable(void);

extern int  entryItem(char *,char *,int);
extern int  entryItemEx(char *, int *);
extern int  entryItemMenu(char *,int *);
extern int  entryItemExtInfo(int,char *,char *,int *,int *);

extern int  setInitialItemId(int);
extern void setInputFont(int);
extern void setChfiler(int);
extern int setItemListToggle(int,int);
extern int setItemListVal(int,int);
extern int getItemListVal(int);
extern char *getItemListStr(int,int);

extern INPUTITEM *getInputItemNow(void);
extern int getItemId(char *);
extern int getLastItemId(void);
extern int getLastKeyState(void);

extern void arrangeItemListX(int,int);

extern int setItemExtInfoData(int,char *);
extern char *getItemExtInfoData(int);

extern int setItemMenuNext(int,int);
extern int setItemSelectMode(int,int);
extern int setItemDisable(int,int);
extern int setItemCallBack(int,void *);

extern void dispItemRW(int);

extern int runInputProc(void);
extern int retToggle(int,int);
extern int retToggleBoth(int,int,int);
extern int retNonToggle(int,int);
extern int retNonToggleBoth(int,int,int);

extern int entryItemTime(char *str,INPUTTIME *tm);
extern void setDblSignal(int flg);
extern void resetKeyflg(void);

