/*==================================================================================*/
/*Project Name:RUPUTER                                             				  	*/
/*		 Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. 		*/
/*																					*/
/*Function Outline : onHand/Ruputer Tool Library Definition(For Creating a Library)	*/
/*  		                                                                        */
/*==================================================================================*/


/* Date data */
typedef struct{
	char	dd;					//Day
	char 	mm;					//Month
	int		yy;					//Year
}TypeDate;

// Time data
typedef struct{
	int		min;				//Minute
	int 	hour;				//Hour
}TypeTime;


typedef struct {
	int  (*getUsWdot)(int, char *);
	void (*StrCpy)(char *,const char *);
	int  (*StrnCmpI)(char * ,char * ,int );
	void (*strcat1)(char *,const char *);
	void (*strcat2)(char *,const char *,const char *);
	void (*strcpy1)(char *,const char *);
	void (*strcpy2)(char *,const char *,const char *);
	void (*strcpy3)(char *,const char *,const char *,const char *);
	void (*wstrcpy)(char *,const char *,char *, const char *);
	void (*strcpyadd0)(char *,const char *,int);
	int  (*strlength)(const char *);

	void (*SetExitfunc)( void (*)( void ) );		//Set a function to invoke when dos_exit() is requested.
	void (*StartApr)( void (*)( void ) );			//Initialize application.
	int (*EventChk)(int );							//Event check
	int (*FileCreate)(char *);						//Create a file.
	int (*NewFileOpen)(char *);						//Create a new file.
	int (*FileOpen)(char *,int );					//Open a file.
	unsigned long (*FileSeek)(int ,int ,unsigned long );//Seek a file.
	void (*FileWrite)(int ,char *,unsigned int );	//Write to a file.
	void (*WriteSpace)(long );						//Judge a remaining space.
	int (*FileRead)(int ,char *,unsigned int );		//Read from a file.
	void (*FileClose)(int );						//Close a file.
	void (*FileFlash)(int );						//Store into flash.
	void (*FileDelete)(char *);						//Delete a file.
	void (*FileSystemAttr)( int, char * );			//Change a file attribute to system file attribute
	void (*INTtoASC1)(char *,int ,int ,int );		//Change a digit to a character string(with \0 for scosii code).
	void (*INTtoASC2)(char *,int ,int ,int );		//Change a digit to a character string (without \0 for scosii code).
	void (*INTtoASCcode0)(char *,int ,int ,int );	//Change a digit to a character string (without \0 for normal code).
	int (*IsKanji_1)( unsigned char *, int );		//Judge whether a specified character is full-size second byte. 
	int (*IsKanji)( unsigned char *,int );			//Judge whether a specified character is a full size. 
	int (*CheckFileName)( char *, char *, char * );	//Judge with an extention whether a file is proper.
	unsigned long (*GetDateID_in)( void );			//Obtain a unique ID.
	unsigned long (*GetDateID)( void );				//Obtain a unique ID(corresponding to PIMLINK, synchro flag).
	int (*CheckLeapYear)( int );					//Judge whether it is a leap year.
	int (*CheckAmPm)( int * );						//Judge whether it is AM/PM.
	void (*CheckToday)( TypeDate * );				//Obtain a date of today.(on RAM)
	int (*CheckWeek)( int,int,int );				//Obtain a day of the week.
	int (*Get2WeekMonday)( int , int );				//Obtain a date of the second Monday.
	int (*CheckSecret)( int );						//Judge secret.
	void (*SetMessBuf)( char *, char * );			//Create a message asking Do you **?
	int (*KeyWait)( void );							//Key waiting function
	int (*dispVersion)( char *[], int , int );		//Display version information.
	void (*DeleteTimer)( int * );					//Delete timer.
	int (*GetNWeek)( int, int, int, int );			//Obtain a date of nth day of the week.
	int (*GetSndFileName)( char *, char [][9], int );//Obtain a name of a sound file.
	void (*SoundDEMO)( char * );					//sound demo
	void (*GetNdaysafter)( TypeDate *, long , int );//Obtain a date after a few days.
	int (*YearDayCount)( int );						//Obtain the total number of days of a year.
	int (*CheckDayCountSet)( TypeDate * );			//Obtain information some days after January 1. 
	long (*GetSubDays)( TypeDate *, TypeDate * );	//Obtain a difference between one date and another date. 
	int (*MINtoHOURMIN)( TypeTime *, int );			//Change time  (a value converted in minutes) into hour and minute.
	void (*HOURMINtoMIN)( int *, TypeTime * );		//Change time (hour and minute) to a value converted in minutes. 
	int (*GetSubTime)( TypeTime *, TypeTime * );	//Obtain a difference between time and time.
	int (*GetNhourafter)( TypeTime *, int );		//Obtain time after N minutes. 
	int (*CmpDay)( TypeDate *, TypeDate * );		//Compare dates in size.
	int (*CmpTime)( TypeTime *, TypeTime * );		//Compare time in size.
	void (*IncDate)( TypeDate *, int , int );		//+one day
	void (*DecDate)( TypeDate *, int , int );		//-one day
	int (*CheckTimeTable)( TypeDate *, TypeDate *, TypeDate * );//Judge whether a date is within a range.
	void (*SetAlarmIni)( char *, char * );			//Update Alarm.ini.
} APITOOL;
/************************************************************************************/

/** System functions  *********************/
extern APITOOL *pApiTool;

extern int  getUsWdot(int, char*);
extern void StrCpy(char *,const char *);
extern int  StrnCmpI(char * ,char * ,int );
extern void strcat1(char *,const char *);
extern void strcat2(char *,const char *,const char *);
extern void strcpy1(char *,const char *);
extern void strcpy2(char *,const char *,const char *);
extern void strcpy3(char *,const char *,const char *,const char *);
extern void wstrcpy(char *,const char *,char *, const char *);
extern void strcpyadd0(char *,const char *,int);
extern int  strlength(const char *);


//Own created functions
extern void getGvPos(int*, int*);
extern int  getLcdfreezeVal(void);

// common functions 
extern int CheckLeapYear( int );					//Judge whether it is a leap year.
extern int CheckAmPm( int * );						//Judge whether it is AM/PM.
extern void CheckToday( TypeDate * );				//Obtain a today's date.(on RAM)
extern int CheckWeek( int,int,int );				//Obtain a day of the week.
extern int Get2WeekMonday( int , int );				//Obtain a date of the second Monday.
extern int CheckSecret( int );						//Judge secret.
extern void SetMessBuf( char *, char * );			//Create a message asking Do you **?
extern int GetNWeek( int, int, int, int );			//Obtain a date of nth day of the week.
extern int GetExtFileName( char *, char [][9], int );//Obtain a name of a sound file. 
extern void SoundDEMO( char * );					//sound demo

//Not supported
extern void GetNdaysafter( TypeDate *, long , int );//Obtan a date after a few days.
extern int YearDayCount( int );						//Obtain the total number of days in a year.
extern int CheckDayCountSet( TypeDate * );			//Obtain information some days after January 1. extern long GetSubDays( TypeDate *, TypeDate * );	//Obtain a difference between one date and another date. 
extern int GetSubTime( TypeTime *, TypeTime * );	//Obtain a difference between time and time.
extern int GetNhourafter( TypeTime *, int );		//Obtain time after N minutes.
extern int CheckTimeTable( TypeDate *, TypeDate *, TypeDate * );//Judge whether a date is within a range.

//Application extension
extern void	SetExtensionInfo(unsigned long pInfo);
extern long	GetExtensionInfo(void);
extern void	ClearExtensionInfo(void);
extern int	ExtensionAppsExecute(char *path);
