/*==========================================================================*/
/*Project Name:RUPUTER                                                 		*/
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. 	*/
/*                                                           	        	*/
/* Function Outline : dos_delete() checking voltage drops					*/
/*                                                                      	*/
/*==========================================================================*/

#include "wbios.h"
#include "psdos.h"
#include "rupsys.h"

int dos_fdelete(char *filepath)
{
	int rst;
	int vol;

	/* Check voltage2@*/
	vol = bi_powerread2();
	if( vol < pSystemCtl->Paramsys->VOLFileOpen ){
		return -2;
	}
	if((rst = dos_delete(filepath))==-1){
		if( bi_27Verror() ){
			return -2;
		}
	}
	else if((rst = bi_wrflush(1))==-1){
		if( bi_27Verror() ){
			return -2;
		}
		return -3;
	}
	return rst;
}
