/*==========================================================================*/
/*Project Name:RUPUTER                                                 		*/
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. 	*/
/*                                                           	        	*/
/* Function Outline : Displays a scroll jump mark							*/
/*                                                                      	*/
/*==========================================================================*/

#include "rupsys.h"
#include "g2p.h"

extern int _SystemCtl_Version;

#define Pause	*(char *)0x10ABBC	// filer322E
#define WAIT	3	// Wait times the end of scroll ternimation.

int pauseScroll(int repkey,int flg,int y)
{
	int (*func)(int,int,int);
	int rst;

	if (_SystemCtl_Version==322) {	// for filer322E
		func= (int(*)(int,int,int))0x277A58;	// pauseScroll2()
		rst = (*func)(repkey,flg,y);
		if (!rst) Pause=WAIT;
	}
	else {
		rst = convGnuToPanaxI4(repkey,flg,y,WAIT,
								(int*)pApiSys->pauseScroll2);
	}
	return rst;
}

