/*==========================================================================*/
/*Project Name:RUPUTER                                                 		*/
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. 	*/
/*                                                           	        	*/
/* Function Outline : Filer API service statup,epilog						*/
/*                                                                      	*/
/*==========================================================================*/

#include "psdos.h"
#include "rupsys.h"
#include "rupmenu.h"
#include "ruptool.h"

SYSTEMCTL	*pSystemCtl;			// Ruputer system structure
APISYS  	*pApiSys;
APIMENU 	*pApiMenu;
APITOOL 	*pApiTool;
//APIDISP 	*pApiDisp;

int     _SystemCtl_Version;

static int setSystemCtlVersion(void);

void InitRupAPI(void)
{
	char *psys;
	unsigned long *pRom;
	char *psp;
	char buf[9];
	int i;

	const static char MESS[][15] = {
		"This version",
		"not supported.",
	};
	char *mess[]={(char*)MESS[0],(char*)MESS[1]};

	// Obtain PSP address
	psp = (char *)dos_get_psp() + 0x80;
	// Obtain system info
	for(i = 0;i < 8;i++) buf[i] = *psp++;
	buf[8] = '\0';

	psys = (char*)toAddrbin(buf);
	pSystemCtl = (SYSTEMCTL*)psys;

	pRom = (unsigned long*)(psys+0x134);
	pApiSys  = (APISYS  *)(pRom[0]);
	pApiMenu = (APIMENU *)(pRom[1]);
	pApiTool = (APITOOL *)(pRom[2]);
//	pApiDisp = (APIDISP *)(pRom[3]);

	// Filer version
	_SystemCtl_Version = setSystemCtlVersion();
	if (_SystemCtl_Version<322) {
		pSystemCtl->dispMESS((char**)mess,2);
		dos_exit(0);
	}
}

void EndRupAPI(void)
{
	screen(LCD_GRAPH);
	gv_place(0,0);
	EVENTREGSTER = 1;
}


long toAddrbin(char *str)
{
	long adr;
	adr = 0;
	for(;*str != (char)'\0';str++) {
		adr = adr << 4;
		if (('0' <= *str) && (*str <= '9'))
			adr = adr + (*str - '0');
		else if (('a' <= *str) && (*str <= 'f'))
			adr = adr + 10 + (*str - 'a');
		else if (('A' <= *str) && (*str <= 'F'))
			adr = adr + 10 + (*str - 'A');
	}
	return adr;
}

static int setSystemCtlVersion(void)
{
	if ((unsigned long)pSystemCtl==0x10B170) return 200; 		// MP110,120,140
	if ((unsigned long)pSystemCtl==0x10AAD8) return 314; 		// MPE ES50

	if ((unsigned long)(pApiSys->getFilerVersion) ==
		(unsigned long)(pApiMenu->initInputTable)) return 322;	// MPE

	// Filer323~
	return (*pApiSys->getFilerVersion)();
}
