/*==========================================================================*/
/*Project Name:RUPUTER                                                 		*/
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. 	*/
/*                                                           	        	*/
/* Function Outline : Menu title UP/DOWN gauge								*/
/*                                                                      	*/
/*==========================================================================*/

#include "lcdbios.h"
#include "font.h"

void dispTitleUpDw(int sel,int top,int total)
{
	static int pmode = -1;
	int mode=0;
	GVRAM_PUT tri={{92,3},(char *)0,	0};	// Scroll bar image

	if (total==0) pmode=-1; // Reset value

	if (sel==0) 		 mode=0;
	else if (sel!=total) mode=1;
	else				 mode=2;

	if (pmode!=mode) {
		if (top==0)
			tri.buf=(char*)mmpMENU_DWBAR;				//	Top
		else if (top+4==total)
			tri.buf=(char*)mmpMENU_UPBAR;				//	Bottom
		else
			tri.buf=(char*)mmpMENU_DUBAR;				//	Center

		pv_put((GVRAM_PUT *)&tri);
		pmode=mode;
	}
}
