/*==========================================================================*/
/*Project Name:RUPUTER                                                 		*/
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. 	*/
/*                                                           	        	*/
/* Function Outline : Execute a child process                               */
/*                      (Succeed data area information to be commonly used.)*/
/*                                                                      	*/
/*==========================================================================*/

#include"psdos.h"

/* Register extension information to PSP
	psp+0xF2 = EXTHEAD
	psp+0xF8 = Common memory header
*/
typedef struct {
	char	*config;
	char	*psp80h;
	char	*psp50h;
	char	*psp60h;
} PSP;

int ExtensionAppsExecute(char *path)
{
	int rst;
	PSP psp;
	char *p;
	int   n;

	/* Initialize PSP area */
	p=(char*)&psp;
	n=sizeof(PSP);
	while (n>0) { *p=0; p++; n--; }

	psp.psp80h =  (char *)dos_get_psp() + 0x80;

	rst = dos_execute(0,path,(char*)&psp);

	return rst;
}
