/*==========================================================================*/
/*Project Name:RUPUTER                                                 		*/
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. 	*/
/*                                                           	        	*/
/* Function Outline : To register data area to be commonly used.			*/
/*                                                                      	*/
/*==========================================================================*/

#include"string.h"
#include"psdos.h"
#define EXTHEAD "<ext>"

static void toAddrstr(char *str,unsigned long adr);

void SetExtensionInfo(unsigned long pInfo)
{
	char *psp;

	/* PSP address +0xF1 */
	psp = (char *)dos_get_psp() + 0xF1;

	/* Register data common memory at end of PSP area */
	*(psp) = 0;
	strcpy(psp + 0x01,EXTHEAD);
	toAddrstr(psp + 0x07,pInfo);
}

static void toAddrstr(char *str,unsigned long adr)
{
	int i;

	str[8] = NULL;
	for(i = 7;0 <= i;i--) {
		if ((adr & 0x0f) > 9)
			str[i] = ((adr & 0x0f) - 10) + 'A';
		else
			str[i] = (adr & 0x0f) + '0';
		adr = adr >> 4;
	}
}

