/*==========================================================================*/
/*Project Name:RUPUTER                                                 		*/
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. 	*/
/*                                                           	        	*/
/* Function Outline : Calculation of width of proportional font				*/
/*                                                                      	*/
/*==========================================================================*/

int getUsWdot(int scode, char *moji)
{
	const static unsigned char Ss[3] = {
		0x14,			/* scode=5 12dot */
		0x12,			/* scode=6 10dot */
		0x08			/* scode=7  8dot */
	};
	const static unsigned long Sp[3] = {
		0x253A80,		/* scode=5 12dot */
		0x254C00,		/* scode=6 10dot */
		0x255BC0		/* scode=7  8dot */
	};
	int	dot=0;

	scode-=5;
	/* Check sizecode */
	if ((unsigned int)scode>2) return( -1 );

	while (*moji) {
		dot+=*(unsigned char*)(Ss[scode]*((unsigned char)(*moji)-0x20)+Sp[scode]);
		moji++;
	}
	return( dot );
}

