/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include "b_common.h"

int bi_secread(int drv, int head, int cyl, int secno, int snum, void *rbuf)
{
	REGS	i_regs;
	REGS	o_regs;
	
	i_regs.d0 = INT_SECREAD;
	i_regs.d1 = head  & 0xffff;							/* Head number		*/
	i_regs.d1 = (i_regs.d1 << 8) | (drv & 0xff);		/* Drive number		*/
	i_regs.d2 = secno & 0xffff;							/* Sector number	*/
	i_regs.d2 = (i_regs.d2 << 8) | (cyl & 0xff);		/* Cylinder number	*/
	i_regs.a1 = snum  & 0xffff;							/* Number of sectors to be read	*/
	i_regs.a2 = (long)rbuf;								/* Read buffer address	*/

	_intbios( &i_regs, &o_regs);

	if ((int)o_regs.d1 == 0) {							/* Normal termination	*/
		return( (int)o_regs.d2);						/* Number of sectors read actually	*/
	} else {											/* Abnormal termination	*/
		BIOSerr = (int)o_regs.d1;						/* Set error code		*/
		return(-1);
	}
}

